DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -8.50886383385411E-12   0.00000000000000E+00  -3.15728012860804E-10   1.62007058817717E-22
      8.82476145374207E-09   8.50903344088143E-09  -7.92652838203070E-19  -2.49110336317874E-01  -2.49110336321284E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41073657029070E-09   0.00000000000000E+00   3.41073657029070E-09
      3.70243398395254E-18  -2.49110336317874E-01  -2.45355022493274E-01   0.00000000000000E+00   1.00220414234560E-11
     -9.83304508698173E-23  -1.19297920525960E-08  -1.19197700111727E-08  -2.90978114574948E-18
      1.17500000000000E-12
      0.00000000000000E+00  -8.51749723915162E-12   0.00000000000000E+00  -2.08520972757132E-11   1.58785907416959E-22
      8.53860979123379E-09   8.51775769395823E-09  -7.94640859345739E-19  -2.48252192543810E-01  -2.48252192547023E-01
      0.00000000000000E+00   0.00000000000000E+00   3.21239898787414E-09   0.00000000000000E+00   3.21239898787414E-09
      3.70460235326936E-18  -2.48252192543809E-01  -2.44556663160695E-01   0.00000000000000E+00   1.35338918115039E-11
     -9.83194162764512E-23  -1.17436905736427E-08  -1.17301566818313E-08  -2.90996149392362E-18
      2.08625000000000E-12
      0.00000000000000E+00  -8.52760016024444E-12   0.00000000000000E+00  -6.84222483901033E-13   1.53560790618243E-22
      8.52823904812605E-09   8.52755482564230E-09  -7.97023785080288E-19  -2.47244517435903E-01  -2.47244517438813E-01
      0.00000000000000E+00   0.00000000000000E+00   2.90984813472011E-09   0.00000000000000E+00   2.90984813472011E-09
      3.70725395238213E-18  -2.47244517435901E-01  -2.43641133222671E-01   0.00000000000000E+00   1.54907891211834E-11
     -9.83048023544922E-23  -1.14528937494824E-08  -1.14374029603613E-08  -2.91023016730184E-18
      3.31643750000000E-12
      0.00000000000000E+00  -8.53926444186980E-12   0.00000000000000E+00   3.44736255722759E-13   1.46828574695950E-22
      8.53891163904399E-09   8.53925637529986E-09  -7.99785651219569E-19  -2.46075878863368E-01  -2.46075878865888E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51986710761248E-09   0.00000000000000E+00   2.51986710761248E-09
      3.71035386139957E-18  -2.46075878863367E-01  -2.42591677183201E-01   0.00000000000000E+00   1.47291381760441E-11
     -9.82874633582828E-23  -1.10738526210870E-08  -1.10591234829111E-08  -2.91056821018000E-18
      4.97719062500000E-12
      0.00000000000000E+00  -8.55221454981606E-12   0.00000000000000E+00   3.38885672688249E-13   1.39286655803904E-22
      8.55193645524925E-09   8.55227534092208E-09  -8.02852569735717E-19  -2.44775766755821E-01  -2.44775766757899E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07744424577174E-09   0.00000000000000E+00   2.07744424577174E-09
      3.71380398342275E-18  -2.44775766755823E-01  -2.41426854953949E-01   0.00000000000000E+00   1.23675264180559E-11
     -9.82683441233636E-23  -1.06420871131112E-08  -1.06297195866933E-08  -2.91095141368703E-18
      7.21920734375000E-12
      0.00000000000000E+00  -8.56599126039719E-12   0.00000000000000E+00   3.02469373862762E-13   1.31596696493097E-22
      8.56571858724562E-09   8.56602105661961E-09  -8.06082300792530E-19  -2.43404171690080E-01  -2.43404171691701E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62093961322908E-09   0.00000000000000E+00   1.62093961322908E-09
      3.71743815713569E-18  -2.43404171690086E-01  -2.40194760917031E-01   0.00000000000000E+00   9.44504536470515E-12
     -9.82484254032575E-23  -1.01964057152131E-08  -1.01869606698485E-08  -2.91135585634316E-18
      1.02459299140625E-11
      0.00000000000000E+00  -8.57949243676670E-12   0.00000000000000E+00   2.79267650905011E-13   1.24357790593893E-22
      8.57934008133008E-09   8.57961934898111E-09  -8.09269512905735E-19  -2.42048458961079E-01  -2.42048458962266E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18680729878179E-09   0.00000000000000E+00   1.18680729878179E-09
      3.72103029357353E-18  -2.42048458961086E-01  -2.38971550820379E-01   0.00000000000000E+00   6.62890481849969E-12
     -9.82288968710125E-23  -9.77305555258182E-09  -9.76642664776342E-09  -2.91176078066779E-18
      1.43320053839844E-11
      0.00000000000000E+00  -8.59189147628971E-12   0.00000000000000E+00   2.65329520225226E-13   1.18089588251357E-22
      8.59177477238197E-09   8.59204010190231E-09  -8.12176075239529E-19  -2.40810670894355E-01  -2.40810670895162E-01
      0.00000000000000E+00   0.00000000000000E+00   8.06936964047888E-10   0.00000000000000E+00   8.06936964047888E-10
      3.72432749890810E-18  -2.40810670894360E-01  -2.37849541633418E-01   0.00000000000000E+00   4.25308220090678E-12
     -9.82110148461078E-23  -9.40323014815100E-09  -9.39897706595019E-09  -2.91215142366857E-18
      1.98482072683789E-11
      0.00000000000000E+00  -8.60217808685695E-12   0.00000000000000E+00   2.45069617592515E-13   1.13166796685539E-22
      8.60209181667188E-09   8.60233688628959E-09  -8.14587191411354E-19  -2.39783527978270E-01  -2.39783527978774E-01
      0.00000000000000E+00   0.00000000000000E+00   5.04434009104220E-10   0.00000000000000E+00   5.04434009104220E-10
      3.72711005873967E-18  -2.39783527978269E-01  -2.36914466577385E-01   0.00000000000000E+00   2.45981640937404E-12
     -9.81958110359303E-23  -9.10923071180298E-09  -9.10677089539371E-09  -2.91252286732831E-18
      2.72950798123115E-11
      0.00000000000000E+00  -8.60980120004518E-12   0.00000000000000E+00   2.02006153225458E-13   1.09742339274960E-22
      8.60974219625548E-09   8.60994420240881E-09  -8.16377478868363E-19  -2.39021762689104E-01  -2.39021762689393E-01
      0.00000000000000E+00   0.00000000000000E+00   2.88866339333489E-10   0.00000000000000E+00   2.88866339333489E-10
      3.72926120955092E-18  -2.39021762689128E-01  -2.36218216171755E-01   0.00000000000000E+00   1.26598746989138E-12
     -9.81837558952796E-23  -8.90007652921207E-09  -8.89881054174228E-09  -2.91288373068256E-18
      3.73483577466206E-11
      0.00000000000000E+00  -8.61476081585439E-12   0.00000000000000E+00   1.36351588875969E-13   1.07717385980898E-22
      8.61474884400530E-09   8.61488519559429E-09  -8.17553961132069E-19  -2.38523150870861E-01  -2.38523150871016E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54238492147646E-10   0.00000000000000E+00   1.54238492147646E-10
      3.73081181198065E-18  -2.38523150870939E-01  -2.35760448119195E-01   0.00000000000000E+00   5.85468275513265E-13
     -9.81745555811525E-23  -8.76970915601736E-09  -8.76912368774194E-09  -2.91325785084858E-18
      5.09202829579378E-11
      0.00000000000000E+00  -8.61769984744503E-12   0.00000000000000E+00   7.01041604301308E-14   1.06796767778502E-22
      8.61765974725587E-09   8.61772985141641E-09  -8.18244318773647E-19  -2.38233160519571E-01  -2.38233160519653E-01
      0.00000000000000E+00   0.00000000000000E+00   8.21830752681720E-11   0.00000000000000E+00   8.21830752681720E-11
      3.73192719453182E-18  -2.38233160519553E-01  -2.35492245272433E-01   0.00000000000000E+00   2.62279762479210E-13
     -9.81672255568395E-23  -8.70017520644694E-09  -8.69991292668456E-09  -2.91368287575817E-18
      6.92423819932160E-11
      0.00000000000000E+00  -8.61926120797756E-12   0.00000000000000E+00   2.62344687129740E-14   1.06617921788271E-22
      8.61926913716412E-09   8.61929537163294E-09  -8.18631827550413E-19  -2.38072713938435E-01  -2.38072713938485E-01
      0.00000000000000E+00   0.00000000000000E+00   4.97276530730362E-11   0.00000000000000E+00   4.97276530730362E-11
      3.73283830951622E-18  -2.38072713938076E-01  -2.35341518288723E-01   0.00000000000000E+00   1.34281182226692E-13
     -9.81604268598022E-23  -8.66915730588812E-09  -8.66902302470599E-09  -2.91420648196580E-18
      8.92423819932160E-11
      0.00000000000000E+00  -8.62017965534963E-12   0.00000000000000E+00   5.18416250323503E-15   1.06809527206503E-22
      8.62015509280020E-09   8.62016027696281E-09  -8.18846925830263E-19  -2.37984288749931E-01  -2.37984288749970E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82198614792527E-11   0.00000000000000E+00   3.82198614792527E-11
      3.73360270674580E-18  -2.37984288749181E-01  -2.35256440021847E-01   0.00000000000000E+00   9.60204733231655E-14
     -9.81542089838057E-23  -8.65847615891538E-09  -8.65838013844216E-09  -2.91475578091554E-18
      1.09242381993216E-10
      0.00000000000000E+00  -8.62073072377288E-12   0.00000000000000E+00   1.78523288006605E-15   1.07117311010514E-22
      8.62076107374760E-09   8.62076285898058E-09  -8.18992003532689E-19  -2.37923746281485E-01  -2.37923746281519E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41865938995865E-11   0.00000000000000E+00   3.41865938995865E-11
      3.73428643862379E-18  -2.37923746280423E-01  -2.35196977462360E-01   0.00000000000000E+00   7.98249174938420E-14
     -9.81484138725983E-23  -8.65502927779753E-09  -8.65494945288013E-09  -2.91529443509111E-18
      1.29242381993216E-10
      0.00000000000000E+00  -8.62128179219612E-12   0.00000000000000E+00   1.90452666268808E-15   1.07457457779253E-22
      8.62127228634017E-09   8.62127419086694E-09  -8.19110586084061E-19  -2.37872644271466E-01  -2.37872644271499E-01
      0.00000000000000E+00   0.00000000000000E+00   3.25138004645782E-11   0.00000000000000E+00   3.25138004645782E-11
      3.73493671463309E-18  -2.37872644270035E-01  -2.35146241434819E-01   0.00000000000000E+00   7.25634454113054E-14
     -9.81427949077844E-23  -8.65386055477679E-09  -8.65378799133148E-09  -2.91582612854902E-18
      1.49242381993216E-10
      0.00000000000000E+00  -8.62174101588216E-12   0.00000000000000E+00   1.37656066364892E-15   1.07804030730229E-22
      8.62174711577322E-09   8.62174849233399E-09  -8.19216653884391E-19  -2.37825169790662E-01  -2.37825169790693E-01
      0.00000000000000E+00   0.00000000000000E+00   3.16013674121386E-11   0.00000000000000E+00   3.16013674121386E-11
      3.73556874198133E-18  -2.37825169788526E-01  -2.35098904810848E-01   0.00000000000000E+00   6.99271367911278E-14
     -9.81372716627031E-23  -8.65341978688285E-09  -8.65334985974615E-09  -2.91635208809694E-18
      1.69242381993216E-10
      0.00000000000000E+00  -8.62220023956820E-12   0.00000000000000E+00   1.18200378129125E-15   1.08149107713796E-22
      8.62220418009373E-09   8.62220536209762E-09  -8.19314899162875E-19  -2.37779467682467E-01  -2.37779467682498E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09463242883730E-11   0.00000000000000E+00   3.09463242883730E-11
      3.73618766846709E-18  -2.37779467679906E-01  -2.35053265054588E-01   0.00000000000000E+00   6.82756286818889E-14
     -9.81318176679984E-23  -8.65321996201461E-09  -8.65315168638603E-09  -2.91687276930422E-18
      1.89242381993216E-10
      0.00000000000000E+00  -8.62265946325423E-12   0.00000000000000E+00   1.25931689786125E-15   1.08490377500455E-22
      8.62264964571865E-09   8.62265090503566E-09  -8.19407078459758E-19  -2.37734924080368E-01  -2.37734924080399E-01
      0.00000000000000E+00   0.00000000000000E+00   3.03895463361038E-11   0.00000000000000E+00   3.03895463361038E-11
      3.73679545939382E-18  -2.37734924078602E-01  -2.35008756497848E-01   0.00000000000000E+00   6.68286289558221E-14
     -9.81264223631856E-23  -8.65310728000064E-09  -8.65304045137178E-09  -2.91738838093406E-18
      2.09242381993216E-10
      0.00000000000000E+00  -8.62311868694027E-12   0.00000000000000E+00   1.06775987826279E-15   1.08827255289554E-22
      8.62308575674909E-09   8.62308682450908E-09  -8.19494006905917E-19  -2.37691315803081E-01  -2.37691315803110E-01
      0.00000000000000E+00   0.00000000000000E+00   2.98798744342429E-11   0.00000000000000E+00   2.98798744342429E-11
      3.73739305688250E-18  -2.37691315804140E-01  -2.34965171373273E-01   0.00000000000000E+00   6.58589552594901E-14
     -9.81210812777248E-23  -8.65303255789845E-09  -8.65296669894329E-09  -2.91789904997659E-18
      2.29242381993216E-10
      0.00000000000000E+00  -8.62357791062631E-12   0.00000000000000E+00   9.46073529652318E-16   1.09159703123565E-22
      8.62351348180209E-09   8.62351442787573E-09  -8.19576180988126E-19  -2.37648545647107E-01  -2.37648545647136E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93999164484615E-11   0.00000000000000E+00   2.93999164484615E-11
      3.73798105521147E-18  -2.37648545652441E-01  -2.34922417651771E-01   0.00000000000000E+00   6.49331442817042E-14
     -9.81157920266578E-23  -8.65297927746839E-09  -8.65291434432421E-09  -2.91840487422335E-18
      2.49242381993216E-10
      0.00000000000000E+00  -8.62394528957514E-12   0.00000000000000E+00   1.02337572609867E-15   1.09487826741674E-22
      8.62393338669629E-09   8.62393441007213E-09  -8.19653980163690E-19  -2.37606557387436E-01  -2.37606557387465E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89431721536040E-11   0.00000000000000E+00   2.89431721536040E-11
      3.73855991865455E-18  -2.37606557398803E-01  -2.34880440978559E-01   0.00000000000000E+00   6.38895919565060E-14
     -9.81105525428082E-23  -8.65294147181760E-09  -8.65287758222574E-09  -2.91890593849085E-18
      2.69242381993216E-10
      0.00000000000000E+00  -8.62440451326118E-12   0.00000000000000E+00   9.22979211044889E-16   1.09811777015948E-22
      8.62434588489171E-09   8.62434680787103E-09  -8.19727730281362E-19  -2.37565309623277E-01  -2.37565309623306E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85066108518971E-11   0.00000000000000E+00   2.85066108518971E-11
      3.73913005087158E-18  -2.37565309642090E-01  -2.34839200777069E-01   0.00000000000000E+00   6.30882023382281E-14
     -9.81053613525255E-23  -8.65291650692517E-09  -8.65285341872293E-09  -2.91940232059022E-18
      2.89242381993216E-10
      0.00000000000000E+00  -8.62477189221001E-12   0.00000000000000E+00   9.85225708109480E-16   1.10131705838676E-22
      8.62475132846752E-09   8.62475231369334E-09  -8.19797724722796E-19  -2.37524767327348E-01  -2.37524767327376E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80883596540537E-11   0.00000000000000E+00   2.80883596540537E-11
      3.73969181806466E-18  -2.37524767353176E-01  -2.34798662497414E-01   0.00000000000000E+00   6.21802316218570E-14
     -9.81002169443322E-23  -8.65290285357890E-09  -8.65284067334738E-09  -2.91989409334187E-18
      3.09242381993216E-10
      0.00000000000000E+00  -8.62513927115884E-12   0.00000000000000E+00   9.07681434596238E-16   1.10447761148755E-22
      8.62515003147990E-09   8.62515093916144E-09  -8.19864232870456E-19  -2.37484898935969E-01  -2.37484898935997E-01
      0.00000000000000E+00   0.00000000000000E+00   2.76870206775379E-11   0.00000000000000E+00   2.76870206775379E-11
      3.74024555847821E-18  -2.37484898964988E-01  -2.34758794913912E-01   0.00000000000000E+00   6.14606812196971E-14
     -9.80951180923957E-23  -8.65289942052012E-09  -8.65283795983900E-09  -2.92038132560776E-18
      3.29242381993216E-10
      0.00000000000000E+00  -8.62559849484488E-12   0.00000000000000E+00   9.50273949451809E-16   1.10760080209428E-22
      8.62554228787390E-09   8.62554323814796E-09  -8.19927503236961E-19  -2.37445675416807E-01  -2.37445675416835E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73013792375613E-11   0.00000000000000E+00   2.73013792375613E-11
      3.74079158606296E-18  -2.37445675440425E-01  -2.34719569279616E-01   0.00000000000000E+00   6.06647648859007E-14
     -9.80900635558401E-23  -8.65290528215030E-09  -8.65284461738551E-09  -2.92086408282601E-18
      3.49242381993216E-10
      0.00000000000000E+00  -8.62596587379370E-12   0.00000000000000E+00   8.90319849879234E-16   1.11068792710174E-22
      8.62592836484404E-09   8.62592925516400E-09  -8.19987765977042E-19  -2.37407069762318E-01  -2.37407069762345E-01
      0.00000000000000E+00   0.00000000000000E+00   2.69303693886934E-11   0.00000000000000E+00   2.69303693886934E-11
      3.74133019345074E-18  -2.37407069766557E-01  -2.34680958833186E-01   0.00000000000000E+00   6.00099579326417E-14
     -9.80850522718098E-23  -8.65291963451049E-09  -8.65285962455266E-09  -2.92134242747370E-18
      3.69242381993216E-10
      0.00000000000000E+00  -8.62633325274254E-12   0.00000000000000E+00   9.18042504971914E-16   1.11374018315277E-22
      8.62630851766152E-09   8.62630943570413E-09  -8.20045234056290E-19  -2.37369056832950E-01  -2.37369056832977E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65729986295383E-11   0.00000000000000E+00   2.65729986295383E-11
      3.74186165342333E-18  -2.37369056798966E-01  -2.34642938662522E-01   0.00000000000000E+00   5.93024194854352E-14
     -9.80800831934401E-23  -8.65294173675305E-09  -8.65288243433366E-09  -2.92181641936704E-18
      3.89242381993216E-10
      0.00000000000000E+00  -8.62670063169137E-12   0.00000000000000E+00   8.71297579723288E-16   1.11675869790034E-22
      8.62668297734666E-09   8.62668384864435E-09  -8.20100104902119E-19  -2.37331613122177E-01  -2.37331613122203E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62283734250294E-11   0.00000000000000E+00   2.62283734250294E-11
      3.74238622089183E-18  -2.37331613029282E-01  -2.34605485467940E-01   0.00000000000000E+00   5.87002771355656E-14
     -9.80751553947234E-23  -8.65297092234647E-09  -8.65291222206944E-09  -2.92228611598971E-18
      4.09242381993216E-10
      0.00000000000000E+00  -8.62706801064019E-12   0.00000000000000E+00   8.88239777558030E-16   1.11974451376388E-22
      8.62705196455874E-09   8.62705285279863E-09  -8.20152561274127E-19  -2.37294716687731E-01  -2.37294716687757E-01
      0.00000000000000E+00   0.00000000000000E+00   2.58956546374581E-11   0.00000000000000E+00   2.58956546374581E-11
      3.74290413398458E-18  -2.37294716519553E-01  -2.34568577506384E-01   0.00000000000000E+00   5.80625811290626E-14
     -9.80702679809137E-23  -8.65300657001705E-09  -8.65294850743602E-09  -2.92275157271045E-18
      4.29242381993216E-10
      0.00000000000000E+00  -8.62743538958903E-12   0.00000000000000E+00   8.51403418804161E-16   1.12269861374640E-22
      8.62741567975219E-09   8.62741653115572E-09  -8.20202772597476E-19  -2.37258346978092E-01  -2.37258346978118E-01
      0.00000000000000E+00   0.00000000000000E+00   2.55740824963665E-11   0.00000000000000E+00   2.55740824963665E-11
      3.74341561563451E-18  -2.37258346732683E-01  -2.34532194416937E-01   0.00000000000000E+00   5.75036373599965E-14
     -9.80654201438630E-23  -8.65304811728944E-09  -8.65299061365218E-09  -2.92321284303703E-18
      4.49242381993216E-10
      0.00000000000000E+00  -8.62780276853786E-12   0.00000000000000E+00   8.60607824781917E-16   1.12562190892936E-22
      8.62777431317414E-09   8.62777517378208E-09  -8.20250895727674E-19  -2.37222484774802E-01  -2.37222484774827E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52629435978791E-11   0.00000000000000E+00   2.52629435978791E-11
      3.74392087450647E-18  -2.37222484477994E-01  -2.34496317173781E-01   0.00000000000000E+00   5.69214410192298E-14
     -9.80606111116329E-23  -8.65309503882087E-09  -8.65303811737995E-09  -2.92366997877879E-18
      4.69242381993216E-10
      0.00000000000000E+00  -8.62817014748668E-12   0.00000000000000E+00   8.31203461503467E-16   1.12851525946084E-22
      8.62812803820713E-09   8.62812886941070E-09  -8.20297076063267E-19  -2.37187112052458E-01  -2.37187112052483E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49615898565616E-11   0.00000000000000E+00   2.49615898565616E-11
      3.74442010630360E-18  -2.37187111772275E-01  -2.34460927943234E-01   0.00000000000000E+00   5.63981515526261E-14
     -9.80558401769816E-23  -8.65314685741868E-09  -8.65309045926723E-09  -2.92412303024033E-18
      4.89242381993216E-10
      0.00000000000000E+00  -8.62844568169831E-12   0.00000000000000E+00   8.34903678921819E-16   1.13137946495390E-22
      8.62847702047868E-09   8.62847785538247E-09  -8.20341448213201E-19  -2.37152211931888E-01  -2.37152211931912E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46694119956042E-11   0.00000000000000E+00   2.46694119956042E-11
      3.74491349454351E-18  -2.37152211789693E-01  -2.34426010039268E-01   0.00000000000000E+00   5.58603577038326E-14
     -9.80511066675310E-23  -8.65320312773574E-09  -8.65314726737814E-09  -2.92457204633031E-18
      5.09242381993216E-10
      0.00000000000000E+00  -8.62881306064714E-12   0.00000000000000E+00   8.11095881755189E-16   1.13421528169821E-22
      8.62882141369875E-09   8.62882222479474E-09  -8.20384136925306E-19  -2.37117768568293E-01  -2.37117768568317E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43858537123591E-11   0.00000000000000E+00   2.43858537123591E-11
      3.74540121161776E-18  -2.37117768739169E-01  -2.34391547797614E-01   0.00000000000000E+00   5.53667180792540E-14
     -9.80464099594211E-23  -8.65326344522504E-09  -8.65320807850706E-09  -2.92501707469245E-18
      5.29242381993216E-10
      0.00000000000000E+00  -8.62918043959597E-12   0.00000000000000E+00   8.10949256554542E-16   1.13702341580117E-22
      8.62916137216022E-09   8.62916218310959E-09  -8.20425257637840E-19  -2.37083767126366E-01  -2.37083767126390E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41103885225891E-11   0.00000000000000E+00   2.41103885225891E-11
      3.74588341938821E-18  -2.37083767819644E-01  -2.34357526534498E-01   0.00000000000000E+00   5.48647952327270E-14
     -9.80417494571238E-23  -8.65332743642730E-09  -8.65327257163217E-09  -2.92545816175037E-18
      5.49242381993216E-10
      0.00000000000000E+00  -8.62954781854480E-12   0.00000000000000E+00   7.91420081245198E-16   1.13980453698820E-22
      8.62949704356823E-09   8.62949783498842E-09  -8.20464917276089E-19  -2.37050193682168E-01  -2.37050193682192E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38425331172391E-11   0.00000000000000E+00   2.38425331172391E-11
      3.74636027005055E-18  -2.37050195092060E-01  -2.34323932416568E-01   0.00000000000000E+00   5.43961420471248E-14
     -9.80371245984058E-23  -8.65339476424764E-09  -8.65334036810569E-09  -2.92589535277447E-18
      5.69242381993216E-10
      0.00000000000000E+00  -8.62982335275642E-12   0.00000000000000E+00   7.88688386071031E-16   1.14255927361276E-22
      8.62982858322652E-09   8.62982937191502E-09  -8.20503214715445E-19  -2.37017035211029E-01  -2.37017035211052E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35818267250608E-11   0.00000000000000E+00   2.35818267250608E-11
      3.74683190658505E-18  -2.37017037429594E-01  -2.34290752413257E-01   0.00000000000000E+00   5.39237106999156E-14
     -9.80325348381182E-23  -8.65346512235065E-09  -8.65341119864005E-09  -2.92632869186961E-18
      5.89242381993216E-10
      0.00000000000000E+00  -8.63019073170525E-12   0.00000000000000E+00   7.72527153561972E-16   1.14528822414509E-22
      8.63015614858946E-09   8.63015692111673E-09  -8.20540241445129E-19  -2.36984279510229E-01  -2.36984279510252E-01
      0.00000000000000E+00   0.00000000000000E+00   2.33278431131934E-11   0.00000000000000E+00   2.33278431131934E-11
      3.74729846344732E-18  -2.36984282402914E-01  -2.34257974179880E-01   0.00000000000000E+00   5.34766465420666E-14
     -9.80279796495985E-23  -8.65353824087630E-09  -8.65348476422985E-09  -2.92675822200219E-18
      6.09242381993216E-10
      0.00000000000000E+00  -8.63046626591687E-12   0.00000000000000E+00   7.68192500917859E-16   1.14799195251548E-22
      8.63047990440488E-09   8.63048067259749E-09  -8.20576082014732E-19  -2.36951915169682E-01  -2.36951915169705E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30801782325035E-11   0.00000000000000E+00   2.30801782325035E-11
      3.74776006701197E-18  -2.36951918227888E-01  -2.34225586007713E-01   0.00000000000000E+00   5.30291257160223E-14
     -9.80234585127302E-23  -8.65361387995576E-09  -8.65356085083014E-09  -2.92718398499724E-18
      6.29242381993216E-10
      0.00000000000000E+00  -8.63083364486570E-12   0.00000000000000E+00   7.54724277705311E-16   1.15067099608491E-22
      8.63080000812559E-09   8.63080076284999E-09  -8.20610814678007E-19  -2.36919931470004E-01  -2.36919931470026E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28384652924751E-11   0.00000000000000E+00   2.28384652924751E-11
      3.74821683631782E-18  -2.36919933676586E-01  -2.34193576734759E-01   0.00000000000000E+00   5.26012563282426E-14
     -9.80189709195066E-23  -8.65369182939870E-09  -8.65363922814247E-09  -2.92760602163981E-18
      6.49242381993216E-10
      0.00000000000000E+00  -8.63110917907733E-12   0.00000000000000E+00   7.49415897881174E-16   1.15332585979874E-22
      8.63111660126338E-09   8.63111735067939E-09  -8.20644511898974E-19  -2.36888318302770E-01  -2.36888318302792E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26023709976234E-11   0.00000000000000E+00   2.26023709976234E-11
      3.74866888373777E-18  -2.36888318073093E-01  -2.34161935745554E-01   0.00000000000000E+00   5.21752075304557E-14
     -9.80145163735649E-23  -8.65377189688432E-09  -8.65371972167688E-09  -2.92802437183880E-18
      6.69242381993216E-10
      0.00000000000000E+00  -8.63147655802616E-12   0.00000000000000E+00   7.37912036840282E-16   1.15595701956796E-22
      8.63142977714791E-09   8.63143051506006E-09  -8.20677241077025E-19  -2.36857066001360E-01  -2.36857066001383E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23716165708467E-11   0.00000000000000E+00   2.23716165708467E-11
      3.74911631606919E-18  -2.36857061288349E-01  -2.34130652969482E-01   0.00000000000000E+00   5.17642921622624E-14
     -9.80100944112459E-23  -8.65385389592304E-09  -8.65380213163097E-09  -2.92843907499216E-18
      6.89242381993216E-10
      0.00000000000000E+00  -8.63175209223778E-12   0.00000000000000E+00   7.31662805425244E-16   1.15856491405794E-22
      8.63173955555420E-09   8.63174028721712E-09  -8.20709065175236E-19  -2.36826165182982E-01  -2.36826165183004E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21459799768096E-11   0.00000000000000E+00   2.21459799768096E-11
      3.74955923566872E-18  -2.36826153849339E-01  -2.34099718997322E-01   0.00000000000000E+00   5.13560209984050E-14
     -9.80057046215350E-23  -8.65393762321481E-09  -8.65388626719391E-09  -2.92885017049349E-18
      7.09242381993216E-10
      0.00000000000000E+00  -8.63202762644940E-12   0.00000000000000E+00   7.20975647465212E-16   1.16114994452553E-22
      8.63204584176497E-09   8.63204656274073E-09  -8.20740043505831E-19  -2.36795606524238E-01  -2.36795606524260E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19253143880278E-11   0.00000000000000E+00   2.19253143880278E-11
      3.74999774195648E-18  -2.36795587076038E-01  -2.34069125225218E-01   0.00000000000000E+00   5.09583014191086E-14
     -9.80013466879883E-23  -8.65402283543006E-09  -8.65397187712874E-09  -2.92925769845065E-18
      7.29242381993216E-10
      0.00000000000000E+00  -8.63239500539823E-12   0.00000000000000E+00   7.13072071269192E-16   1.16371246711676E-22
      8.63234840745438E-09   8.63234912052657E-09  -8.20770232326440E-19  -2.36765380596761E-01  -2.36765380596783E-01
      0.00000000000000E+00   0.00000000000000E+00   2.17095398007476E-11   0.00000000000000E+00   2.17095398007476E-11
      3.75043193275250E-18  -2.36765353312895E-01  -2.34038864094877E-01   0.00000000000000E+00   5.05619406316570E-14
     -9.79970204224386E-23  -8.65410922226786E-09  -8.65405866032733E-09  -2.92966170042606E-18
      7.49242381993216E-10
      0.00000000000000E+00  -8.63267053960985E-12   0.00000000000000E+00   7.01650046231111E-16   1.16625279653240E-22
      8.63264689094552E-09   8.63264759259568E-09  -8.20799685307604E-19  -2.36735477764275E-01  -2.36735477764296E-01
      0.00000000000000E+00   0.00000000000000E+00   2.14986312724515E-11   0.00000000000000E+00   2.14986312724515E-11
      3.75086190537795E-18  -2.36735446143622E-01  -2.34008929311905E-01   0.00000000000000E+00   5.01706556497198E-14
     -9.79927258033938E-23  -8.65419639452368E-09  -8.65414622386813E-09  -2.93006222007034E-18
      7.69242381993216E-10
      0.00000000000000E+00  -8.63294607382148E-12   0.00000000000000E+00   6.91166418453680E-16   1.16877121025123E-22
      8.63294085642266E-09   8.63294154758920E-09  -8.20828453476753E-19  -2.36705888300414E-01  -2.36705888300435E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12925654958723E-11   0.00000000000000E+00   2.12925654958723E-11
      3.75128775668786E-18  -2.36705860550181E-01  -2.33979316002983E-01   0.00000000000000E+00   4.97777866445012E-14
     -9.79884629737935E-23  -8.65428389087159E-09  -8.65423411308505E-09  -2.93045930321111E-18
      7.89242381993216E-10
      0.00000000000000E+00  -8.63322160803310E-12   0.00000000000000E+00   6.78245077447414E-16   1.17126797053668E-22
      8.63322991902317E-09   8.63323059726837E-09  -8.20856584575217E-19  -2.36676602780541E-01  -2.36676602780562E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10912453908628E-11   0.00000000000000E+00   2.10912453908628E-11
      3.75170958159568E-18  -2.36676592824319E-01  -2.33950020611645E-01   0.00000000000000E+00   4.93851248966821E-14
     -9.79842321979915E-23  -8.65437122778407E-09  -8.65432184265928E-09  -2.93085299702047E-18
      8.09242381993216E-10
      0.00000000000000E+00  -8.63349714224472E-12   0.00000000000000E+00   6.66121282212481E-16   1.17374335756411E-22
      8.63351397589200E-09   8.63351464201339E-09  -8.20884121411792E-19  -2.36647612924376E-01  -2.36647612924397E-01
      0.00000000000000E+00   0.00000000000000E+00   2.08943734842157E-11   0.00000000000000E+00   2.08943734842157E-11
      3.75212746906537E-18  -2.36647640120622E-01  -2.33921040418396E-01   0.00000000000000E+00   4.89901506302521E-14
     -9.79800337226490E-23  -8.65445800564817E-09  -8.65440901549764E-09  -2.93124334765357E-18
      8.29242381993216E-10
      0.00000000000000E+00  -8.63377267645634E-12   0.00000000000000E+00   6.54533631946194E-16   1.17619772272786E-22
      8.63379351009714E-09   8.63379416463089E-09  -8.20911099370739E-19  -2.36618912839719E-01  -2.36618912839739E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07013176936315E-11   0.00000000000000E+00   2.07013176936315E-11
      3.75254149541924E-18  -2.36618999391679E-01  -2.33892372422305E-01   0.00000000000000E+00   4.85970358134343E-14
     -9.79758675451164E-23  -8.65454407936027E-09  -8.65449548232456E-09  -2.93163039604850E-18
      8.49242381993216E-10
      0.00000000000000E+00  -8.63404821066797E-12   0.00000000000000E+00   6.46855243294055E-16   1.17863155122724E-22
      8.63406995680585E-09   8.63407060366121E-09  -8.20937543096434E-19  -2.36590500647363E-01  -2.36590500647384E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05109721719246E-11   0.00000000000000E+00   2.05109721719246E-11
      3.75295171486268E-18  -2.36590665666863E-01  -2.33864011548264E-01   0.00000000000000E+00   4.82113898930021E-14
     -9.79717330603662E-23  -8.65462978722289E-09  -8.65458157583310E-09  -2.93201417176624E-18
      8.69242381993217E-10
      0.00000000000000E+00  -8.63432374487959E-12   0.00000000000000E+00   6.45737361703376E-16   1.18104552561457E-22
      8.63434600963443E-09   8.63434665537191E-09  -8.20963463248667E-19  -2.36562380093866E-01  -2.36562380093886E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03216999973267E-11   0.00000000000000E+00   2.03216999973267E-11
      3.75335814886262E-18  -2.36562629646007E-01  -2.33835948162197E-01   0.00000000000000E+00   4.78448306405476E-14
     -9.79676286519269E-23  -8.65471620019974E-09  -8.65466835536920E-09  -2.93239468561396E-18
      8.79242381993216E-10
      0.00000000000000E+00  -8.63450743435401E-12   0.00000000000000E+00   6.49241080906206E-16   1.18224796318572E-22
      8.63448435546323E-09   8.63448500470443E-09  -8.20976292804805E-19  -2.36548393595579E-01  -2.36548393595599E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02270574060616E-11   0.00000000000000E+00   2.02270574060616E-11
      3.75356041943669E-18  -2.36548684501351E-01  -2.33821989235749E-01   0.00000000000000E+00   4.76645411987520E-14
     -9.79655840827808E-23  -8.65475972665160E-09  -8.65471206211050E-09  -2.93258412663188E-18
      8.80929881993216E-10
      0.00000000000000E+00  -8.63450743435401E-12   0.00000000000000E+00   6.54825218084798E-16   1.18245068358042E-22
      8.63450795964078E-09   8.63450861446611E-09  -8.20978453716182E-19  -2.36546035652839E-01  -2.36546035652860E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02107590565956E-11   0.00000000000000E+00   2.02107590565956E-11
      3.75359452509259E-18  -2.36546333387393E-01  -2.33819635815570E-01   0.00000000000000E+00   4.76388450413528E-14
     -9.79652384877739E-23  -8.65476701236699E-09  -8.65471937352205E-09  -2.93261607137641E-18
      8.83208006993216E-10
      0.00000000000000E+00  -8.63450743435401E-12   0.00000000000000E+00   6.50154792213250E-16   1.18272416783499E-22
      8.63453961138117E-09   8.63454026153608E-09  -8.20981364104257E-19  -2.36542856296341E-01  -2.36542856296362E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01891169739978E-11   0.00000000000000E+00   2.01891169739978E-11
      3.75364051842470E-18  -2.36543163116575E-01  -2.33816462389820E-01   0.00000000000000E+00   4.75977201227159E-14
     -9.79647734092504E-23  -8.65477697622971E-09  -8.65472937850968E-09  -2.93265915432044E-18
      8.86283475743216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.49706683083147E-16   1.18309297661258E-22
      8.63458231436905E-09   8.63458296407585E-09  -8.20985280867317E-19  -2.36538571169652E-01  -2.36538571169672E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01600194112445E-11   0.00000000000000E+00   2.01600194112445E-11
      3.75370251993440E-18  -2.36538889980013E-01  -2.33812184963143E-01   0.00000000000000E+00   4.75444902095258E-14
     -9.79641460125618E-23  -8.65479052797715E-09  -8.65474298348704E-09  -2.93271723906708E-18
      8.90435358555716E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.51202195022328E-16   1.18359007999330E-22
      8.63464009051637E-09   8.63464074171868E-09  -8.20990546104278E-19  -2.36532799114655E-01  -2.36532799114675E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01207150889660E-11   0.00000000000000E+00   2.01207150889660E-11
      3.75378605878555E-18  -2.36533133387870E-01  -2.33806422545768E-01   0.00000000000000E+00   4.74749278825215E-14
     -9.79633001552637E-23  -8.65480893173489E-09  -8.65476145680710E-09  -2.93279551268127E-18
      8.96040400352591E-10
      0.00000000000000E+00  -8.63469112382842E-12   0.00000000000000E+00   6.54395070189719E-16   1.18425970361909E-22
      8.63471845258775E-09   8.63471910698294E-09  -8.20997613033455E-19  -2.36525030608553E-01  -2.36525030608573E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00675115158444E-11   0.00000000000000E+00   2.00675115158444E-11
      3.75389853802636E-18  -2.36525383766346E-01  -2.33798664990033E-01   0.00000000000000E+00   4.73842308824512E-14
     -9.79621603242259E-23  -8.65483400272935E-09  -8.65478661849856E-09  -2.93290092499290E-18
      9.03607206778373E-10
      0.00000000000000E+00  -8.63478296856563E-12   0.00000000000000E+00   6.60624650503003E-16   1.18516104620363E-22
      8.63482519663674E-09   8.63482585726151E-09  -8.21007077281355E-19  -2.36514587362494E-01  -2.36514587362514E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99952896108225E-11   0.00000000000000E+00   1.99952896108225E-11
      3.75404983851227E-18  -2.36514960370391E-01  -2.33788230706463E-01   0.00000000000000E+00   4.72684079928221E-14
     -9.79606251267295E-23  -8.65486841528032E-09  -8.65482114687243E-09  -2.93304276123091E-18
      9.13822395453177E-10
      0.00000000000000E+00  -8.63496665804004E-12   0.00000000000000E+00   6.72929369380864E-16   1.18637316937885E-22
      8.63497184102819E-09   8.63497251395767E-09  -8.21019711459857E-19  -2.36500572331701E-01  -2.36500572331721E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98967259284205E-11   0.00000000000000E+00   1.98967259284205E-11
      3.75425308732164E-18  -2.36500955602547E-01  -2.33774210774205E-01   0.00000000000000E+00   4.71270574368458E-14
     -9.79585584470984E-23  -8.65491636694351E-09  -8.65486923988617E-09  -2.93323337586178E-18
      9.27612900164164E-10
      0.00000000000000E+00  -8.63515034751446E-12   0.00000000000000E+00   6.97321474546825E-16   1.18800143376534E-22
      8.63517659385754E-09   8.63517729117914E-09  -8.21036495187710E-19  -2.36481812019882E-01  -2.36481812019902E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97609187510369E-11   0.00000000000000E+00   1.97609187510369E-11
      3.75452560036477E-18  -2.36482159353204E-01  -2.33755392778771E-01   0.00000000000000E+00   4.69710213446005E-14
     -9.79557769519965E-23  -8.65498518095145E-09  -8.65493820993020E-09  -2.93348910517706E-18
      9.46230081523995E-10
      0.00000000000000E+00  -8.63551772646329E-12   0.00000000000000E+00   7.87273503086996E-16   1.19018623234442E-22
      8.63547008699131E-09   8.63547087426493E-09  -8.21058624126186E-19  -2.36456797578463E-01  -2.36456797578482E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95715002338323E-11   0.00000000000000E+00   1.95715002338323E-11
      3.75488996653410E-18  -2.36456947538651E-01  -2.33730148138199E-01   0.00000000000000E+00   4.67920622302711E-14
     -9.79520402669596E-23  -8.65508916656088E-09  -8.65504237449875E-09  -2.93383134240792E-18
      9.51230081523995E-10
      0.00000000000000E+00  -8.63560957120050E-12   0.00000000000000E+00   7.57070858835455E-16   1.19077185477006E-22
      8.63555033656441E-09   8.63555109363539E-09  -8.21064528005958E-19  -2.36450102580816E-01  -2.36450102580835E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95199776153401E-11   0.00000000000000E+00   1.95199776153401E-11
      3.75498756642218E-18  -2.36450187482604E-01  -2.33723379021108E-01   0.00000000000000E+00   4.68051228097121E-14
     -9.79510257879806E-23  -8.65511787637371E-09  -8.65507107125100E-09  -2.93392303841622E-18
      9.57980081523995E-10
      0.00000000000000E+00  -8.63570141593770E-12   0.00000000000000E+00   7.75711284949234E-16   1.19156108608677E-22
      8.63566120713610E-09   8.63566198284751E-09  -8.21072425914189E-19  -2.36441107067366E-01  -2.36441107067386E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94497769494731E-11   0.00000000000000E+00   1.94497769494731E-11
      3.75511885241659E-18  -2.36441079336757E-01  -2.33714258048032E-01   0.00000000000000E+00   4.67747148631125E-14
     -9.79496689882062E-23  -8.65515853451170E-09  -8.65511175979694E-09  -2.93404642650240E-18
      9.67092581523995E-10
      0.00000000000000E+00  -8.63579326067491E-12   0.00000000000000E+00   8.03572790758283E-16   1.19262370078765E-22
      8.63581598830391E-09   8.63581679187682E-09  -8.21082953251369E-19  -2.36429043004808E-01  -2.36429043004828E-01
      0.00000000000000E+00   0.00000000000000E+00   1.93535112467701E-11   0.00000000000000E+00   1.93535112467701E-11
      3.75529521128783E-18  -2.36428810592358E-01  -2.33701970848367E-01   0.00000000000000E+00   4.67547692234393E-14
     -9.79478377923707E-23  -8.65521705789269E-09  -8.65517030312356E-09  -2.93421225803646E-18
      9.79394456523995E-10
      0.00000000000000E+00  -8.63606879488653E-12   0.00000000000000E+00   8.41637792356953E-16   1.19405300414034E-22
      8.63603435154465E-09   8.63603519318256E-09  -8.21096916896851E-19  -2.36412904746027E-01  -2.36412904746046E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92214705150962E-11   0.00000000000000E+00   1.92214705150962E-11
      3.75553167141542E-18  -2.36412283597178E-01  -2.33685416630187E-01   0.00000000000000E+00   4.67616946777045E-14
     -9.79453646241201E-23  -8.65530342539212E-09  -8.65525666369754E-09  -2.93443475451857E-18
      9.96001987773995E-10
      0.00000000000000E+00  -8.63634432909816E-12   0.00000000000000E+00   8.80695554082690E-16   1.19597272530715E-22
      8.63634214708405E-09   8.63634302777972E-09  -8.21115342451339E-19  -2.36391379307046E-01  -2.36391379307065E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90436105142295E-11   0.00000000000000E+00   1.90436105142295E-11
      3.75584793877215E-18  -2.36390007893553E-01  -2.33663099957639E-01   0.00000000000000E+00   4.68059857317453E-14
     -9.79420215854043E-23  -8.65543344427962E-09  -8.65538663829399E-09  -2.93473259632081E-18
      1.01600198777400E-09
      0.00000000000000E+00  -8.63671170804699E-12   0.00000000000000E+00   8.73835051783894E-16   1.19826769172885E-22
      8.63670996041262E-09   8.63671083424780E-09  -8.21137083992261E-19  -2.36365763394667E-01  -2.36365763394686E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88445332925922E-11   0.00000000000000E+00   1.88445332925922E-11
      3.75622482943800E-18  -2.36363218010979E-01  -2.33636256892179E-01   0.00000000000000E+00   4.68046959921712E-14
     -9.79379948194590E-23  -8.65560217223626E-09  -8.65555536754037E-09  -2.93508774544574E-18
      1.03600198777400E-09
      0.00000000000000E+00  -8.63698724225861E-12   0.00000000000000E+00   7.65615792492707E-16   1.20054010531769E-22
      8.63703477757725E-09   8.63703554319316E-09  -8.21158715922453E-19  -2.36340302702165E-01  -2.36340302702184E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86827860665576E-11   0.00000000000000E+00   1.86827860665576E-11
      3.75659848515933E-18  -2.36336519366438E-01  -2.33609506881122E-01   0.00000000000000E+00   4.65775371071872E-14
     -9.79339880245745E-23  -8.65576490679678E-09  -8.65571832925977E-09  -2.93543976923688E-18
      1.05600198777400E-09
      0.00000000000000E+00  -8.63726277647023E-12   0.00000000000000E+00   6.58795528877883E-16   1.20278112719208E-22
      8.63725441091773E-09   8.63725506971338E-09  -8.21180789965029E-19  -2.36314745422411E-01  -2.36314745422429E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85886595185900E-11   0.00000000000000E+00   1.85886595185900E-11
      3.75697025834970E-18  -2.36310079783247E-01  -2.33583027814278E-01   0.00000000000000E+00   4.57185482295990E-14
     -9.79300711361511E-23  -8.65588944778006E-09  -8.65584372923193E-09  -2.93578946838467E-18
      1.06100198777400E-09
      0.00000000000000E+00  -8.63726277647023E-12   0.00000000000000E+00   3.63432146753932E-16   1.20333973749055E-22
      8.63730269318308E-09   8.63730305661535E-09  -8.21186342507821E-19  -2.36308347129634E-01  -2.36308347129653E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85687174628162E-11   0.00000000000000E+00   1.85687174628162E-11
      3.75706310193702E-18  -2.36303489265384E-01  -2.33576428382422E-01   0.00000000000000E+00   4.57438796610866E-14
     -9.79303205498336E-23  -8.65591751795750E-09  -8.65587177407794E-09  -2.93587675942920E-18
      1.06775198777400E-09
      0.00000000000000E+00  -8.63735462120744E-12   0.00000000000000E+00   3.11350556530891E-16   1.20408757768896E-22
      8.63735031313807E-09   8.63735062448875E-09  -8.21193930415068E-19  -2.36299679284541E-01  -2.36299679284560E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85526982071262E-11   0.00000000000000E+00   1.85526982071262E-11
      3.75718833264991E-18  -2.36294636586639E-01  -2.33567565780052E-01   0.00000000000000E+00   4.53141335830306E-14
     -9.79277608806814E-23  -8.65594863682940E-09  -8.65590332269591E-09  -2.93599440223484E-18
      1.07686448777400E-09
      0.00000000000000E+00  -8.63744646594465E-12   0.00000000000000E+00   1.06700884771920E-16   1.20508917936772E-22
      8.63737704060239E-09   8.63737714730340E-09  -8.21204414517506E-19  -2.36287889267290E-01  -2.36287889267309E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85519895751969E-11   0.00000000000000E+00   1.85519895751969E-11
      3.75735738765492E-18  -2.36282795534772E-01  -2.33555716584085E-01   0.00000000000000E+00   4.46802783198982E-14
     -9.79259994911056E-23  -8.65597381715681E-09  -8.65592913687859E-09  -2.93615297313741E-18
      1.08916636277400E-09
      0.00000000000000E+00  -8.63735462120744E-12   0.00000000000000E+00  -2.51929063082674E-16   1.20642091304447E-22
      8.63732416512083E-09   8.63732391319189E-09  -8.21219205700948E-19  -2.36271718883270E-01  -2.36271718883288E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85962469892023E-11   0.00000000000000E+00   1.85962469892023E-11
      3.75758615636085E-18  -2.36267107961077E-01  -2.33540031823491E-01   0.00000000000000E+00   4.34689381558872E-14
     -9.79237055092262E-23  -8.65596362911914E-09  -8.65592016018108E-09  -2.93636695065990E-18
      1.10577389402400E-09
      0.00000000000000E+00  -8.63707908699582E-12   0.00000000000000E+00  -8.78942966594956E-16   1.20817225400536E-22
      8.63704357894984E-09   8.63704270000699E-09  -8.21240849073465E-19  -2.36249185475511E-01  -2.36249185475529E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87500719130784E-11   0.00000000000000E+00   1.87500719130784E-11
      3.75789754876609E-18  -2.36246791711881E-01  -2.33519755687707E-01   0.00000000000000E+00   4.10482520352048E-14
     -9.79207879324232E-23  -8.65583382017204E-09  -8.65579277192010E-09  -2.93665669969262E-18
      1.12577389402400E-09
      0.00000000000000E+00  -8.63643617383536E-12   0.00000000000000E+00  -1.72395184190498E-15   1.21020327058675E-22
      8.63636199779909E-09   8.63636027384737E-09  -8.21269990917673E-19  -2.36220717600440E-01  -2.36220717600459E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90591549788861E-11   0.00000000000000E+00   1.90591549788861E-11
      3.75827873186566E-18  -2.36224237181659E-01  -2.33497318759825E-01   0.00000000000000E+00   3.69650679892659E-14
     -9.79176377316682E-23  -8.65545639389430E-09  -8.65541942882640E-09  -2.93700874094799E-18
      1.13577389402400E-09
      0.00000000000000E+00  -8.63597695014933E-12   0.00000000000000E+00  -2.55060819391560E-15   1.21119896320228E-22
      8.63593882269714E-09   8.63593627208906E-09  -8.21285360351614E-19  -2.36206135248303E-01  -2.36206135248323E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92357946779093E-11   0.00000000000000E+00   1.92357946779093E-11
      3.75847108981244E-18  -2.36213523539889E-01  -2.33486682907913E-01   0.00000000000000E+00   3.50961412113079E-14
     -9.79161756289618E-23  -8.65520716290811E-09  -8.65517206676700E-09  -2.93718572946083E-18
      1.14927389402400E-09
      0.00000000000000E+00  -8.63524219225167E-12   0.00000000000000E+00  -2.69100360575933E-15   1.21250676603855E-22
      8.63521921156452E-09   8.63521652056103E-09  -8.21307615475750E-19  -2.36185785205821E-01  -2.36185785205841E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95093417110752E-11   0.00000000000000E+00   1.95093417110752E-11
      3.75873446592554E-18  -2.36200281288710E-01  -2.33473581347987E-01   0.00000000000000E+00   3.11985828533301E-14
     -9.79143759754636E-23  -8.65475706085480E-09  -8.65472586227204E-09  -2.93742685044979E-18
      1.16749889402400E-09
      0.00000000000000E+00  -8.63414005540518E-12   0.00000000000000E+00  -2.94144371153742E-15   1.21422707811851E-22
      8.63415522692159E-09   8.63415228547800E-09  -8.21339338149794E-19  -2.36157579185961E-01  -2.36157579185981E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98014877981388E-11   0.00000000000000E+00   1.98014877981388E-11
      3.75909534804066E-18  -2.36184898393373E-01  -2.33458441685936E-01   0.00000000000000E+00   2.66754115133060E-14
     -9.79123254087441E-23  -8.65398044868764E-09  -8.65395377327623E-09  -2.93775600989087E-18
      1.18749889402399E-09
      0.00000000000000E+00  -8.63322160803310E-12   0.00000000000000E+00  -2.15189642509648E-15   1.21612496893666E-22
      8.63330778000415E-09   8.63330562810784E-09  -8.21372827590520E-19  -2.36127269608973E-01  -2.36127269608992E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97795268293233E-11   0.00000000000000E+00   1.97795268293233E-11
      3.75949093857725E-18  -2.36170611324860E-01  -2.33444428263016E-01   0.00000000000000E+00   2.38433988729051E-14
     -9.79103101400211E-23  -8.65310899833592E-09  -8.65308515493715E-09  -2.93811811098673E-18
      1.20749889402399E-09
      0.00000000000000E+00  -8.63349714224472E-12   0.00000000000000E+00   4.26880053107604E-16   1.21814347036170E-22
      8.63347392896268E-09   8.63347435584286E-09  -8.21399134539991E-19  -2.36100307177845E-01  -2.36100307177864E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90657678389140E-11   0.00000000000000E+00   1.90657678389140E-11
      3.75987225393403E-18  -2.36157257445142E-01  -2.33431246107458E-01   0.00000000000000E+00   2.58869752703479E-14
     -9.79080823356223E-23  -8.65256601065693E-09  -8.65254012368176E-09  -2.93847311939404E-18
      1.22749889402399E-09
      0.00000000000000E+00  -8.63560957120050E-12   0.00000000000000E+00   5.46046599372196E-15   1.22043793242749E-22
      8.63556876196553E-09   8.63557422243165E-09  -8.21409906302407E-19  -2.36080575951301E-01  -2.36080575951319E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72681576783268E-11   0.00000000000000E+00   1.72681576783268E-11
      3.76021761708760E-18  -2.36141458535837E-01  -2.33415352042481E-01   0.00000000000000E+00   3.60902953979567E-14
     -9.79048940480170E-23  -8.65287847040526E-09  -8.65284238010996E-09  -2.93880771078518E-18
      1.24749889402399E-09
      0.00000000000000E+00  -8.64056918700970E-12   0.00000000000000E+00   1.26060763215235E-14   1.22318896083207E-22
      8.64057618327680E-09   8.64058878935325E-09  -8.21395291441818E-19  -2.36072696995464E-01  -2.36072696995478E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40633929981975E-11   0.00000000000000E+00   1.40633929981975E-11
      3.76049888494756E-18  -2.36117893601317E-01  -2.33391216890995E-01   0.00000000000000E+00   5.81810307116922E-14
     -9.78997176256782E-23  -8.65471036338209E-09  -8.65465218235148E-09  -2.93910359350574E-18
      1.26749889402399E-09
      0.00000000000000E+00  -8.64929443704442E-12   0.00000000000000E+00   2.16228868174321E-14   1.22655602971101E-22
      8.64923682955325E-09   8.64925845244019E-09  -8.21346367073335E-19  -2.36080920141041E-01  -2.36080920141051E-01
      0.00000000000000E+00   0.00000000000000E+00   9.37906783346532E-12   0.00000000000000E+00   9.37906783346532E-12
      3.76068646630423E-18  -2.36079611479503E-01  -2.33351679146377E-01   0.00000000000000E+00   9.34345610406944E-14
     -9.78913891486229E-23  -8.65873095483461E-09  -8.65863752027367E-09  -2.93934009923089E-18
      1.28749889402399E-09
      0.00000000000000E+00  -8.66160163183023E-12   0.00000000000000E+00   3.17576084876607E-14   1.23059865838015E-22
      8.66155584302773E-09   8.66158760063634E-09  -8.21259327853727E-19  -2.36107190868814E-01  -2.36107190868818E-01
      0.00000000000000E+00   0.00000000000000E+00   3.63932311867566E-12   0.00000000000000E+00   3.63932311867566E-12
      3.76075925276660E-18  -2.36019231422404E-01  -2.33289223379553E-01   0.00000000000000E+00   1.38842699885404E-13
     -9.78789315777551E-23  -8.66536576645475E-09  -8.66522692375496E-09  -2.93949992491287E-18
      1.30749889402399E-09
      0.00000000000000E+00  -8.67620494504622E-12   0.00000000000000E+00   3.64456409051054E-14   1.23516552066059E-22
      8.67615827062357E-09   8.67619471626460E-09  -8.21141393731485E-19  -2.36148404061830E-01  -2.36148404061828E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96224504844557E-12   0.00000000000000E+00  -1.96224504844557E-12
      3.76072000786563E-18  -2.35931351698678E-01  -2.33198506065203E-01   0.00000000000000E+00   1.89725341561599E-13
     -9.78620831882725E-23  -8.67442219655759E-09  -8.67423247121613E-09  -2.93957861413414E-18
      1.32749889402399E-09
      0.00000000000000E+00  -8.68961427667852E-12   0.00000000000000E+00   3.41946044613392E-14   1.23976665262098E-22
      8.68959848783555E-09   8.68963268244014E-09  -8.21017649240204E-19  -2.36193194295937E-01  -2.36193194295932E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.24278806307686E-12   0.00000000000000E+00  -5.24278806307686E-12
      3.76061515210437E-18  -2.35816351781448E-01  -2.33080306125757E-01   0.00000000000000E+00   2.26451755669325E-13
     -9.78420237752678E-23  -8.68461634613276E-09  -8.68438989437719E-09  -2.93959750286417E-18
      1.34749889402399E-09
      0.00000000000000E+00  -8.69585971880863E-12   0.00000000000000E+00   1.57588731702175E-14   1.24346092172720E-22
      8.69585227279892E-09   8.69586803167221E-09  -8.20937170942656E-19  -2.36219016007028E-01  -2.36219016007025E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98629405242955E-12   0.00000000000000E+00  -2.98629405242955E-12
      3.76055542622332E-18  -2.35685312765804E-01  -2.32946591403407E-01   0.00000000000000E+00   2.26797976852622E-13
     -9.78221900431875E-23  -8.69310853559648E-09  -8.69288173761972E-09  -2.93961825528067E-18
      1.36749889402399E-09
      0.00000000000000E+00  -8.68630786613905E-12   0.00000000000000E+00  -2.35486607780487E-14   1.24481819773583E-22
      8.68633538287917E-09   8.68631183421852E-09  -8.20975513703116E-19  -2.36190857637798E-01  -2.36190857637807E-01
      0.00000000000000E+00   0.00000000000000E+00   8.75378387360140E-12   0.00000000000000E+00   8.75378387360140E-12
      3.76073050190079E-18  -2.35565237875544E-01  -2.32825828249552E-01   0.00000000000000E+00   1.56210796335599E-13
     -9.78089482590507E-23  -8.69522182888836E-09  -8.69506561809212E-09  -2.93975498819768E-18
      1.38749889402399E-09
      0.00000000000000E+00  -8.65085579757694E-12   0.00000000000000E+00  -8.78531790691011E-14   1.24203795153506E-22
      8.65093479909306E-09   8.65084694591412E-09  -8.21229601124793E-19  -2.36063430697380E-01  -2.36063430697414E-01
      0.00000000000000E+00   0.00000000000000E+00   3.38047643674480E-11   0.00000000000000E+00   3.38047643674480E-11
      3.76140659718814E-18  -2.35502668717307E-01  -2.32766539823256E-01   0.00000000000000E+00  -2.02084651158070E-14
     -9.78117749372205E-23  -8.68463150181635E-09  -8.68465171028156E-09  -2.94017699606335E-18
      1.39749889402399E-09
      0.00000000000000E+00  -8.62523111589604E-12   0.00000000000000E+00  -1.26550601462657E-13   1.23937243639052E-22
      8.62544861986262E-09   8.62532206926128E-09  -8.21423904880477E-19  -2.35968644879266E-01  -2.35968644879316E-01
      0.00000000000000E+00   0.00000000000000E+00   5.01153937469573E-11   0.00000000000000E+00   5.01153937469573E-11
      3.76190775112561E-18  -2.35492823842557E-01  -2.32759597821327E-01   0.00000000000000E+00  -1.39382243662523E-13
     -9.78186812496285E-23  -8.67529808076445E-09  -8.67543746300821E-09  -2.94048384624514E-18
      1.41099889402399E-09
      0.00000000000000E+00  -8.57370621832262E-12   0.00000000000000E+00  -1.86469410052287E-13   1.23285923257077E-22
      8.57390906290339E-09   8.57372259349346E-09  -8.21841910157584E-19  -2.35768395215424E-01  -2.35768395215504E-01
      0.00000000000000E+00   0.00000000000000E+00   7.96747599305801E-11   0.00000000000000E+00   7.96747599305801E-11
      3.76298336038467E-18  -2.35540199221211E-01  -2.32813917875558E-01   0.00000000000000E+00  -3.68245623999401E-13
     -9.78414775570459E-23  -8.65302910779987E-09  -8.65339735342397E-09  -2.94114145022709E-18
      1.42922389402399E-09
      0.00000000000000E+00  -8.46918690738046E-12   0.00000000000000E+00  -2.76683229395903E-13   1.21777257637868E-22
      8.46950597609765E-09   8.46922929286838E-09  -8.22751215720410E-19  -2.35336635435741E-01  -2.35336635435873E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32136116345200E-10   0.00000000000000E+00   1.32136116345200E-10
      3.76539154110506E-18  -2.35776008787767E-01  -2.33066121695401E-01   0.00000000000000E+00  -7.98252000313295E-13
     -9.79068389205439E-23  -8.60056715721313E-09  -8.60136540921354E-09  -2.94264032538466E-18
      1.44922389402399E-09
      0.00000000000000E+00  -8.31966367520660E-12   0.00000000000000E+00  -3.60260112396537E-13   1.19408230254416E-22
      8.32009969304203E-09   8.31973943292976E-09  -8.24159573484319E-19  -2.34668291762468E-01  -2.34668291762664E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96059724824072E-10   0.00000000000000E+00   1.96059724824072E-10
      3.76931273560155E-18  -2.36313600811355E-01  -2.33630672733034E-01   0.00000000000000E+00  -1.36407560263614E-12
     -9.80277842078365E-23  -8.51443508215113E-09  -8.51579915775386E-09  -2.94515316211723E-18
      1.46922389402399E-09
      0.00000000000000E+00  -8.16196626142128E-12   0.00000000000000E+00  -3.88458063340676E-13   1.16676472259657E-22
      8.16233158025026E-09   8.16194312218703E-09  -8.25810704600268E-19  -2.33880362533520E-01  -2.33880362533767E-01
      0.00000000000000E+00   0.00000000000000E+00   2.47237892179252E-10   0.00000000000000E+00   2.47237892179252E-10
      3.77425749344513E-18  -2.37157846617310E-01  -2.34508507110493E-01   0.00000000000000E+00  -1.88377278661444E-12
     -9.81934947091670E-23  -8.40729724157959E-09  -8.40918101436630E-09  -2.94844678884487E-18
      1.48922389402399E-09
      0.00000000000000E+00  -8.04789509780953E-12   0.00000000000000E+00  -2.81400844144831E-13   1.14358705376720E-22
      8.04812884277528E-09   8.04784744193125E-09  -8.27290897428903E-19  -2.33162364643608E-01  -2.33162364643863E-01
      0.00000000000000E+00   0.00000000000000E+00   2.54811007527747E-10   0.00000000000000E+00   2.54811007527747E-10
      3.77935371359569E-18  -2.38247339531606E-01  -2.35631560926186E-01   0.00000000000000E+00  -2.13428868970778E-12
     -9.83784294372774E-23  -8.30052416076920E-09  -8.30265844945901E-09  -2.95206281616678E-18
      1.50922389402399E-09
      0.00000000000000E+00  -8.05652850310704E-12   0.00000000000000E+00   1.93052081848370E-14   1.13725838698606E-22
      8.05649017689369E-09   8.05650948210199E-09  -8.27887798217488E-19  -2.32843985397475E-01  -2.32843985397654E-01
      0.00000000000000E+00   0.00000000000000E+00   1.78674503087073E-10   0.00000000000000E+00   1.78674503087073E-10
      3.78292720365743E-18  -2.39382540625783E-01  -2.36788020344647E-01   0.00000000000000E+00  -1.76379843157985E-12
     -9.85279281301504E-23  -8.23342018675736E-09  -8.23518398518903E-09  -2.95503940543994E-18
      1.52922389402399E-09
      0.00000000000000E+00  -8.28788539613280E-12   0.00000000000000E+00   9.32206870724581E-13   1.16516110531526E-22
      8.28729968654435E-09   8.28823189341519E-09  -8.26628417830863E-19  -2.33378369794594E-01  -2.33378369794572E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.19160295151092E-11   0.00000000000000E+00  -2.19160295151092E-11
      3.78248888306713E-18  -2.40182710884929E-01  -2.37578497892195E-01   0.00000000000000E+00  -7.63768639415309E-13
     -9.85561350359982E-23  -8.26555209526061E-09  -8.26631586390012E-09  -2.95586046523626E-18
      1.54922389402399E-09
      0.00000000000000E+00  -8.84492372729645E-12   0.00000000000000E+00   1.38115022165035E-12   1.24746716965804E-22
      8.84359469619895E-09   8.84497584642072E-09  -8.22495615457203E-19  -2.35242186110872E-01  -2.35242186110500E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.71839100463154E-10   0.00000000000000E+00  -3.71839100463154E-10
      3.77505210105786E-18  -2.40054806580113E-01  -2.37385322582813E-01   0.00000000000000E+00   2.22702871565202E-12
     -9.83508785160116E-23  -8.47536377467302E-09  -8.47313674595746E-09  -2.95255648560066E-18
      1.56922389402399E-09
      0.00000000000000E+00  -9.80332356005699E-12   0.00000000000000E+00   2.37764574087148E-12   1.40301861848164E-22
      9.80088426413063E-09   9.80326190987164E-09  -8.14819067416366E-19  -2.38754847858950E-01  -2.38754847858087E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.62425691874413E-10   0.00000000000000E+00  -8.62425691874413E-10
      3.75780358722038E-18  -2.38194183830437E-01  -2.35377350844853E-01   0.00000000000000E+00   6.06576723877971E-12
     -9.77985520265375E-23  -8.94690198523600E-09  -8.94083621799732E-09  -2.94298451980401E-18
      1.58922389402399E-09
      0.00000000000000E+00  -1.11612479996703E-11   0.00000000000000E+00   3.37050532051366E-12   1.64051895283434E-22
      1.11578713827242E-08   1.11612418880449E-08  -8.03765188140172E-19  -2.43856761473838E-01  -2.43856761472401E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43719760566322E-09   0.00000000000000E+00  -1.43719760566322E-09
      3.72905963510711E-18  -2.33649211202539E-01  -2.30585624549417E-01   0.00000000000000E+00   1.06170917704865E-11
     -9.68091889323740E-23  -9.73466137415205E-09  -9.72404428238166E-09  -2.92529444696694E-18
      1.60922389402399E-09
      0.00000000000000E+00  -1.27770724613623E-11   0.00000000000000E+00   4.01154128935110E-12   1.94449927513546E-22
      1.27730850349763E-08   1.27770965762658E-08  -7.90617893161998E-19  -2.49988422742612E-01  -2.49988422740617E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99445179947949E-09   0.00000000000000E+00  -1.99445179947949E-09
      3.68917059911752E-18  -2.25537980665763E-01  -2.22140871935467E-01   0.00000000000000E+00   1.50040655434953E-11
     -9.53509632660904E-23  -1.07976488423297E-08  -1.07826447767863E-08  -2.89855270595552E-18
      1.62922389402399E-09
      0.00000000000000E+00  -1.43027972358537E-11   0.00000000000000E+00   3.79041778584305E-12   2.25890731818399E-22
      1.42990148580561E-08   1.43028052758422E-08  -7.77728384931965E-19  -2.56115418690107E-01  -2.56115418687719E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.38768682670253E-09   0.00000000000000E+00  -2.38768682670253E-09
      3.64141686258347E-18  -2.13514258766396E-01  -2.09760347344022E-01   0.00000000000000E+00   1.81312802704335E-11
     -9.34910924461149E-23  -1.19332497294100E-08  -1.19151184491397E-08  -2.86368847765151E-18
      1.64922389402399E-09
      0.00000000000000E+00  -1.51328899707354E-11   0.00000000000000E+00   2.07044249641120E-12   2.47515002086108E-22
      1.51308496338107E-08   1.51329200763073E-08  -7.68449425015592E-19  -2.60737339444203E-01  -2.60737339441819E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.38370765591892E-09   0.00000000000000E+00  -2.38370765591892E-09
      3.59374270946509E-18  -1.98559876638835E-01  -1.94543163058795E-01   0.00000000000000E+00   1.86745908538599E-11
     -9.14809922253317E-23  -1.27678870112422E-08  -1.27492124203884E-08  -2.82529328444950E-18
      1.66922389402399E-09
      0.00000000000000E+00  -1.44626070785948E-11   0.00000000000000E+00  -1.64282050633889E-12   2.44306932049061E-22
      1.44642654075394E-08   1.44626225870333E-08  -7.67295715490888E-19  -2.61769467224119E-01  -2.61769467222496E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.62324130112911E-09   0.00000000000000E+00  -1.62324130112911E-09
      3.56127788344251E-18  -1.83821670313327E-01  -1.79776531398218E-01   0.00000000000000E+00   1.51366473325725E-11
     -8.98563335532271E-23  -1.28545179332368E-08  -1.28393812859043E-08  -2.79398216795162E-18
      1.68922389402399E-09
      0.00000000000000E+00  -1.17550242257169E-11   0.00000000000000E+00  -6.68492622378576E-12   2.05391510632534E-22
      1.17617227817959E-08   1.17550378555724E-08  -7.79311430026366E-19  -2.56789680521995E-01  -2.56789680522156E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60133541678918E-10   0.00000000000000E+00   1.60133541678918E-10
      3.56448055427609E-18  -1.74201216783324E-01  -1.70447245321349E-01   0.00000000000000E+00   6.47484798789135E-12
     -8.93199997121263E-23  -1.19216462452391E-08  -1.19151713972513E-08  -2.78516912424972E-18
      1.70922389402399E-09
      0.00000000000000E+00  -7.49866356930852E-12   0.00000000000000E+00  -1.05457747519293E-11   1.37454801968853E-22
      7.50924137251943E-09   7.49869559776764E-09  -8.07741162318440E-19  -2.44094168813343E-01  -2.44094168816013E-01
      0.00000000000000E+00   0.00000000000000E+00   2.66988344833128E-09   0.00000000000000E+00   2.66988344833128E-09
      3.61787822324271E-18  -1.73710077633983E-01  -1.70506372771073E-01   0.00000000000000E+00  -7.43731277230716E-12
     -9.03980305581628E-23  -1.01611417333265E-08  -1.01685790460989E-08  -2.81013706092427E-18
      1.72922389402399E-09
      0.00000000000000E+00  -3.04299983315978E-12   0.00000000000000E+00  -1.10855217084419E-11   6.30699364371500E-23
      3.05408454759846E-09   3.04299902589008E-09  -8.52720152374661E-19  -2.23312261305708E-01  -2.23312261310847E-01
      0.00000000000000E+00   0.00000000000000E+00   5.13872799136435E-09   0.00000000000000E+00   5.13872799136435E-09
      3.72065278307000E-18  -1.82833255139587E-01  -1.80255515834448E-01   0.00000000000000E+00  -2.64000122439443E-11
     -9.33265187765221E-23  -8.15532700501036E-09  -8.18172701725440E-09  -2.86793263069534E-18
      1.74922389402399E-09
      0.00000000000000E+00   4.78970304537252E-13   0.00000000000000E+00  -8.84362560475281E-12   2.64737818610152E-24
     -4.70169550652650E-10  -4.79013176257401E-10  -9.12690150520501E-19  -1.94745743376469E-01  -1.94745743383480E-01
      0.00000000000000E+00   0.00000000000000E+00   7.01053345611086E-09   0.00000000000000E+00   7.01053345611086E-09
      3.86086345219222E-18  -1.98543382678457E-01  -1.96485544445392E-01   0.00000000000000E+00  -4.99902698490475E-11
     -9.79751351282307E-23  -6.48153001000440E-09  -6.53152027985354E-09  -2.94817330167172E-18
      1.76922389402399E-09
      0.00000000000000E+00   2.67277369747624E-12   0.00000000000000E+00  -5.64843541370705E-12  -3.14728622765666E-23
     -2.66717555820501E-09  -2.67282399361875E-09  -9.84968857379022E-19  -1.59072244325399E-01  -1.59072244333557E-01
      0.00000000000000E+00   0.00000000000000E+00   8.15805549986973E-09   0.00000000000000E+00   8.15805549986973E-09
      4.02402456218961E-18  -2.16524837107853E-01  -2.14796628714266E-01   0.00000000000000E+00  -7.68423579211869E-11
     -1.03892758803431E-22  -5.40838914832963E-09  -5.48523150625092E-09  -3.03905570481059E-18
      1.78922389402399E-09
      0.00000000000000E+00   3.66405394615707E-12   0.00000000000000E+00  -2.76980629989640E-12  -4.30226273369406E-23
     -3.66131415190589E-09  -3.66408395820583E-09  -1.06372445573421E-18  -1.18484508380018E-01  -1.18484508388561E-01
      0.00000000000000E+00   0.00000000000000E+00   8.54315126347030E-09   0.00000000000000E+00   8.54315126347030E-09
      4.19488758745902E-18  -2.33582906405113E-01  -2.32045666966798E-01   0.00000000000000E+00  -1.03562952079461E-10
     -1.10658685530409E-22  -4.77550435318495E-09  -4.87906730526452E-09  -3.13116313172481E-18
      1.80922389402399E-09
      0.00000000000000E+00   3.70648621474695E-12   0.00000000000000E+00  -4.94516337320280E-13  -4.58572267286278E-23
     -3.70597089246747E-09  -3.70646540880483E-09  -1.13894624673966E-18  -7.78168917306279E-02  -7.78168917386545E-02
      0.00000000000000E+00   0.00000000000000E+00   8.02660850271587E-09   0.00000000000000E+00   8.02660850271587E-09
      4.35541975751334E-18  -2.48700821765171E-01  -2.47339673888466E-01   0.00000000000000E+00  -1.23778815666550E-10
     -1.17724354812102E-22  -4.19636427824436E-09  -4.32014309391103E-09  -3.21647351077367E-18
      1.82922389402399E-09
      0.00000000000000E+00   2.86151463243770E-12   0.00000000000000E+00   1.72300085659479E-12  -4.67613615567284E-23
     -2.86320919553054E-09  -2.86148619467399E-09  -1.19605685151937E-18  -4.55939071036784E-02  -4.55939071099778E-02
      0.00000000000000E+00   0.00000000000000E+00   6.29937041217637E-09   0.00000000000000E+00   6.29937041217637E-09
      4.48140716575686E-18  -2.62679286761880E-01  -2.61596107361937E-01   0.00000000000000E+00  -1.22828417116285E-10
     -1.23995097888077E-22  -3.31505580038590E-09  -3.43788421750231E-09  -3.28535031423750E-18
      1.84922389402399E-09
      0.00000000000000E+00   1.61564077221760E-12   0.00000000000000E+00   2.84682643302061E-12  -4.71500245103476E-23
     -1.61844482113831E-09  -1.61559799470533E-09  -1.22793280818228E-18  -2.71225089675794E-02  -2.71225089715211E-02
      0.00000000000000E+00   0.00000000000000E+00   3.94169981244457E-09   0.00000000000000E+00   3.94169981244457E-09
      4.56024116200575E-18  -2.75711247786794E-01  -2.74978357142019E-01   0.00000000000000E+00  -9.53628104367243E-11
     -1.28482115431612E-22  -2.23073900730242E-09  -2.32610181773928E-09  -3.33230835382348E-18
      1.86922389402399E-09
      0.00000000000000E+00   7.77557545198922E-13   0.00000000000000E+00   1.96222405093955E-12  -4.73150287775365E-23
     -7.79476088154132E-10  -7.77513864103239E-10  -1.24295589511840E-18  -1.83528650733421E-02  -1.83528650755964E-02
      0.00000000000000E+00   0.00000000000000E+00   2.25436467098980E-09   0.00000000000000E+00   2.25436467098980E-09
      4.60532845542555E-18  -2.86661567091535E-01  -2.86196252254976E-01   0.00000000000000E+00  -6.45314353061634E-11
     -1.31362237955228E-22  -1.41231937158028E-09  -1.47685080688658E-09  -3.36237256030716E-18
      1.88922389402399E-09
      0.00000000000000E+00   3.92819941036592E-13   0.00000000000000E+00   9.03738814556697E-13  -4.73916021495810E-23
     -3.93718397160074E-10  -3.92814658345565E-10  -1.25025586417708E-18  -1.41423447731948E-02  -1.41423447745836E-02
      0.00000000000000E+00   0.00000000000000E+00   1.38874704170030E-09   0.00000000000000E+00   1.38874704170030E-09
      4.63310339625955E-18  -2.95410857487673E-01  -2.95097067893705E-01   0.00000000000000E+00  -4.41832075802971E-11
     -1.33268555939632E-22  -9.51749175774275E-10  -9.95932383354706E-10  -3.38284753208247E-18
      1.90922389402399E-09
      0.00000000000000E+00   2.28968929858364E-13   0.00000000000000E+00   3.83867893617601E-13  -4.74313108577319E-23
     -2.29308376611069E-10  -2.28924508717499E-10  -1.25426967788179E-18  -1.18886347570929E-02  -1.18886347580913E-02
      0.00000000000000E+00   0.00000000000000E+00   9.98380711196496E-10   0.00000000000000E+00   9.98380711196496E-10
      4.65307101048349E-18  -3.02935186451646E-01  -3.02692753986121E-01   0.00000000000000E+00  -3.41968599695646E-11
     -1.34706212165246E-22  -7.35259342509295E-10  -7.69456202478994E-10  -3.39880133260170E-18
      1.92922389402399E-09
      0.00000000000000E+00   1.45022840050685E-13   0.00000000000000E+00   1.98989873477079E-13  -4.74497899323387E-23
     -1.45214501085417E-10  -1.45015511211988E-10  -1.25660782240636E-18  -1.05870994046478E-02  -1.05870994055593E-02
      0.00000000000000E+00   0.00000000000000E+00   9.11429045483989E-10   0.00000000000000E+00   9.11429045483989E-10
      4.67129959139317E-18  -3.11475605222635E-01  -3.11234131001576E-01   0.00000000000000E+00  -3.60097078674594E-11
     -1.36171502453304E-22  -7.30403826404341E-10  -7.66413534271936E-10  -3.41469176898680E-18
      1.94922389402399E-09
      0.00000000000000E+00   9.23039608935644E-14   0.00000000000000E+00   1.29734556317055E-13  -4.74536663139058E-23
     -9.24661497162248E-11  -9.23364151599552E-11  -1.25790340493032E-18  -9.80754964973655E-03  -9.80754965076237E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02581796758773E-09   0.00000000000000E+00   1.02581796758773E-09
      4.69181595074492E-18  -3.23118645394753E-01  -3.22824531059033E-01   0.00000000000000E+00  -4.83099258801004E-11
     -1.38067434273432E-22  -8.85171626547636E-10  -9.33481552427875E-10  -3.43391254581460E-18
      1.96922389402399E-09
      0.00000000000000E+00   5.74948054919118E-14   0.00000000000000E+00   9.07126452478312E-14  -4.74476834173751E-23
     -5.76050201521489E-11  -5.75143075069485E-11  -1.25851920613440E-18  -9.36144942652302E-03  -9.36144942763116E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10813413374291E-09   0.00000000000000E+00   1.10813413374291E-09
      4.71397863341978E-18  -3.36910329113187E-01  -3.36579306540231E-01   0.00000000000000E+00  -5.82276071554183E-11
     -1.40281870550857E-22  -9.92392219080378E-10  -1.05061982623594E-09  -3.45545942728538E-18
      1.98922389402399E-09
      0.00000000000000E+00  -1.32256421578839E-14   0.00000000000000E+00   1.89717656501615E-13  -4.74164890967816E-23
      1.30690379224630E-11   1.32587555789172E-11  -1.25774564464368E-18  -9.71391556084043E-03  -9.71391556186532E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02488889694268E-09   0.00000000000000E+00   1.02488889694268E-09
      4.73447641135863E-18  -3.51344576584319E-01  -3.51017483496274E-01   0.00000000000000E+00  -6.01130003128357E-11
     -1.42501862906462E-22  -9.78034652208547E-10  -1.03814765252152E-09  -3.47673076671495E-18
      2.00922389402399E-09
      0.00000000000000E+00  -2.52205648371868E-13   0.00000000000000E+00   6.40138329319420E-13  -4.72972608116824E-23
      2.51573302366179E-10   2.52213440695452E-10  -1.25225428875288E-18  -1.28455119876989E-02  -1.28455119883187E-02
      0.00000000000000E+00   0.00000000000000E+00   6.19857975942765E-10   0.00000000000000E+00   6.19857975942765E-10
      4.74687357087749E-18  -3.65943870458479E-01  -3.65669104986813E-01   0.00000000000000E+00  -5.04765481671327E-11
     -1.44323957378414E-22  -8.21594868471030E-10  -8.72071416638307E-10  -3.49461928212461E-18
      2.02922389402399E-09
      0.00000000000000E+00  -8.99894735159347E-13   0.00000000000000E+00   1.74033735058161E-12  -4.69481912837069E-23
      8.98106133859471E-10   8.99846471210006E-10  -1.23400415724133E-18  -2.34027436691524E-02  -2.34027436687031E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.49340112427336E-10   0.00000000000000E+00  -4.49340112427336E-10
      4.73788676862894E-18  -3.81086149619210E-01  -3.80944213035803E-01   0.00000000000000E+00  -1.94884737663982E-11
     -1.45037945634513E-22  -4.31017885016085E-10  -4.50506358782628E-10  -3.50388261138761E-18
      2.04922389402399E-09
      0.00000000000000E+00  -1.68342218827676E-12   0.00000000000000E+00   2.17058059283998E-12  -4.63517291182994E-23
      1.68123568785463E-09   1.68340626844742E-09  -1.20061602210418E-18  -4.24028460905418E-02  -4.24028460888365E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.70535354531399E-09   0.00000000000000E+00  -1.70535354531399E-09
      4.70377969772266E-18  -3.96732765173368E-01  -3.96739693221284E-01   0.00000000000000E+00   1.73391809173692E-11
     -1.44466181963868E-22   4.60809594928404E-12   2.19472768665088E-11  -3.50316367561848E-18
      2.06922389402399E-09
      0.00000000000000E+00  -2.28757686962787E-12   0.00000000000000E+00   1.76806003263581E-12  -4.54731152773831E-23
      2.28583672117943E-09   2.28760478121202E-09  -1.15647488588781E-18  -6.67934208311698E-02  -6.67934208285779E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.59192243055391E-09   0.00000000000000E+00  -2.59192243055391E-09
      4.65194124911158E-18  -4.12358650864239E-01  -4.12454553695964E-01   0.00000000000000E+00   4.12054921084143E-11
     -1.43041567924119E-22   2.63112157233599E-10   3.04317649341870E-10  -3.49546636322377E-18
      2.07922389402399E-09
      0.00000000000000E+00  -2.66570165271126E-12   0.00000000000000E+00   2.14503542205808E-12  -4.47492450191140E-23
      2.66354720537017E-09   2.66569224079218E-09  -1.13127168389823E-18  -8.03730519653274E-02  -8.03730519622336E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.09377137501722E-09   0.00000000000000E+00  -3.09377137501722E-09
      4.62100353536141E-18  -4.20111497167002E-01  -4.20246399149204E-01   0.00000000000000E+00   5.28245282895882E-11
     -1.42111424061001E-22   3.75254605935762E-10   4.28079134225208E-10  -3.48973185146319E-18
      2.09272389402399E-09
      0.00000000000000E+00  -3.13107893614179E-12   0.00000000000000E+00   1.98620213684797E-12  -4.28115087700432E-23
      3.12909491503665E-09   3.13108111717345E-09  -1.09311621074100E-18  -1.00452514444469E-01  -1.00452514440875E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.59379460083957E-09   0.00000000000000E+00  -3.59379460083957E-09
      4.57248730825008E-18  -4.30406192424160E-01  -4.30552017258431E-01   0.00000000000000E+00   6.32592014332700E-11
     -1.40573332440665E-22   3.99454282233004E-10   4.62713483666133E-10  -3.47937109750908E-18
      2.11094889402399E-09
      0.00000000000000E+00  -4.06863001355623E-12   0.00000000000000E+00   2.81640215824286E-12  -3.47323065245424E-23
      4.06581858183253E-09   4.06863498399074E-09  -1.03382492131288E-18  -1.30614937932157E-01  -1.30614937927836E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.32128170649528E-09   0.00000000000000E+00  -4.32128170649528E-09
      4.49373194914920E-18  -4.43511685592036E-01  -4.43591353862540E-01   0.00000000000000E+00   7.71108696623032E-11
     -1.37944028969857E-22   1.75535852842283E-10   2.52646722504448E-10  -3.45990702783631E-18
      2.13094889402399E-09
      0.00000000000000E+00  -5.99617551333059E-12   0.00000000000000E+00   5.00460489169980E-12  -2.62118732824833E-24
      5.99112850909365E-09   5.99613311398534E-09  -9.61097882842968E-19  -1.66054591413826E-01  -1.66054591408698E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.12766271028293E-09   0.00000000000000E+00  -5.12766271028293E-09
      4.39117869494354E-18  -4.54995819119623E-01  -4.54722332605294E-01   0.00000000000000E+00   9.03063912887462E-11
     -1.34333264051913E-22  -9.58776794990992E-10  -8.68470403702380E-10  -3.43008081210057E-18
      2.15094889402399E-09
      0.00000000000000E+00  -9.74380817034651E-12   0.00000000000000E+00   9.43847557684257E-12   7.86874178925445E-23
      9.73434683485569E-09   9.74378531043261E-09  -8.88141343026384E-19  -2.00122156715153E-01  -2.00122156709437E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.71578321323886E-09   0.00000000000000E+00  -5.71578321323886E-09
      4.27686303067876E-18  -4.59213801216324E-01  -4.57944996766579E-01   0.00000000000000E+00   9.92584387618279E-11
     -1.29937898534028E-22  -4.12726053595545E-09  -4.02800209719376E-09  -3.38872168765238E-18
      2.17094889402399E-09
      0.00000000000000E+00  -1.60261718848158E-11   0.00000000000000E+00   1.56339840127867E-11   2.19884828642775E-22
      1.60105220827696E-08   1.60261560667826E-08  -8.23578309816250E-19  -2.29387631171084E-01  -2.29387631164929E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.15542871972742E-09   0.00000000000000E+00  -6.15542871972742E-09
      4.15375445628422E-18  -4.50306990413421E-01  -4.47197541312587E-01   0.00000000000000E+00   1.08635506579854E-10
     -1.24462095445667E-22  -9.97936285363488E-09  -9.87072734705515E-09  -3.33017614646796E-18
      2.19094889402399E-09
      0.00000000000000E+00  -2.37283633917762E-11   0.00000000000000E+00   1.91087139976308E-11   3.98269556656392E-22
      2.37092455279795E-08   2.37283542419776E-08  -7.72951655631027E-19  -2.52217607092198E-01  -2.52217607085644E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.55434661063204E-09   0.00000000000000E+00  -6.55434661063204E-09
      4.02266752407158E-18  -4.23890852360632E-01  -4.18480539946550E-01   0.00000000000000E+00   1.18040146640531E-10
     -1.17682260136520E-22  -1.72920477779859E-08  -1.71740076313455E-08  -3.24971586844054E-18
      2.21094889402399E-09
      0.00000000000000E+00  -3.01466573173125E-11   0.00000000000000E+00   1.59332953958875E-11   5.53760463939771E-22
      3.01307185516372E-08   3.01466518470336E-08  -7.37688380410454E-19  -2.68612417840890E-01  -2.68612417833968E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.92179736552992E-09   0.00000000000000E+00  -6.92179736552992E-09
      3.88423157676098E-18  -3.79095610353792E-01  -3.71778890244277E-01   0.00000000000000E+00   1.22200522480140E-10
     -1.09900154718858E-22  -2.33470550039837E-08  -2.32248544815037E-08  -3.14654319635053E-18
      2.23094889402399E-09
      0.00000000000000E+00  -3.31612771266752E-11   0.00000000000000E+00   7.50990992085215E-12   6.37434460003127E-22
      3.31537103930439E-08   3.31612203029654E-08  -7.16196678594117E-19  -2.79518387317774E-01  -2.79518387310538E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23554758694952E-09   0.00000000000000E+00  -7.23554758694952E-09
      3.73952062502199E-18  -3.19056870679418E-01  -3.10889088774533E-01   0.00000000000000E+00   1.15935058646412E-10
     -1.01847160364756E-22  -2.60416077746622E-08  -2.59256727160158E-08  -3.02332394642787E-18
      2.25094889402399E-09
      0.00000000000000E+00  -3.31576951819241E-11   0.00000000000000E+00   3.12804859204407E-14   6.52787018276254E-22
      3.31576579407278E-08   3.31576892212144E-08  -7.03704519940195E-19  -2.86934156745386E-01  -2.86934156737956E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.43067453411158E-09   0.00000000000000E+00  -7.43067453411158E-09
      3.59090713433976E-18  -2.52601728981073E-01  -2.44496371221603E-01   0.00000000000000E+00   9.49089099526741E-11
     -9.36885991766135E-23  -2.58219235970554E-08  -2.57270146871029E-08  -2.88720261439956E-18
      2.27094889402399E-09
      0.00000000000000E+00  -3.19456201849964E-11   0.00000000000000E+00  -2.97483484440980E-12   6.34603492922130E-22
      3.19486071476875E-08   3.19456323128437E-08  -6.94686840475520E-19  -2.93040149266507E-01  -2.93040149259026E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.48091037350418E-09   0.00000000000000E+00  -7.48091037350418E-09
      3.44128892686967E-18  -1.88771368464253E-01  -1.81063580051692E-01   0.00000000000000E+00   6.78848875110117E-11
     -8.61403793598825E-23  -2.45326068268505E-08  -2.44647219393396E-08  -2.74660208639415E-18
      2.29094889402399E-09
      0.00000000000000E+00  -3.04164971552283E-11   0.00000000000000E+00  -3.76741759582465E-12   6.01860871346999E-22
      3.04202537808814E-08   3.04164863632862E-08  -6.86588026228791E-19  -2.98826156483517E-01  -2.98826156476060E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.45740299365863E-09   0.00000000000000E+00  -7.45740299365863E-09
      3.29214086699650E-18  -1.31104159731600E-01  -1.23870655877185E-01   0.00000000000000E+00   4.67977932432261E-11
     -7.54892031647204E-23  -2.30058811628706E-08  -2.29590833696274E-08  -2.60555284076771E-18
      2.30094889402399E-09
      0.00000000000000E+00  -2.93483428615047E-11   0.00000000000000E+00  -5.26488936091258E-12   5.78990243346039E-22
      2.93536048588409E-08   2.93483399694806E-08  -6.82936154936497E-19  -3.01573130011464E-01  -3.01573130004010E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.45459214078554E-09   0.00000000000000E+00  -7.45459214078554E-09
      3.21759494558864E-18  -1.04456087654257E-01  -9.75581990691108E-02   0.00000000000000E+00   3.71967814275143E-11
     -5.61946920620278E-23  -2.19309446101225E-08  -2.18937478286951E-08  -2.53465879065215E-18
      2.31444889402399E-09
      0.00000000000000E+00  -2.79521191664759E-11   0.00000000000000E+00  -5.10092084821280E-12   5.48455810736615E-22
      2.79572585919078E-08   2.79521576710602E-08  -6.76532094031413E-19  -3.05845012922252E-01  -3.05845012914886E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.36607314062247E-09   0.00000000000000E+00  -7.36607314062247E-09
      3.11815295819024E-18  -7.39343898369443E-02  -6.74484681248518E-02   0.00000000000000E+00   2.83658391300480E-11
      1.84872642688379E-23  -2.06144503695676E-08  -2.05860845304375E-08  -2.44162086415883E-18
      2.33267389402399E-09
      0.00000000000000E+00  -2.56087925413631E-11   0.00000000000000E+00  -6.32525370253443E-12   5.24546622896642E-22
      2.56151028818270E-08   2.56087776281250E-08  -6.61458993179315E-19  -3.13912200772588E-01  -3.13912200765459E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.12877789718063E-09   0.00000000000000E+00  -7.12877789718063E-09
      2.98823098101412E-18  -4.54409186638497E-02  -3.96185256397489E-02   0.00000000000000E+00   2.02727444366214E-11
      1.94762313841946E-22  -1.85002724753813E-08  -1.84799997309445E-08  -2.32677198783481E-18
      2.35267389402399E-09
      0.00000000000000E+00  -2.30370480548151E-11   0.00000000000000E+00  -6.31887408269598E-12   5.28487809794325E-22
      2.30433696843689E-08   2.30370508102867E-08  -6.35365750384453E-19  -3.26110576317211E-01  -3.26110576310418E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.79275494823759E-09   0.00000000000000E+00  -6.79275494823759E-09
      2.85237588204937E-18  -2.87730788563417E-02  -2.36550619481954E-02   0.00000000000000E+00   1.36654280276160E-11
      4.05181843661815E-22  -1.62579612900771E-08  -1.62442958620491E-08  -2.21701013166492E-18
      2.37267389402399E-09
      0.00000000000000E+00  -2.12845586241583E-11   0.00000000000000E+00  -4.29426548350612E-12   5.39680641323053E-22
      2.12888899355473E-08   2.12845956700643E-08  -6.04292361140049E-19  -3.40018064624794E-01  -3.40018064618257E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.53713189588325E-09   0.00000000000000E+00  -6.53713189588325E-09
      2.72163324413171E-18  -2.06482538231863E-02  -1.60018288294439E-02   0.00000000000000E+00   8.80563408651433E-12
      5.64680410677450E-22  -1.47562694082680E-08  -1.47474637741810E-08  -2.11734088299166E-18
      2.39267389402399E-09
      0.00000000000000E+00  -2.01727780802612E-11   0.00000000000000E+00  -2.71198678682676E-12   5.36479958744318E-22
      2.01754980157381E-08   2.01727860289518E-08  -5.72427675123739E-19  -3.54169765859036E-01  -3.54169765852664E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.37223729808944E-09   0.00000000000000E+00  -6.37223729808944E-09
      2.59418849816992E-18  -1.62959247209086E-02  -1.19478352611133E-02   0.00000000000000E+00   6.14982051316747E-12
      6.55435540990689E-22  -1.38066985513763E-08  -1.38005487308624E-08  -2.02176082304618E-18
      2.41267389402399E-09
      0.00000000000000E+00  -1.93525127322608E-11   0.00000000000000E+00  -1.99287580270633E-12   5.12724797180969E-22
      1.93545392244174E-08   1.93525463486152E-08  -5.41398195993908E-19  -3.68011968797553E-01  -3.68011968791299E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.25348153308348E-09   0.00000000000000E+00  -6.25348153308348E-09
      2.46911886750825E-18  -1.36012569797685E-02  -9.47417786396791E-03   0.00000000000000E+00   4.92505667152775E-12
      6.84753228998362E-22  -1.31039898722039E-08  -1.30990648155317E-08  -1.92772067151434E-18
      2.43267389402399E-09
      0.00000000000000E+00  -1.86976597559711E-11   0.00000000000000E+00  -1.58672331491738E-12   4.71487024299907E-22
      1.86992731492913E-08   1.86976864259768E-08  -5.11458660168294E-19  -3.81462153747718E-01  -3.81462153741558E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16038132894210E-09   0.00000000000000E+00  -6.16038132894210E-09
      2.34591124092940E-18  -1.17640583762711E-02  -7.81396810745540E-03   0.00000000000000E+00   4.23784480001302E-12
      6.65844716410019E-22  -1.25415429418355E-08  -1.25373050970348E-08  -1.83445258076111E-18
      2.45267389402399E-09
      0.00000000000000E+00  -1.81941669065994E-11   0.00000000000000E+00  -1.21521404126060E-12   4.18467945803851E-22
      1.81954090996094E-08   1.81941938855686E-08  -4.82266493635915E-19  -3.94634735889895E-01  -3.94634735883790E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.10496761955421E-09   0.00000000000000E+00  -6.10496761955421E-09
      2.22381188853832E-18  -1.04419604862791E-02  -6.63304252862013E-03   0.00000000000000E+00   3.75678577947661E-12
      6.12916829349641E-22  -1.20929830517944E-08  -1.20892262660143E-08  -1.74154539490241E-18
      2.47267389402399E-09
      0.00000000000000E+00  -1.79912818821080E-11   0.00000000000000E+00  -4.74312483257773E-13   3.59848292741594E-22
      1.79917229534932E-08   1.79912486410103E-08  -4.52510836920613E-19  -4.08028855250500E-01  -4.08028855244278E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22193645964173E-09   0.00000000000000E+00  -6.22193645964173E-09
      2.09937315934549E-18  -9.48237181272346E-03  -5.77424625845300E-03   0.00000000000000E+00   3.38661369948162E-12
      5.39613773457668E-22  -1.17726987950686E-08  -1.17693121813686E-08  -1.64686232242487E-18
      2.49267389402399E-09
      0.00000000000000E+00  -1.82207100356524E-11   0.00000000000000E+00   5.91711487463897E-13   2.99429474998442E-22
      1.82201251784631E-08   1.82207168899508E-08  -4.20512817645566E-19  -4.22301939004228E-01  -4.22301938997627E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.60156563773777E-09   0.00000000000000E+00  -6.60156563773777E-09
      1.96734184659073E-18  -8.81041084099659E-03  -5.14959356501783E-03   0.00000000000000E+00   3.04554982307716E-12
      4.55211936398543E-22  -1.16221968020366E-08  -1.16191512522131E-08  -1.54682902894516E-18
      2.51267389402399E-09
      0.00000000000000E+00  -1.84573020786990E-11   0.00000000000000E+00   6.11504884332930E-13   2.37388868842323E-22
      1.84567100853112E-08   1.84573215901958E-08  -3.87056744980036E-19  -4.37094061782093E-01  -4.37094061775216E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.87695768686609E-09   0.00000000000000E+00  -6.87695768686609E-09
      1.82980269285341E-18  -8.29101516282526E-03  -4.64241623982335E-03   0.00000000000000E+00   2.76236316096517E-12
      3.63322097408726E-22  -1.15831262664910E-08  -1.15803639033297E-08  -1.44274594787337E-18
      2.53267389402399E-09
      0.00000000000000E+00  -1.85776186844408E-11   0.00000000000000E+00   3.23945407921801E-13   1.76908272765597E-22
      1.85772883899835E-08   1.85776123353916E-08  -3.53079355388700E-19  -4.52006786012102E-01  -4.52006786005107E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.99565907148048E-09   0.00000000000000E+00  -6.99565907148048E-09
      1.68988951142380E-18  -7.86332459012334E-03  -4.21422268188810E-03   0.00000000000000E+00   2.56658002677781E-12
      2.70767182531449E-22  -1.15845198439382E-08  -1.15819532639111E-08  -1.33681015603510E-18
      2.54267389402399E-09
      0.00000000000000E+00  -1.86499004926232E-11   0.00000000000000E+00   3.81709961827933E-13   1.46569727644699E-22
      1.86495099938006E-08   1.86498917037626E-08  -3.36094657177909E-19  -4.59453065054969E-01  -4.59453065047912E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.05769604088669E-09   0.00000000000000E+00  -7.05769604088669E-09
      1.61931255101493E-18  -7.68675583060248E-03  -4.03442575560539E-03   0.00000000000000E+00   2.41190608357005E-12
      2.23280500513848E-22  -1.15946075689595E-08  -1.15921956628757E-08  -1.28321789383702E-18
      2.55617389402399E-09
      0.00000000000000E+00  -1.87382551298168E-11   0.00000000000000E+00   3.47503943706761E-13   1.10967170588287E-22
      1.87379024740008E-08   1.87382499779446E-08  -3.13262254601169E-19  -4.69423892121740E-01  -4.69423892114716E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02507951918471E-09   0.00000000000000E+00  -7.02507951918471E-09
      1.52447397750594E-18  -7.52044752134984E-03  -3.83000060864916E-03   0.00000000000000E+00   1.93318536764643E-12
      1.67389020201201E-22  -1.17151036441279E-08  -1.17131704587601E-08  -1.21121172290477E-18
      2.57439889402399E-09
      0.00000000000000E+00  -1.85391357395509E-11   0.00000000000000E+00  -5.15377191687047E-13   7.30426646886477E-23
      1.85396197151953E-08   1.85391043380037E-08  -2.84498925502440E-19  -4.81959900096700E-01  -4.81959900090082E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.61801089390824E-09   0.00000000000000E+00  -6.61801089390824E-09
      1.40386072896446E-18  -7.32971651434782E-03  -3.57375775826197E-03   0.00000000000000E+00   1.56934453392267E-12
      1.07632874884949E-22  -1.19226627886295E-08  -1.19210934440955E-08  -1.11936180346202E-18
      2.59439889402399E-09
      0.00000000000000E+00  -1.71191242575853E-11   0.00000000000000E+00  -3.48184538206656E-12   4.31415613760514E-23
      1.71225635152635E-08   1.71190816698814E-08  -2.61047169345428E-19  -4.92175170948771E-01  -4.92175170943718E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.05333692178808E-09   0.00000000000000E+00  -5.05333692178808E-09
      1.30279399052870E-18  -7.03767437401589E-03  -3.23613872264748E-03   0.00000000000000E+00   1.18035872123063E-12
      6.07591730763338E-23  -1.20669251068146E-08  -1.20657447480933E-08  -1.04174682118327E-18
      2.61439889402399E-09
      0.00000000000000E+00  -1.34161281428523E-11   0.00000000000000E+00  -9.11869780058540E-12   2.36169193094948E-23
      1.34252614779287E-08   1.34161427801282E-08  -2.55889142907353E-19  -4.94341677242868E-01  -4.94341677241567E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30096410629536E-09   0.00000000000000E+00  -1.30096410629536E-09
      1.27677470840279E-18  -6.57385105977260E-03  -2.75673880391705E-03   0.00000000000000E+00   2.50362010469024E-13
      3.08161850897396E-23  -1.21154290358433E-08  -1.21151786738328E-08  -1.02088556549544E-18
      2.63439889402399E-09
      0.00000000000000E+00  -7.02851035954319E-12   0.00000000000000E+00  -1.57508435166969E-11   1.10835064264356E-23
      7.04426146642430E-09   7.02851062290761E-09  -2.82209838726171E-19  -4.82821185505991E-01  -4.82821185511083E-01
      0.00000000000000E+00   0.00000000000000E+00   5.09231379579722E-09   0.00000000000000E+00   5.09231379579722E-09
      1.37862098431874E-18  -5.92477568057217E-03  -2.10588369211479E-03   0.00000000000000E+00  -1.61418933955119E-12
      1.23337092094973E-23  -1.21192102293653E-08  -1.21208244187048E-08  -1.09641114559257E-18
      2.65439889402399E-09
      0.00000000000000E+00   5.73662228598212E-13   0.00000000000000E+00  -1.87668473476777E-11   5.31207418702823E-25
     -5.54872685849537E-10  -5.73639533197215E-10  -3.51239575491750E-19  -4.53688569327196E-01  -4.53688569339872E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26751180591188E-08   0.00000000000000E+00   1.26751180591188E-08
      1.63212334550111E-18  -5.20955587779531E-03  -1.39676103823054E-03   0.00000000000000E+00  -4.56265278918195E-12
     -3.54392473186588E-24  -1.20969158731323E-08  -1.21014785259215E-08  -1.28088377000936E-18
      2.67439889402399E-09
      0.00000000000000E+00   6.58646163936337E-12   0.00000000000000E+00  -1.49213432468899E-11  -1.43198932349444E-23
     -6.57151746034335E-09  -6.58643880359025E-09  -4.68433347619791E-19  -4.06303572980206E-01  -4.06303572998840E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86338989809982E-08   0.00000000000000E+00   1.86338989809982E-08
      2.00480132512108E-18  -4.69220902218592E-03  -8.96433847153139E-04   0.00000000000000E+00  -9.16548859570458E-12
     -2.87672304394268E-23  -1.20382946888122E-08  -1.20474601774079E-08  -1.53636797750128E-18
      2.69439889402399E-09
      0.00000000000000E+00   8.82664662459215E-12   0.00000000000000E+00  -5.72528970088296E-12  -3.24152280726642E-23
     -8.82091776741883E-09  -8.82664305711975E-09  -6.27085309207209E-19  -3.43022607323203E-01  -3.43022607343919E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07163494371455E-08   0.00000000000000E+00   2.07163494371455E-08
      2.41912831386398E-18  -5.11338700843479E-03  -1.36731873539130E-03   0.00000000000000E+00  -1.70204432756282E-11
     -6.17510986666069E-23  -1.18726859367501E-08  -1.18897063800258E-08  -1.79204300465677E-18
      2.71439889402399E-09
      0.00000000000000E+00   8.03540421354931E-12   0.00000000000000E+00   1.63882885672714E-12  -4.06700475850630E-23
     -8.03710036595905E-09  -8.03546153710236E-09  -7.95372271569155E-19  -2.71549262548771E-01  -2.71549262567957E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91864819691446E-08   0.00000000000000E+00   1.91864819691446E-08
      2.80285795324688E-18  -1.04603650956883E-02  -6.94703814308790E-03   0.00000000000000E+00  -2.93478264587233E-11
     -7.67738241691694E-23  -1.11216726055834E-08  -1.11510204320422E-08  -2.00748568167772E-18
      2.73439889402399E-09
      0.00000000000000E+00   6.98194507777898E-12   0.00000000000000E+00   2.20076232969547E-12  -4.29035486521598E-23
     -6.98417160717932E-09  -6.98197084484966E-09  -9.40701929395752E-19  -2.03029072691636E-01  -2.03029072708222E-01
      0.00000000000000E+00   0.00000000000000E+00   1.65864678480786E-08   0.00000000000000E+00   1.65864678480786E-08
      3.13458731020845E-18  -2.58381622013256E-02  -2.28120949930553E-02   0.00000000000000E+00  -4.71968277463378E-11
     -8.40811880931534E-23  -9.55730017548258E-09  -9.60449700322900E-09  -2.19388538081270E-18
      2.75439889402399E-09
      0.00000000000000E+00   5.94951838682917E-12   0.00000000000000E+00   2.07135430406508E-12  -4.48272354504283E-23
     -5.95159696553703E-09  -5.94952561123301E-09  -1.06020042874775E-18  -1.41376192288092E-01  -1.41376192302290E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41986589966331E-08   0.00000000000000E+00   1.41986589966331E-08
      3.41856049014111E-18  -4.88354190078975E-02  -4.62363809464879E-02   0.00000000000000E+00  -7.29204287564019E-11
     -9.28446249095191E-23  -8.17621295664366E-09  -8.24913338540015E-09  -2.35836006139337E-18
      2.77439889402399E-09
      0.00000000000000E+00   4.86226038776647E-12   0.00000000000000E+00   2.15485980756503E-12  -4.63709555821250E-23
     -4.86443432616106E-09  -4.86227946635354E-09  -1.15638200463744E-18  -8.79290354122709E-02  -8.79290354242478E-02
      0.00000000000000E+00   0.00000000000000E+00   1.19769091844430E-08   0.00000000000000E+00   1.19769091844430E-08
      3.65809867382997E-18  -7.70344100305744E-02  -7.47928136544461E-02   0.00000000000000E+00  -1.02615056158801E-10
     -1.01541201821617E-22  -7.01201466193055E-09  -7.11462971808945E-09  -2.50171666919254E-18
      2.78439889402399E-09
      0.00000000000000E+00   4.00792064226205E-12   0.00000000000000E+00   3.67918832178219E-12  -4.69952961494733E-23
     -4.01156427197699E-09  -4.00788508365526E-09  -1.19581419108866E-18  -6.49526867669092E-02  -6.49526867772871E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03778468696628E-08   0.00000000000000E+00   1.03778468696628E-08
      3.76187714252660E-18  -9.27951250447683E-02  -9.07881400054448E-02   0.00000000000000E+00  -1.23168773929504E-10
     -1.05910469879691E-22  -6.24679301207796E-09  -6.36996178600757E-09  -2.56606295143794E-18
      2.79789889402399E-09
      0.00000000000000E+00   2.79703962691802E-12   0.00000000000000E+00   4.01630312753380E-12  -4.75549211472766E-23
     -2.80104171326302E-09  -2.79702541013553E-09  -1.23262726817611E-18  -4.27889811155144E-02  -4.27889811237528E-02
      0.00000000000000E+00   0.00000000000000E+00   8.23840172799432E-09   0.00000000000000E+00   8.23840172799432E-09
      3.87309556585452E-18  -1.16633580520386E-01  -1.14919164225787E-01   0.00000000000000E+00  -1.28089550933305E-10
     -1.11408982009689E-22  -5.31328676692528E-09  -5.44137631785870E-09  -2.64046829767842E-18
      2.81612389402399E-09
      0.00000000000000E+00   1.46382142161356E-12   0.00000000000000E+00   3.38842193896771E-12  -4.79019061013875E-23
     -1.46723332241214E-09  -1.46384490047322E-09  -1.25801896205903E-18  -2.68427074955913E-02  -2.68427075014112E-02
      0.00000000000000E+00   0.00000000000000E+00   5.81993832072305E-09   0.00000000000000E+00   5.81993832072305E-09
      3.97916394174970E-18  -1.51664193350918E-01  -1.50291716490168E-01   0.00000000000000E+00  -1.26776598418485E-10
     -1.17971119390967E-22  -4.22931682183122E-09  -4.35609342024982E-09  -2.72114497969067E-18
      2.83612389402399E-09
      0.00000000000000E+00   6.67711239498719E-13   0.00000000000000E+00   1.87413937262369E-12  -4.80410715111284E-23
     -6.69586713729379E-10  -6.67712574356804E-10  -1.26999185941124E-18  -1.88251045913848E-02  -1.88251045955674E-02
      0.00000000000000E+00   0.00000000000000E+00   4.18263625957557E-09   0.00000000000000E+00   4.18263625957557E-09
      4.06281666694121E-18  -1.89894316949185E-01  -1.88786864697872E-01   0.00000000000000E+00  -1.26223203073898E-10
     -1.24371009826942E-22  -3.38870048214482E-09  -3.51492368521884E-09  -2.79282480752998E-18
      2.85612389402399E-09
      0.00000000000000E+00   3.42580869784075E-13   0.00000000000000E+00   7.68751724386616E-13  -4.80944414222539E-23
     -3.43334773146723E-10  -3.42566021422385E-10  -1.27549680365373E-18  -1.48186103181386E-02  -1.48186103213746E-02
      0.00000000000000E+00   0.00000000000000E+00   3.23596177009487E-09   0.00000000000000E+00   3.23596177009487E-09
      4.12753590234311E-18  -2.24732773123829E-01  -2.23821143533278E-01   0.00000000000000E+00  -1.23866498051762E-10
     -1.30053654374989E-22  -2.76952925062056E-09  -2.89339574867245E-09  -2.85203909868939E-18
      2.87612389402399E-09
      0.00000000000000E+00   2.21162127195724E-13   0.00000000000000E+00   2.86240018318735E-13  -4.81185416887424E-23
     -2.21420917268084E-10  -2.21134677249813E-10  -1.27860335368340E-18  -1.24303751207947E-02  -1.24303751233493E-02
      0.00000000000000E+00   0.00000000000000E+00   2.55460989876986E-09   0.00000000000000E+00   2.55460989876986E-09
      4.17862810031851E-18  -2.54009454993375E-01  -2.53274239082575E-01   0.00000000000000E+00  -1.13756492544986E-10
     -1.34867062222480E-22  -2.21971872897493E-09  -2.33347522152005E-09  -2.90002474663511E-18
      2.89612389402399E-09
      0.00000000000000E+00   1.71657813840867E-13   0.00000000000000E+00   1.16570739323878E-13  -4.81306205891495E-23
     -1.71710637687805E-10  -1.71594066948529E-10  -1.28074314390624E-18  -1.08106437300554E-02  -1.08106437320315E-02
      0.00000000000000E+00   0.00000000000000E+00   1.97604583653243E-09   0.00000000000000E+00   1.97604583653243E-09
      4.21814901704916E-18  -2.76810919917739E-01  -2.76242385043471E-01   0.00000000000000E+00  -9.54467946642507E-11
     -1.38666111476874E-22  -1.70900497491946E-09  -1.80445176958385E-09  -2.93740587314292E-18
      2.91612389402399E-09
      0.00000000000000E+00   1.47410803218080E-13   0.00000000000000E+00   5.75410769068726E-14  -4.81365101457523E-23
     -1.47474950295291E-10  -1.47417409218432E-10  -1.28241784603306E-18  -9.64109571345129E-03  -9.64109571493518E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48389237095614E-09   0.00000000000000E+00   1.48389237095614E-09
      4.24782686446828E-18  -2.93367949828946E-01  -2.92946863553766E-01   0.00000000000000E+00  -7.28254046710669E-11
     -1.41443955861166E-22  -1.26364955706647E-09  -1.33647496173768E-09  -2.96540901843521E-18
      2.93612389402399E-09
      0.00000000000000E+00   1.34185161060197E-13   0.00000000000000E+00   3.22880261239837E-14  -4.81390344327922E-23
     -1.34232457588947E-10  -1.34200169562871E-10  -1.28384199111764E-18  -8.76626299245053E-03  -8.76626299352738E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07684603758181E-09   0.00000000000000E+00   1.07684603758181E-09
      4.26936378521992E-18  -3.04421499154928E-01  -3.04124500438506E-01   0.00000000000000E+00  -4.96015036270450E-11
     -1.43288534029398E-22  -8.93044364391753E-10  -9.42645868018942E-10  -2.98552179410228E-18
      2.95612389402399E-09
      0.00000000000000E+00   1.23255637332501E-13   0.00000000000000E+00   2.80056316206038E-14  -4.81383872594967E-23
     -1.23323696006782E-10  -1.23295690375209E-10  -1.28505856776674E-18  -8.12051742433404E-03  -8.12051742510883E-03
      0.00000000000000E+00   0.00000000000000E+00   7.74791628223149E-10   0.00000000000000E+00   7.74791628223149E-10
      4.28485961778438E-18  -3.11359937511082E-01  -3.11154674772748E-01   0.00000000000000E+00  -3.05583053051085E-11
     -1.44412992204593E-22  -6.20937632542678E-10  -6.51495937847931E-10  -2.99980105001764E-18
      2.97612389402399E-09
      0.00000000000000E+00   1.07550187270014E-13   0.00000000000000E+00   4.23256998023793E-14  -4.81323725484102E-23
     -1.07561242355288E-10  -1.07518916655534E-10  -1.28596917125276E-18  -7.69487181617692E-03  -7.69487181681429E-03
      0.00000000000000E+00   0.00000000000000E+00   6.37372228415964E-10   0.00000000000000E+00   6.37372228415964E-10
      4.29760706235270E-18  -3.16739575636100E-01  -3.16572640223116E-01   0.00000000000000E+00  -2.27795947259971E-11
     -1.45240717855436E-22  -5.07073717034371E-10  -5.29853311760513E-10  -3.01163789109994E-18
      2.99612389402399E-09
      0.00000000000000E+00   9.68961977539407E-14   0.00000000000000E+00   3.11758473437004E-14  -4.81234795574500E-23
     -9.69054780247641E-11  -9.68743021774685E-11  -1.28667660702549E-18  -7.38442725302896E-03  -7.38442725364286E-03
      0.00000000000000E+00   0.00000000000000E+00   6.13897762073071E-10   0.00000000000000E+00   6.13897762073071E-10
      4.30988501759416E-18  -3.22093947991734E-01  -3.21931054900407E-01   0.00000000000000E+00  -2.26458427093184E-11
     -1.46047230252814E-22  -4.94377617186100E-10  -5.17023459895564E-10  -3.02320841056867E-18
      3.01612389402399E-09
      0.00000000000000E+00   9.00996872005837E-14   0.00000000000000E+00   2.23701391581719E-14  -4.81130272202100E-23
     -9.01250830081333E-11  -9.01027128690233E-11  -1.28725876912858E-18  -7.12969540012213E-03  -7.12969540075102E-03
      0.00000000000000E+00   0.00000000000000E+00   6.28895953211862E-10   0.00000000000000E+00   6.28895953211862E-10
      4.32246293665840E-18  -3.27870816493317E-01  -3.27701064024276E-01   0.00000000000000E+00  -2.49471210631603E-11
     -1.46918439115703E-22  -5.13846119279532E-10  -5.38793240342839E-10  -3.03520416752981E-18
      3.02612389402399E-09
      0.00000000000000E+00   8.36705555960569E-14   0.00000000000000E+00   3.79699873820653E-14  -4.81066255711940E-23
     -8.37534028089283E-11  -8.37154328215943E-11  -1.28748865316998E-18  -7.03069162190099E-03  -7.03069162255185E-03
      0.00000000000000E+00   0.00000000000000E+00   6.50866214914636E-10   0.00000000000000E+00   6.50866214914636E-10
      4.32897159880754E-18  -3.31019010431759E-01  -3.30840322807655E-01   0.00000000000000E+00  -2.76699046636711E-11
     -1.47394610896055E-22  -5.39480877429327E-10  -5.67150782093145E-10  -3.04148294563756E-18
      3.03287389402399E-09
      0.00000000000000E+00   7.35676345032289E-14   0.00000000000000E+00   8.21041425631931E-14  -4.81007854400639E-23
     -7.36337535856457E-11  -7.35516494431306E-11  -1.28757657793093E-18  -6.99321641902822E-03  -6.99321641974058E-03
      0.00000000000000E+00   0.00000000000000E+00   7.12356951709660E-10   0.00000000000000E+00   7.12356951709660E-10
      4.33378000823158E-18  -3.33567398359446E-01  -3.33366133258461E-01   0.00000000000000E+00  -3.40120793155723E-11
     -1.47784507462157E-22  -6.04793222950632E-10  -6.38805302266352E-10  -3.04620343030065E-18
      3.04198639402399E-09
      0.00000000000000E+00   6.22707318267031E-14   0.00000000000000E+00   7.11299545295843E-14  -4.80913817335179E-23
     -6.23307720618888E-11  -6.22596421074073E-11  -1.28759530258230E-18  -6.97218347636768E-03  -6.97218347721882E-03
      0.00000000000000E+00   0.00000000000000E+00   8.51134535656448E-10   0.00000000000000E+00   8.51134535656448E-10
      4.34153597168775E-18  -3.38119598676728E-01  -3.37871048748024E-01   0.00000000000000E+00  -4.67355315322758E-11
     -1.48499701742997E-22  -7.42139362016605E-10  -7.88874893549029E-10  -3.05394066910545E-18
      3.05428826902399E-09
      0.00000000000000E+00   5.56579107477612E-14   0.00000000000000E+00   3.75839439437313E-14  -4.80780627004771E-23
     -5.56547930106786E-11  -5.56172090667829E-11  -1.28754511383837E-18  -6.93707554664230E-03  -6.93707554767786E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03556422412479E-09   0.00000000000000E+00   1.03556422412479E-09
      4.35427535332741E-18  -3.46098585781518E-01  -3.45789831865818E-01   0.00000000000000E+00  -6.32674921898824E-11
     -1.49790480101143E-22  -9.16679522867892E-10  -9.79947015057924E-10  -3.06673023948904E-18
      3.07089580027399E-09
      0.00000000000000E+00   5.76784949663268E-14   0.00000000000000E+00   3.97172156032573E-15  -4.80619194641370E-23
     -5.76903944882539E-11  -5.76864227667417E-11  -1.28752409854184E-18  -6.80828846235818E-03  -6.80828846353661E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17842353569942E-09   0.00000000000000E+00   1.17842353569942E-09
      4.37384605902227E-18  -3.58627358448316E-01  -3.58274243757503E-01   0.00000000000000E+00  -7.69578719408832E-11
     -1.51872587465632E-22  -1.04377924099165E-09  -1.12073711293268E-09  -3.08632196048043E-18
      3.09089580027399E-09
      0.00000000000000E+00   6.75977265847397E-14   0.00000000000000E+00  -1.64980940409601E-14  -4.80471529923312E-23
     -6.75379180087108E-11  -6.75544161027999E-11  -1.28771392560904E-18  -6.50331788024329E-03  -6.50331788146806E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22476603638887E-09   0.00000000000000E+00   1.22476603638887E-09
      4.39834137975005E-18  -3.74193447841451E-01  -3.73828840516491E-01   0.00000000000000E+00  -8.34623023353191E-11
     -1.54528063287654E-22  -1.07374931795054E-09  -1.15721162028601E-09  -3.11062745414100E-18
      3.11089580027399E-09
      0.00000000000000E+00   8.40379345448870E-14   0.00000000000000E+00  -3.60457805402619E-14  -4.80392337395168E-23
     -8.39657327130633E-11  -8.40017784936516E-11  -1.28824925171284E-18  -5.99666869680327E-03  -5.99666869802199E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21872401810313E-09   0.00000000000000E+00   1.21872401810313E-09
      4.42271586011211E-18  -3.89293541745383E-01  -3.88936020164070E-01   0.00000000000000E+00  -8.55062924657624E-11
     -1.57180368735570E-22  -1.04921594714362E-09  -1.13472223960954E-09  -3.13446660839927E-18
      3.13089580027399E-09
      0.00000000000000E+00   1.00386297767827E-13   0.00000000000000E+00  -3.91683828070769E-14  -4.80376074742154E-23
     -1.00344157851552E-10  -1.00383326234407E-10  -1.28912730319480E-18  -5.29802122701552E-03  -5.29802122821255E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19703540923512E-09   0.00000000000000E+00   1.19703540923512E-09
      4.44665656829681E-18  -4.03691696088033E-01  -4.03346169562451E-01   0.00000000000000E+00  -8.59481771271923E-11
     -1.59783564823044E-22  -1.01070390587333E-09  -1.09665208300068E-09  -3.15752926510201E-18
      3.15089580027399E-09
      0.00000000000000E+00   1.05805137263071E-13   0.00000000000000E+00  -1.34772279871299E-14  -4.80376500723242E-23
     -1.05789401131721E-10  -1.05802878359756E-10  -1.29012785940983E-18  -4.54098893630503E-03  -4.54098893746426E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15923147358017E-09   0.00000000000000E+00   1.15923147358017E-09
      4.46984119776842E-18  -4.17423107152896E-01  -4.17091199509038E-01   0.00000000000000E+00  -8.54986388421308E-11
     -1.62316602631823E-22  -9.67929956378097E-10  -1.05342859522039E-09  -3.17971333835859E-18
      3.17089580027399E-09
      0.00000000000000E+00   9.46919240609601E-14   0.00000000000000E+00   2.90079319827265E-14  -4.80331698977686E-23
     -9.46847425202446E-11  -9.46557345883099E-11  -1.29091944272498E-18  -3.92364146452456E-03  -3.92364146562484E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10027692842719E-09   0.00000000000000E+00   1.10027692842719E-09
      4.49184673633696E-18  -4.30589839688289E-01  -4.30272995368953E-01   0.00000000000000E+00  -8.40851150467517E-11
     -1.64757415172935E-22  -9.21536078791939E-10  -1.00562119383885E-09  -3.20092729361198E-18
      3.19089580027399E-09
      0.00000000000000E+00   4.51876107061032E-14   0.00000000000000E+00   1.31740594069966E-13  -4.80093972062718E-23
     -4.53115559935487E-11  -4.51798153995267E-11  -1.29073732815109E-18  -3.90465047114766E-03  -3.90465047213266E-03
      0.00000000000000E+00   0.00000000000000E+00   9.85001762021249E-10   0.00000000000000E+00   9.85001762021249E-10
      4.51154677157739E-18  -4.43319594945708E-01  -4.43023483189535E-01   0.00000000000000E+00  -8.00210820780459E-11
     -1.67036735086987E-22  -8.59800864543541E-10  -9.39821946621754E-10  -3.22080944342629E-18
      3.21089580027399E-09
      0.00000000000000E+00  -3.08598317017290E-13   0.00000000000000E+00   9.40758691883994E-13  -4.78431311996073E-23
      3.07702075258489E-10   3.08642833950326E-10  -1.28351423564940E-18  -8.12823239652031E-03  -8.12823239690624E-03
      0.00000000000000E+00   0.00000000000000E+00   3.85929684498901E-10   0.00000000000000E+00   3.85929684498901E-10
      4.51926536526736E-18  -4.56093595485307E-01  -4.55874760537783E-01   0.00000000000000E+00  -5.32803023367515E-11
     -1.68524547772944E-22  -6.41292216112281E-10  -6.94572518449201E-10  -3.23575112961796E-18
      3.23089580027399E-09
      0.00000000000000E+00  -1.18507264418872E-12   0.00000000000000E+00   2.36653446631304E-12  -4.73411611639819E-23
      1.18274203051763E-09   1.18510856498390E-09  -1.25888080132156E-18  -2.26388265957871E-02  -2.26388265947462E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.04083192221100E-09   0.00000000000000E+00  -1.04083192221100E-09
      4.49844872682314E-18  -4.69579954436123E-01  -4.69534516255216E-01   0.00000000000000E+00   1.26457659403551E-11
     -1.68139236806407E-22  -1.56922408713031E-10  -1.44276642772844E-10  -3.23956792550158E-18
      3.25089580027399E-09
      0.00000000000000E+00  -1.93526045769980E-12   0.00000000000000E+00   2.14704680517752E-12  -4.66000598096825E-23
      1.93311165335015E-09   1.93525870015528E-09  -1.21958354207735E-18  -4.52695294079886E-02  -4.52695294057542E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.23443089992000E-09   0.00000000000000E+00  -2.23443089992000E-09
      4.45376010882474E-18  -4.83409671621190E-01  -4.83503963811832E-01   0.00000000000000E+00   6.51824976777150E-11
     -1.66251996374845E-22   2.33989702087127E-10   2.99172199764676E-10  -3.23417656674740E-18
      3.25589580027399E-09
      0.00000000000000E+00  -2.21520321670834E-12   0.00000000000000E+00   3.06486881365502E-12  -4.63867103848077E-23
      2.21213602937070E-09   2.21520089818430E-09  -1.20839703028764E-18  -5.16047555101136E-02  -5.16047555074492E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.66447608274607E-09   0.00000000000000E+00  -2.66447608274607E-09
      4.44043772841101E-18  -4.86869375569618E-01  -4.87010965307280E-01   0.00000000000000E+00   8.20291929675576E-11
     -1.65658174568688E-22   3.67245991594042E-10   4.49275184561434E-10  -3.23204069812337E-18
      3.26264580027399E-09
      0.00000000000000E+00  -2.44453952551553E-12   0.00000000000000E+00   2.00869997927211E-12  -4.60856405684421E-23
      2.44249871035729E-09   2.44450741033652E-09  -1.19184122514939E-18  -6.08738552719179E-02  -6.08738552689085E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.00931358116866E-09   0.00000000000000E+00  -3.00931358116866E-09
      4.42012486173813E-18  -4.91556441877707E-01  -4.91734435052652E-01   0.00000000000000E+00   9.45913043638267E-11
     -1.64729804812731E-22   4.70214866468662E-10   5.64806170832324E-10  -3.22828363658873E-18
      3.27175830027399E-09
      0.00000000000000E+00  -2.72347199241479E-12   0.00000000000000E+00   1.84568969312881E-12  -4.56468962750314E-23
      2.72162723582685E-09   2.72347292551993E-09  -1.16721335085035E-18  -7.44483617363751E-02  -7.44483617329715E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.40367280617260E-09   0.00000000000000E+00  -3.40367280617260E-09
      4.38910889329188E-18  -4.97874118845623E-01  -4.98088474174910E-01   0.00000000000000E+00   1.07854155943919E-10
     -1.63294339611085E-22   5.72345724709061E-10   6.80199880652816E-10  -3.22189554244153E-18
      3.27790923777399E-09
      0.00000000000000E+00  -2.96943219865655E-12   0.00000000000000E+00   2.30626146286051E-12  -4.53285216136428E-23
      2.96717019260045E-09   2.96947645406326E-09  -1.14925900411385E-18  -8.41952422287540E-02  -8.41952422250162E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.73781714489679E-09   0.00000000000000E+00  -3.73781714489679E-09
      4.36611781364719E-18  -5.02129123533365E-01  -5.02371253575681E-01   0.00000000000000E+00   1.17853572807971E-10
     -1.62230920298071E-22   6.50487118025588E-10   7.68340690833397E-10  -3.21685880953334E-18
      3.28621300339899E-09
      0.00000000000000E+00  -3.30889034737557E-12   0.00000000000000E+00   2.35951326283777E-12  -4.48652223859886E-23
      3.30655610054274E-09   3.30891561380553E-09  -1.12271604551154E-18  -9.83718291193614E-02  -9.83718291151908E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.17059637678019E-09   0.00000000000000E+00  -4.17059637678019E-09
      4.33148615881793E-18  -5.07857628684674E-01  -5.08129174880699E-01   0.00000000000000E+00   1.30540244715487E-10
     -1.60631757745126E-22   7.31140518259200E-10   8.61680762974526E-10  -3.20877011330639E-18
      3.29742308699274E-09
      0.00000000000000E+00  -3.82386378889817E-12   0.00000000000000E+00   2.60910303945484E-12  -4.41541627401910E-23
      3.82130869191099E-09   3.82391779495040E-09  -1.08283420148447E-18  -1.19174692826065E-01  -1.19174692821328E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.73662727707154E-09   0.00000000000000E+00  -4.73662727707154E-09
      4.27838817108953E-18  -5.15469850589755E-01  -5.15757489248861E-01   0.00000000000000E+00   1.44924725533058E-10
     -1.58211680502762E-22   7.67784756588318E-10   9.12709482121218E-10  -3.19555396960506E-18
      3.31255669984430E-09
      0.00000000000000E+00  -4.62190271049437E-12   0.00000000000000E+00   2.92328817484422E-12  -4.27300247799466E-23
      4.61904276671007E-09   4.62196605488487E-09  -1.02398862329267E-18  -1.48833127608579E-01  -1.48833127603295E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28408520268008E-09   0.00000000000000E+00  -5.28408520268008E-09
      4.19842087135749E-18  -5.25039817920331E-01  -5.25248539341991E-01   0.00000000000000E+00   1.53880027775226E-10
     -1.54678775500308E-22   5.08239120020185E-10   6.62119147795257E-10  -3.17443224806483E-18
      3.33255669984430E-09
      0.00000000000000E+00  -6.37650457010696E-12   0.00000000000000E+00   4.59296748123948E-12  -3.70388552773990E-23
      6.37187424706193E-09   6.37646721454313E-09  -9.43951692779481E-19  -1.87358170743645E-01  -1.87358170738005E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64041507288273E-09   0.00000000000000E+00  -5.64041507288273E-09
      4.08561256989984E-18  -5.34470296489390E-01  -5.34238607334517E-01   0.00000000000000E+00   1.53883308704758E-10
     -1.49833110239483E-22  -8.89935450364980E-10  -7.36052141660371E-10  -3.14166087712036E-18
      3.35255669984430E-09
      0.00000000000000E+00  -1.01853058221031E-11   0.00000000000000E+00   9.58608429405666E-12  -1.76650241649506E-23
      1.01757248084083E-08   1.01853108927024E-08  -8.67479648971966E-19  -2.22461508850722E-01  -2.22461508844845E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.87640209480803E-09   0.00000000000000E+00  -5.87640209480803E-09
      3.96808452800368E-18  -5.36688037734713E-01  -5.35330883832716E-01   0.00000000000000E+00   1.53750060339416E-10
     -1.44638172232339E-22  -4.46265885823356E-09  -4.30890879789429E-09  -3.10060487903171E-18
      3.37255669984430E-09
      0.00000000000000E+00  -1.69113714620219E-11   0.00000000000000E+00   1.67231851216814E-11   2.46046806960646E-23
      1.68946457445202E-08   1.69113689296419E-08  -8.00561419702031E-19  -2.52130205611716E-01  -2.52130205605593E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.12328998102265E-09   0.00000000000000E+00  -6.12328998102265E-09
      3.84561872838322E-18  -5.26295798656360E-01  -5.22897595641268E-01   0.00000000000000E+00   1.61532603218201E-10
     -1.38531964711158E-22  -1.09496115518374E-08  -1.07880789486193E-08  -3.04505730868119E-18
      3.39255669984430E-09
      0.00000000000000E+00  -2.55343064594878E-11   0.00000000000000E+00   2.13808684075589E-11   7.92068836443231E-23
      2.55129332945651E-08   2.55343141629728E-08  -7.47277484187098E-19  -2.75453879556752E-01  -2.75453879550342E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.40946772269039E-09   0.00000000000000E+00  -6.40946772269039E-09
      3.71742937392942E-18  -4.99139777682499E-01  -4.93115202762211E-01   0.00000000000000E+00   1.71653352326723E-10
     -1.30980930511842E-22  -1.92964997926089E-08  -1.91248464402823E-08  -2.97015188974232E-18
      3.41255669984430E-09
      0.00000000000000E+00  -3.33702239038223E-11   0.00000000000000E+00   1.94397690805736E-11   1.29305838664198E-22
      3.33507592687947E-08   3.33701990378754E-08  -7.08645983065560E-19  -2.92645074533886E-01  -2.92645074527187E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.69848948466097E-09   0.00000000000000E+00  -6.69848948466097E-09
      3.58345958423620E-18  -4.54204737148674E-01  -4.45802451968393E-01   0.00000000000000E+00   1.74157831496951E-10
     -1.21956368808935E-22  -2.68458673847114E-08  -2.66717095532146E-08  -2.87481360117064E-18
      3.43255669984430E-09
      0.00000000000000E+00  -3.78072431583179E-11   0.00000000000000E+00   1.10365083951454E-11   1.59353424620873E-22
      3.77962059510932E-08   3.78072424594885E-08  -6.83814472137501E-19  -3.04382723252025E-01  -3.04382723245053E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97179076460790E-09   0.00000000000000E+00  -6.97179076460790E-09
      3.44402376894404E-18  -3.92826308946045E-01  -3.83112005284424E-01   0.00000000000000E+00   1.65634583957607E-10
     -1.12123906098533E-22  -3.10010862788380E-08  -3.08354516948805E-08  -2.76020929680654E-18
      3.45255669984430E-09
      0.00000000000000E+00  -3.77359716422449E-11   0.00000000000000E+00  -1.31963198749637E-13   1.62747220922817E-22
      3.77361253484115E-08   3.77359933852129E-08  -6.70855845616390E-19  -3.11572854520778E-01  -3.11572854513561E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.21734726144486E-09   0.00000000000000E+00  -7.21734726144486E-09
      3.29967682371514E-18  -3.18928808087915E-01  -3.09314048983201E-01   0.00000000000000E+00   1.45783354305180E-10
     -1.02343922531570E-22  -3.06644294780731E-08  -3.05186461237681E-08  -2.62882097809875E-18
      3.47255669984430E-09
      0.00000000000000E+00  -3.50886389369751E-11   0.00000000000000E+00  -6.52856850141849E-12   1.48351592072215E-22
      3.50951700049565E-08   3.50886414364553E-08  -6.64186377949557E-19  -3.16423979907888E-01  -3.16423979900547E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34009090174123E-09   0.00000000000000E+00  -7.34009090174123E-09
      3.15287500568032E-18  -2.43326878128833E-01  -2.34584636856484E-01   0.00000000000000E+00   1.10276066841719E-10
     -9.22239007150520E-23  -2.78588266015556E-08  -2.77485505347139E-08  -2.48868862773076E-18
      3.49255669984430E-09
      0.00000000000000E+00  -3.25137717293621E-11   0.00000000000000E+00  -6.36290984563265E-12   1.30204589705556E-22
      3.25201354661666E-08   3.25137725563211E-08  -6.57773950229096E-19  -3.21238786322488E-01  -3.21238786315179E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30894402608572E-09   0.00000000000000E+00  -7.30894402608572E-09
      3.00669612515860E-18  -1.75408244956002E-01  -1.67467280195015E-01   0.00000000000000E+00   7.29529593814196E-11
     -8.36705231728049E-23  -2.52777814896168E-08  -2.52048285302354E-08  -2.34892217492951E-18
      3.50255669984430E-09
      0.00000000000000E+00  -3.11701750687532E-11   0.00000000000000E+00  -6.62224341201226E-12   1.20384521203574E-22
      3.11768680456550E-08   3.11702458022431E-08  -6.54752925232517E-19  -3.23587758614587E-01  -3.23587758607291E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29598475523240E-09   0.00000000000000E+00  -7.29598475523240E-09
      2.93373627760628E-18  -1.43708971727852E-01  -1.36187168326880E-01   0.00000000000000E+00   5.55105624140053E-11
     -8.08261006340055E-23  -2.39297716094245E-08  -2.38742610470106E-08  -2.27898335237376E-18
      3.51605669984430E-09
      0.00000000000000E+00  -2.98544992082554E-11   0.00000000000000E+00  -4.81534904068477E-12   1.09390844872425E-22
      2.98592823806903E-08   2.98544670316498E-08  -6.49346490315775E-19  -3.27280113472180E-01  -3.27280113464965E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.21423826783592E-09   0.00000000000000E+00  -7.21423826783592E-09
      2.83634406099049E-18  -1.05381528619103E-01  -9.82484681478717E-02   0.00000000000000E+00   4.23253205980345E-11
     -7.63636406350667E-23  -2.26825540844117E-08  -2.26402287638137E-08  -2.18699757067472E-18
      3.53428169984430E-09
      0.00000000000000E+00  -2.79480779980388E-11   0.00000000000000E+00  -4.98756984474015E-12   9.97128503775292E-23
      2.79531587142950E-08   2.79481711444503E-08  -6.38084042040165E-19  -3.33682220170906E-01  -3.33682220163852E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.05395902660693E-09   0.00000000000000E+00  -7.05395902660693E-09
      2.70778565773058E-18  -6.32841206169348E-02  -5.67011732278493E-02   0.00000000000000E+00   3.08228249451047E-11
     -5.42045188158373E-23  -2.09250349427887E-08  -2.08942121178436E-08  -2.06970161569042E-18
      3.53928169984430E-09
      0.00000000000000E+00  -2.68615547568737E-11   0.00000000000000E+00  -1.06665813401422E-11   9.74266733138740E-23
      2.68722578127805E-08   2.68615912314405E-08  -6.34289442856450E-19  -3.35654537135596E-01  -3.35654537128610E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.98593693361969E-09   0.00000000000000E+00  -6.98593693361969E-09
      2.67285597306248E-18  -5.32159483372793E-02  -4.69538487306174E-02   0.00000000000000E+00   3.02686448160307E-11
     -4.03698343717289E-23  -1.99059229426365E-08  -1.98756542978205E-08  -2.03856653020603E-18
      3.54603169984430E-09
      0.00000000000000E+00  -2.54972011856559E-11   0.00000000000000E+00  -9.96746821710520E-12   9.69355408895888E-23
      2.55072275484989E-08   2.54972600802819E-08  -6.27057988476773E-19  -3.39053459902465E-01  -3.39053459895644E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.82148616160967E-09   0.00000000000000E+00  -6.82148616160967E-09
      2.62681094147162E-18  -4.24656349343798E-02  -3.65815639104614E-02   0.00000000000000E+00   2.51493744799032E-11
     -1.58699040960327E-23  -1.87009232931521E-08  -1.86757739186722E-08  -1.99975295299485E-18
      3.55514419984430E-09
      0.00000000000000E+00  -2.38869792529336E-11   0.00000000000000E+00  -8.70244294343275E-12   1.00751538447525E-22
      2.38957186313547E-08   2.38870161884113E-08  -6.13914987429958E-19  -3.44803397000645E-01  -3.44803396994045E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.59985772838427E-09   0.00000000000000E+00  -6.59985772838427E-09
      2.56666973792172E-18  -3.23779755997907E-02  -2.69313976675986E-02   0.00000000000000E+00   1.99272077062280E-11
      2.20276863352580E-23  -1.73070856677334E-08  -1.72871584600272E-08  -1.95275475049176E-18
      3.56744607484430E-09
      0.00000000000000E+00  -2.23302109572660E-11   0.00000000000000E+00  -6.21943182918517E-12   1.10932414684311E-22
      2.23364229063302E-08   2.23302034745011E-08  -5.92350860865242E-19  -3.53854272561469E-01  -3.53854272555100E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.36947233036893E-09   0.00000000000000E+00  -6.36947233036893E-09
      2.48831328549756E-18  -2.42213289128180E-02  -1.91926522085401E-02   0.00000000000000E+00   1.43245605025090E-11
      6.98326126134174E-23  -1.59750557046348E-08  -1.59607311441322E-08  -1.89596242463232E-18
      3.58405360609430E-09
      0.00000000000000E+00  -2.10886537996946E-11   0.00000000000000E+00  -3.65675054331542E-12   1.26462074853678E-22
      2.10923115710100E-08   2.10886548204668E-08  -5.60808727944637E-19  -3.66837692636822E-01  -3.66837692630647E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.17447574798861E-09   0.00000000000000E+00  -6.17447574798861E-09
      2.38577048656047E-18  -1.83082705143562E-02  -1.36093177784237E-02   0.00000000000000E+00   9.65130468797718E-12
      1.23062397509316E-22  -1.49238303771662E-08  -1.49141790724781E-08  -1.82496175861584E-18
      3.60405360609430E-09
      0.00000000000000E+00  -2.01634099170660E-11   0.00000000000000E+00  -2.24813925382736E-12   1.39648104164011E-22
      2.01656880823327E-08   2.01634399430790E-08  -5.23089402221580E-19  -3.82286247335423E-01  -3.82286247329397E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.02610199299850E-09   0.00000000000000E+00  -6.02610199299850E-09
      2.26524844670050E-18  -1.44447906572087E-02  -9.99058744826457E-03   0.00000000000000E+00   6.86821113464690E-12
      1.67686279073964E-22  -1.41442061612154E-08  -1.41373379500806E-08  -1.74215904447892E-18
      3.62405360609430E-09
      0.00000000000000E+00  -1.94234168693850E-11   0.00000000000000E+00  -1.79298356327623E-12   1.42921372493160E-22
      1.94251762296693E-08   1.94233832461062E-08  -4.87087799643996E-19  -3.97078277950744E-01  -3.97078277944832E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.91218034744749E-09   0.00000000000000E+00  -5.91218034744749E-09
      2.14700483975155E-18  -1.20850901353194E-02  -7.82815636496592E-03   0.00000000000000E+00   5.51810973602143E-12
      1.89852943685359E-22  -1.35167210083949E-08  -1.35112028986587E-08  -1.65991704010756E-18
      3.64405360609430E-09
      0.00000000000000E+00  -1.87674617562488E-11   0.00000000000000E+00  -1.58867082792897E-12   1.35939697704722E-22
      1.87690178452582E-08   1.87674291744304E-08  -4.53045287295356E-19  -4.11161821359111E-01  -4.11161821353299E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.81133503094273E-09   0.00000000000000E+00  -5.81133503094273E-09
      2.03077813913270E-18  -1.04887603400258E-02  -6.40671933047464E-03   0.00000000000000E+00   4.71219180217667E-12
      1.90637162296967E-22  -1.29608063352901E-08  -1.29560941434877E-08  -1.57773285183734E-18
      3.66405360609430E-09
      0.00000000000000E+00  -1.81954527329203E-11   0.00000000000000E+00  -1.38472497028993E-12   1.20759168723379E-22
      1.81967970708819E-08   1.81954123459117E-08  -4.20751443443952E-19  -4.24617906649653E-01  -4.24617906643933E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72041967432846E-09   0.00000000000000E+00  -5.72041967432846E-09
      1.91636974564613E-18  -9.34828263938009E-03  -5.41781796421161E-03   0.00000000000000E+00   4.08883279694963E-12
      1.74318482619937E-22  -1.24790815043804E-08  -1.24749926715833E-08  -1.49561830220218E-18
      3.68405360609430E-09
      0.00000000000000E+00  -1.77107880546762E-11   0.00000000000000E+00  -1.17165308941864E-12   1.00519713097537E-22
      1.77119328164997E-08   1.77107611634104E-08  -3.89909991900373E-19  -4.37544692564954E-01  -4.37544692559315E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63819700835216E-09   0.00000000000000E+00  -5.63819700835216E-09
      1.80360580547909E-18  -8.50544578940074E-03  -4.70177075333916E-03   0.00000000000000E+00   3.56843819021269E-12
      1.46898750762835E-22  -1.20761325932485E-08  -1.20725641550582E-08  -1.41369581357871E-18
      3.70405360609430E-09
      0.00000000000000E+00  -1.73309182215859E-11   0.00000000000000E+00  -9.15062020887452E-13   7.85812084347474E-23
      1.73318445638800E-08   1.73309295018592E-08  -3.60133468379090E-19  -4.50082763532801E-01  -4.50082763527212E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58813472121353E-09   0.00000000000000E+00  -5.58813472121353E-09
      1.69184311105481E-18  -7.86802142114862E-03  -4.16824390570193E-03   0.00000000000000E+00   3.14517468222072E-12
      1.14669282576130E-22  -1.17459399553280E-08  -1.17427947806457E-08  -1.33170964267573E-18
      3.72405360609430E-09
      0.00000000000000E+00  -1.73298160847394E-11   0.00000000000000E+00   1.81820248759567E-14   5.80096656078320E-23
      1.73297993347753E-08   1.73298175168003E-08  -3.29915500084755E-19  -4.62868156864447E-01  -4.62868156858657E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.79078541463636E-09   0.00000000000000E+00  -5.79078541463636E-09
      1.57602740276209E-18  -7.43113413901034E-03  -3.79555406906858E-03   0.00000000000000E+00   2.72455170025519E-12
      8.31463735382721E-23  -1.15417566538642E-08  -1.15390321021639E-08  -1.24611190267733E-18
      3.74405360609430E-09
      0.00000000000000E+00  -1.77154721362738E-11   0.00000000000000E+00   9.72083149217223E-13   4.05110878012957E-23
      1.77145572664632E-08   1.77155293496125E-08  -2.98251461091477E-19  -4.76357649509421E-01  -4.76357649503202E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.21887110466533E-09   0.00000000000000E+00  -6.21887110466533E-09
      1.45164998066878E-18  -7.16706409870503E-03  -3.54483258878634E-03   0.00000000000000E+00   2.29855798680351E-12
      5.56991566162494E-23  -1.14989568029341E-08  -1.14966582449472E-08  -1.15339851957730E-18
      3.75405360609430E-09
      0.00000000000000E+00  -1.79200103660350E-11   0.00000000000000E+00   1.03052153064227E-12   3.23709499954033E-23
      1.79189518928024E-08   1.79199824143331E-08  -2.82292838844084E-19  -4.83209773762420E-01  -4.83209773755981E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.43837238148812E-09   0.00000000000000E+00  -6.43837238148812E-09
      1.38726625685390E-18  -7.05630228928131E-03  -3.43881101301814E-03   0.00000000000000E+00   2.19890809723688E-12
      4.27848588950391E-23  -1.14838089409420E-08  -1.14816100328447E-08  -1.10497341800981E-18
      3.76755360609430E-09
      0.00000000000000E+00  -1.80950664351525E-11   0.00000000000000E+00   6.62380103620651E-13   2.37058198563582E-23
      1.80943601439928E-08   1.80950225240965E-08  -2.60732530707589E-19  -4.92516727089842E-01  -4.92516727083268E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.57394257872898E-09   0.00000000000000E+00  -6.57394257872898E-09
      1.29851803204106E-18  -6.93490680701018E-03  -3.30497858034613E-03   0.00000000000000E+00   1.92054982679945E-12
      2.91628071424770E-23  -1.15230004951944E-08  -1.15210799453675E-08  -1.03778550133347E-18
      3.78577860609430E-09
      0.00000000000000E+00  -1.82495492831356E-11   0.00000000000000E+00   4.41216665386849E-13   1.56071252212156E-23
      1.82490578837250E-08   1.82494991003905E-08  -2.32146326020447E-19  -5.04979624016524E-01  -5.04979624009871E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65273117639754E-09   0.00000000000000E+00  -6.65273117639754E-09
      1.17727200635121E-18  -6.79927779870429E-03  -3.14550180207793E-03   0.00000000000000E+00   1.74621815506883E-12
      1.65432020873153E-23  -1.15985141421480E-08  -1.15967679239929E-08  -9.45125680330767E-19
      3.79077860609430E-09
      0.00000000000000E+00  -1.83487415993197E-11   0.00000000000000E+00   9.93961555612812E-13   1.35499471542987E-23
      1.83477879641536E-08   1.83487819257092E-08  -2.24406998415509E-19  -5.08388844421310E-01  -5.08388844414586E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.72386355065128E-09   0.00000000000000E+00  -6.72386355065128E-09
      1.14365268859796E-18  -6.77650490763884E-03  -3.11385849893671E-03   0.00000000000000E+00   1.59996909943776E-12
      1.32882580489065E-23  -1.16265183441578E-08  -1.16249183750583E-08  -9.19245690182450E-19
      3.79752860609430E-09
      0.00000000000000E+00  -1.85001017262377E-11   0.00000000000000E+00   1.12454958083249E-12   1.13221267987930E-23
      1.84989668488508E-08   1.85000913984316E-08  -2.14001253152028E-19  -5.12992994998813E-01  -5.12992994992044E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76883246644349E-09   0.00000000000000E+00  -6.76883246644349E-09
      1.09796306944946E-18  -6.77784797599741E-03  -3.08169628228896E-03   0.00000000000000E+00   1.06858912409782E-12
      9.80754334730649E-24  -1.17323275211122E-08  -1.17312589319881E-08  -8.83961816297434E-19
      3.80664110609430E-09
      0.00000000000000E+00  -1.86384199004722E-11   0.00000000000000E+00   7.69279732916483E-13   9.09949550420152E-24
      1.86375867796435E-08   1.86383560593764E-08  -2.00216925318666E-19  -5.19126408452950E-01  -5.19126408446202E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74820345444717E-09   0.00000000000000E+00  -6.74820345444717E-09
      1.03647006547081E-18  -6.78348462542116E-03  -3.03726978031765E-03   0.00000000000000E+00   9.20516758273192E-13
      6.38898863284604E-24  -1.18910731216874E-08  -1.18901526049291E-08  -8.36253140152147E-19
      3.81894298109430E-09
      0.00000000000000E+00  -1.85350945711138E-11   0.00000000000000E+00  -3.92926580503389E-13   7.04104001004711E-24
      1.85354508812972E-08   1.85350579547167E-08  -1.82723778426046E-19  -5.26962454991088E-01  -5.26962454984601E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48680294724712E-09   0.00000000000000E+00  -6.48680294724712E-09
      9.56670226464149E-19  -6.74883732854602E-03  -2.95280850361501E-03   0.00000000000000E+00   1.01080122009419E-12
      3.36549509628205E-24  -1.20492658086897E-08  -1.20482550074696E-08  -7.73946448038102E-19
      3.83555051234430E-09
      0.00000000000000E+00  -1.76070953463689E-11   0.00000000000000E+00  -2.73771633376499E-12   5.21935895162706E-24
      1.76097918896905E-08   1.76070541733568E-08  -1.63384266682822E-19  -5.35674767826397E-01  -5.35674767820931E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.46567483121535E-09   0.00000000000000E+00  -5.46567483121535E-09
      8.65898860902400E-19  -6.60128252841317E-03  -2.77591216428791E-03   0.00000000000000E+00   1.04861037338442E-12
      9.87077601270190E-25  -1.21424279525148E-08  -1.21413793421415E-08  -7.02514594219580E-19
      3.85555051234430E-09
      0.00000000000000E+00  -1.46807383294627E-11   0.00000000000000E+00  -7.20352145798819E-12   3.56753364159175E-24
      1.46879845257107E-08   1.46807810042527E-08  -1.53052791680841E-19  -5.40238103914192E-01  -5.40238103911671E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.52006394825781E-09   0.00000000000000E+00  -2.52006394825781E-09
      8.15497581937245E-19  -6.26405977233722E-03  -2.43259563517768E-03   0.00000000000000E+00   5.48447356497660E-13
     -7.02954784069878E-25  -1.21612655033514E-08  -1.21607170559949E-08  -6.62444790256404E-19
      3.87555051234430E-09
      0.00000000000000E+00  -9.00849920426305E-12   0.00000000000000E+00  -1.39798332470201E-11   1.78668348147747E-24
      9.02245376452546E-09   9.00847393127844E-09  -1.66756006866396E-19  -5.33674671169956E-01  -5.33674671173100E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14417750324342E-09   0.00000000000000E+00   3.14417750324342E-09
      8.78381132002113E-19  -5.71385527432299E-03  -1.88493132526202E-03   0.00000000000000E+00  -6.96182882463404E-13
     -2.14029492222136E-24  -1.21519552516394E-08  -1.21526514345219E-08  -7.11625125135718E-19
      3.89555051234430E-09
      0.00000000000000E+00  -1.13060871502465E-12   0.00000000000000E+00  -1.94292541755242E-11  -7.97877409765504E-25
      1.15002517617474E-09   1.13059592199922E-09  -2.15989871032153E-19  -5.11217656350448E-01  -5.11217656361454E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10056273331186E-08   0.00000000000000E+00   1.10056273331186E-08
      1.09849367866449E-18  -4.98378390880441E-03  -1.16003563905531E-03   0.00000000000000E+00  -2.71254831345653E-12
     -4.55786307046923E-24  -1.21335107068043E-08  -1.21362232551178E-08  -8.82503807632334E-19
      3.91555051234430E-09
      0.00000000000000E+00   6.58839037884472E-12   0.00000000000000E+00  -1.90705470514629E-11  -5.79332002350193E-24
     -6.56928313076146E-09  -6.58835367781293E-09  -3.08796685528398E-19  -4.71009820553684E-01  -4.71009820572377E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86923829974110E-08   0.00000000000000E+00   1.86923829974110E-08
      1.47234133861271E-18  -4.22239500347045E-03  -4.08793341418307E-04   0.00000000000000E+00  -5.64284864047169E-12
     -1.13960097318108E-23  -1.20983864709576E-08  -1.21040293195981E-08  -1.16354465308431E-18
      3.93555051234430E-09
      0.00000000000000E+00   1.14046365532702E-11   0.00000000000000E+00  -1.20001349741970E-11  -1.74782747447363E-23
     -1.13926684105625E-08  -1.14046685455367E-08  -4.48934476242519E-19  -4.13890826333710E-01  -4.13890826357167E-01
      0.00000000000000E+00   0.00000000000000E+00   2.34573488809814E-08   0.00000000000000E+00   2.34573488809814E-08
      1.94148831623233E-18  -3.60178497739671E-03   1.95637569672759E-04   0.00000000000000E+00  -1.03114572902225E-11
     -3.17464039806868E-23  -1.20423688781545E-08  -1.20526803354447E-08  -1.49255383998982E-18
      3.95555051234430E-09
      0.00000000000000E+00   1.17017542781366E-11   0.00000000000000E+00  -9.60684443368901E-13  -3.40774863173476E-23
     -1.17008076374997E-08  -1.17017683219431E-08  -6.28044282260844E-19  -3.42641462179685E-01  -3.42641462203328E-01
      0.00000000000000E+00   0.00000000000000E+00   2.36428264512821E-08   0.00000000000000E+00   2.36428264512821E-08
      2.41434484525798E-18  -3.56344493686972E-03   1.98805088999648E-04   0.00000000000000E+00  -1.86680734995810E-11
     -6.31752425646942E-23  -1.19223900558393E-08  -1.19410581293389E-08  -1.78630056299713E-18
      3.97555051234430E-09
      0.00000000000000E+00   9.14406203638136E-12   0.00000000000000E+00   5.96675642394235E-12  -4.11060102302523E-23
     -9.14999391694293E-09  -9.14402716051903E-09  -8.08504850278126E-19  -2.65819891625348E-01  -2.65819891645726E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03782529282301E-08   0.00000000000000E+00   2.03782529282301E-08
      2.82190990382258E-18  -8.23048186958069E-03  -4.69093786634757E-03   0.00000000000000E+00  -3.15305087277978E-11
     -7.71190171786052E-23  -1.12026952589832E-08  -1.12342257677111E-08  -2.01340505354445E-18
      3.99555051234430E-09
      0.00000000000000E+00   7.26142861310148E-12   0.00000000000000E+00   4.22385686971600E-12  -4.32042015300084E-23
     -7.26564436596247E-09  -7.26142050909279E-09  -9.57154747340403E-19  -1.95117125810600E-01  -1.95117125827482E-01
      0.00000000000000E+00   0.00000000000000E+00   1.68815321816466E-08   0.00000000000000E+00   1.68815321816466E-08
      3.15954054745551E-18  -2.34324428578063E-02  -2.04014553967336E-02   0.00000000000000E+00  -4.93969905060108E-11
     -8.46526560427887E-23  -9.57071468204774E-09  -9.62011167255383E-09  -2.20238580011511E-18
      4.01555051234430E-09
      0.00000000000000E+00   5.94823256050826E-12   0.00000000000000E+00   2.74554383989779E-12  -4.51000104561477E-23
     -5.95098201902717E-09  -5.94823647518732E-09  -1.07610816363331E-18  -1.33092361247094E-01  -1.33092361261254E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41595868202506E-08   0.00000000000000E+00   1.41595868202506E-08
      3.44273228386052E-18  -4.66019219699053E-02  -4.40147878299932E-02   0.00000000000000E+00  -7.53312735894329E-11
     -9.34860537693358E-23  -8.13601907147383E-09  -8.21135034506335E-09  -2.36662412022721E-18
      4.01558957484430E-09
      0.00000000000000E+00   5.94143604995491E-12   0.00000000000000E+00   5.08204684127513E-12  -4.51034660983713E-23
     -5.94655212571141E-09  -5.94147007887018E-09  -1.07634033102316E-18  -1.32969767521053E-01  -1.32969767535198E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41451384433189E-08   0.00000000000000E+00   1.41451384433189E-08
      3.44328482833097E-18  -4.66471979873579E-02  -4.40624831371524E-02   0.00000000000000E+00  -7.45822878275711E-11
     -9.35026458863063E-23  -8.12908607656934E-09  -8.20366836439700E-09  -2.36694449730780E-18
      4.01564230921930E-09
      0.00000000000000E+00   5.92977176832955E-12   0.00000000000000E+00   7.83140528245239E-12  -4.51077676742140E-23
     -5.93761361891546E-09  -5.92978221363305E-09  -1.07665324593311E-18  -1.32802899407495E-01  -1.32802899421613E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41186119947770E-08   0.00000000000000E+00   1.41186119947770E-08
      3.44402936451038E-18  -4.67086265800685E-02  -4.41285848832055E-02   0.00000000000000E+00  -7.46779771320315E-11
     -9.35247950198058E-23  -8.11415180403430E-09  -8.18882978116642E-09  -2.36737611857727E-18
      4.01571350062555E-09
      0.00000000000000E+00   5.91342340510661E-12   0.00000000000000E+00   9.56714455468748E-12  -4.51132975436917E-23
     -5.92301603999746E-09  -5.91344889544282E-09  -1.07707461016026E-18  -1.32576616655671E-01  -1.32576616669751E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40795869283952E-08   0.00000000000000E+00   1.40795869283952E-08
      3.44503171010323E-18  -4.67922110852617E-02  -4.42193161878369E-02   0.00000000000000E+00  -7.64956632141930E-11
     -9.35550610843856E-23  -8.08964236972313E-09  -8.16613803293742E-09  -2.36795709994296E-18
      4.01580960902399E-09
      0.00000000000000E+00   5.89294202870933E-12   0.00000000000000E+00   9.82406118611129E-12  -4.51207656744231E-23
     -5.90277696157741E-09  -5.89295290039135E-09  -1.07764153272069E-18  -1.32270769650142E-01  -1.32270769664171E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40288452321638E-08   0.00000000000000E+00   1.40288452321638E-08
      3.44637999995042E-18  -4.69060933276777E-02  -4.43427251420575E-02   0.00000000000000E+00  -7.96481504773798E-11
     -9.35969541485345E-23  -8.05624418128777E-09  -8.13589233176524E-09  -2.36873846722972E-18
      4.01593935536188E-09
      0.00000000000000E+00   5.86878686282375E-12   0.00000000000000E+00   8.93842013011060E-12  -4.51312135018380E-23
     -5.87775169503782E-09  -5.86881327490776E-09  -1.07840371904642E-18  -1.31858398829875E-01  -1.31858398843843E-01
      0.00000000000000E+00   0.00000000000000E+00   1.39680358679581E-08   0.00000000000000E+00   1.39680358679581E-08
      3.44819230145181E-18  -4.70613113898084E-02  -4.45094943118378E-02   0.00000000000000E+00  -8.32188017974771E-11
     -9.36548745816800E-23  -8.01600379125352E-09  -8.09922259305109E-09  -2.36978858240539E-18
      4.01611451291803E-09
      0.00000000000000E+00   5.84132528639870E-12   0.00000000000000E+00   7.55381410792496E-12  -4.51459741629655E-23
     -5.84886090541556E-09  -5.84130709130768E-09  -1.07942770050478E-18  -1.31303314749042E-01  -1.31303314762941E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38990065141455E-08   0.00000000000000E+00   1.38990065141455E-08
      3.45062681746577E-18  -4.72728663939776E-02  -4.47341301483961E-02   0.00000000000000E+00  -8.65705539890254E-11
     -9.37342955734579E-23  -7.97112886885355E-09  -8.05769942284266E-09  -2.37119911696100E-18
      4.01635097561884E-09
      0.00000000000000E+00   5.81000623101093E-12   0.00000000000000E+00   6.21107020976989E-12  -4.51666490857954E-23
     -5.81628465653997E-09  -5.81007358633025E-09  -1.08080234253243E-18  -1.30556972684865E-01  -1.30556972698688E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38229126254315E-08   0.00000000000000E+00   1.38229126254315E-08
      3.45389542071819E-18  -4.75611959948153E-02  -4.50365925036410E-02   0.00000000000000E+00  -8.94942993270350E-11
     -9.38423140357184E-23  -7.92334473976936E-09  -8.01283903909649E-09  -2.37309307818576E-18
      4.01667020026493E-09
      0.00000000000000E+00   5.77372755981396E-12   0.00000000000000E+00   5.18982335699809E-12  -4.51951464129229E-23
     -5.77891560460282E-09  -5.77372578124586E-09  -1.08264584363103E-18  -1.29554511445325E-01  -1.29554511459064E-01
      0.00000000000000E+00   0.00000000000000E+00   1.37392198790900E-08   0.00000000000000E+00   1.37392198790900E-08
      3.45828131832161E-18  -4.79542256729573E-02  -4.54445381059599E-02   0.00000000000000E+00  -9.19667656833626E-11
     -9.39884562636700E-23  -7.87352733216202E-09  -7.96549409784548E-09  -2.37563547469058E-18
      4.01710115353715E-09
      0.00000000000000E+00   5.72973393069156E-12   0.00000000000000E+00   4.53190702012908E-12  -4.52338371151967E-23
     -5.73422084518034E-09  -5.72968893816026E-09  -1.08511440240734E-18  -1.28209763954255E-01  -1.28209763967900E-01
      0.00000000000000E+00   0.00000000000000E+00   1.36448459490131E-08   0.00000000000000E+00   1.36448459490131E-08
      3.46416160933225E-18  -4.84902934530923E-02  -4.59964648124435E-02   0.00000000000000E+00  -9.40065791044369E-11
     -9.41856398318896E-23  -7.82115043175305E-09  -7.91515701085758E-09  -2.37904720692491E-18
      4.01768294045464E-09
      0.00000000000000E+00   5.67435155415542E-12   0.00000000000000E+00   4.14074566298583E-12  -4.52858158418962E-23
     -5.67850696568414E-09  -5.67436622002120E-09  -1.08841268843745E-18  -1.26409029386640E-01  -1.26409029400174E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35338062443561E-08   0.00000000000000E+00   1.35338062443561E-08
      3.47203540074912E-18  -4.92223835623890E-02  -4.67461091005692E-02   0.00000000000000E+00  -9.56955873857142E-11
     -9.44513387352639E-23  -7.76374443694703E-09  -7.85944002433284E-09  -2.38362271231168E-18
      4.01846835279326E-09
      0.00000000000000E+00   5.60344741703121E-12   0.00000000000000E+00   3.88829552454604E-12  -4.53551986830117E-23
     -5.60733147233265E-09  -5.60344317680815E-09  -1.09280609529064E-18  -1.24003462574583E-01  -1.24003462587980E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33975115899712E-08   0.00000000000000E+00   1.33975115899712E-08
      3.48255797165867E-18  -5.02242690240189E-02  -4.77685907859482E-02   0.00000000000000E+00  -9.72101847855807E-11
     -9.48090864602590E-23  -7.69685822837892E-09  -7.79406841316459E-09  -2.38975187636802E-18
      4.01899850612182E-09
      0.00000000000000E+00   5.55559630894609E-12   0.00000000000000E+00   3.87175392967325E-12  -4.54015551456607E-23
     -5.55945886461274E-09  -5.55558711068311E-09  -1.09574475954811E-18  -1.22390352037179E-01  -1.22390352050486E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33063119180538E-08   0.00000000000000E+00   1.33063119180538E-08
      3.48961235721297E-18  -5.09066623892383E-02  -4.84646400039135E-02   0.00000000000000E+00  -9.82495082353401E-11
     -9.50502642681300E-23  -7.65247529913430E-09  -7.75072480736974E-09  -2.39386759766486E-18
      4.01971421311539E-09
      0.00000000000000E+00   5.49341742185659E-12   0.00000000000000E+00   3.71485167708328E-12  -4.54635409611387E-23
     -5.49711716870944E-09  -5.49340231703240E-09  -1.09966479199107E-18  -1.20232833789926E-01  -1.20232833803116E-01
      0.00000000000000E+00   0.00000000000000E+00   1.31892305773880E-08   0.00000000000000E+00   1.31892305773880E-08
      3.49905198177696E-18  -5.18382839185612E-02  -4.94135575034655E-02   0.00000000000000E+00  -9.93874412418799E-11
     -9.53752933618992E-23  -7.59644081911368E-09  -7.69582826035565E-09  -2.39938718978588E-18
      4.01995576422572E-09
      0.00000000000000E+00   5.47174206387561E-12   0.00000000000000E+00   3.81580679633161E-12  -4.54843154783634E-23
     -5.47557670330481E-09  -5.47176089650853E-09  -1.10098229657080E-18  -1.19506565099117E-01  -1.19506565112265E-01
      0.00000000000000E+00   0.00000000000000E+00   1.31481176982095E-08   0.00000000000000E+00   1.31481176982095E-08
      3.50222792420569E-18  -5.21539464806218E-02  -4.97353546487467E-02   0.00000000000000E+00  -9.98891891082054E-11
     -9.54849232303747E-23  -7.57646761259089E-09  -7.67635680169919E-09  -2.40124562763489E-18
      4.02028185822466E-09
      0.00000000000000E+00   5.44317835060407E-12   0.00000000000000E+00   3.75159526345304E-12  -4.55122540197357E-23
     -5.44692016698617E-09  -5.44316857172276E-09  -1.10275108928838E-18  -1.18530211968383E-01  -1.18530211981477E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30939856366594E-08   0.00000000000000E+00   1.30939856366594E-08
      3.50649779434405E-18  -5.25822955208760E-02  -5.01717502683960E-02   0.00000000000000E+00  -1.00516316089171E-10
     -9.56329318317125E-23  -7.55030074884472E-09  -7.65081706493398E-09  -2.40374670505567E-18
      4.02072208512324E-09
      0.00000000000000E+00   5.40561385308619E-12   0.00000000000000E+00   3.63929386234762E-12  -4.55497879936301E-23
     -5.40924019426907E-09  -5.40560090040677E-09  -1.10512150596993E-18  -1.17219679754678E-01  -1.17219679767702E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30233446613288E-08   0.00000000000000E+00   1.30233446613288E-08
      3.51223102097336E-18  -5.31643590195069E-02  -5.07642340040694E-02   0.00000000000000E+00  -1.01215663847748E-10
     -9.58325779804190E-23  -7.51652809707584E-09  -7.61774376092369E-09  -2.40710951500344E-18
      4.02131639143631E-09
      0.00000000000000E+00   5.35620138446855E-12   0.00000000000000E+00   3.52976489570705E-12  -4.56000624195237E-23
     -5.35970164266604E-09  -5.35617187777038E-09  -1.10829059598643E-18  -1.15463941916138E-01  -1.15463941929069E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29309067336823E-08   0.00000000000000E+00   1.29309067336823E-08
      3.51991594047896E-18  -5.39567266726586E-02  -5.15701523112002E-02   0.00000000000000E+00  -1.02044220478187E-10
     -9.61016892017956E-23  -7.47269063543222E-09  -7.57473485591051E-09  -2.41162534449253E-18
      4.02211870495896E-09
      0.00000000000000E+00   5.29117531052562E-12   0.00000000000000E+00   3.42409075760610E-12  -4.56671629056916E-23
     -5.29456169337218E-09  -5.29113760261462E-09  -1.11251395221080E-18  -1.13117676092008E-01  -1.13117676104818E-01
      0.00000000000000E+00   0.00000000000000E+00   1.28096381199933E-08   0.00000000000000E+00   1.28096381199933E-08
      3.53019328636289E-18  -5.50378976318234E-02  -5.26690408543516E-02   0.00000000000000E+00  -1.03086992619787E-10
     -9.64642395431630E-23  -7.41541352475776E-09  -7.51850051737764E-09  -2.41767933415209E-18
      4.02266026658675E-09
      0.00000000000000E+00   5.24663061297997E-12   0.00000000000000E+00   3.46518058497618E-12  -4.57120016677035E-23
     -5.25013471139323E-09  -5.24666953080830E-09  -1.11533947558738E-18  -1.11544168508695E-01  -1.11544168521421E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27260542991046E-08   0.00000000000000E+00   1.27260542991046E-08
      3.53708522904444E-18  -5.57730419508431E-02  -5.34165090388979E-02   0.00000000000000E+00  -1.03976248297180E-10
     -9.67087616105877E-23  -7.37540851999959E-09  -7.47938476829687E-09  -2.42174575345707E-18
      4.02339137478426E-09
      0.00000000000000E+00   5.18830920485319E-12   0.00000000000000E+00   3.36655507043121E-12  -4.57719611994599E-23
     -5.19163177255931E-09  -5.18826521748892E-09  -1.11910920099782E-18  -1.09439516528298E-01  -1.09439516540915E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26167918882507E-08   0.00000000000000E+00   1.26167918882507E-08
      3.54630946902028E-18  -5.67747804778427E-02  -5.44342712106572E-02   0.00000000000000E+00  -1.05011160980289E-10
     -9.70384639029844E-23  -7.32351550978244E-09  -7.42852667076283E-09  -2.42720026802246E-18
      4.02388487281759E-09
      0.00000000000000E+00   5.14835674416791E-12   0.00000000000000E+00   3.40059333819331E-12  -4.58120754016736E-23
     -5.15179719513766E-09  -5.14839660179951E-09  -1.12163322347683E-18  -1.08027296346524E-01  -1.08027296359066E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25417927431711E-08   0.00000000000000E+00   1.25417927431711E-08
      3.55249881907338E-18  -5.74552487171480E-02  -5.51258077183906E-02   0.00000000000000E+00  -1.05835052277272E-10
     -9.72608765470215E-23  -7.28756108909115E-09  -7.39339614136852E-09  -2.43086559559655E-18
      4.02455109516257E-09
      0.00000000000000E+00   5.09582155448521E-12   0.00000000000000E+00   3.31547901867676E-12  -4.58657618795563E-23
     -5.09918034030024E-09  -5.09586486128161E-09  -1.12500413087750E-18  -1.06136943801277E-01  -1.06136943813720E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24435468753357E-08   0.00000000000000E+00   1.24435468753357E-08
      3.56078898805260E-18  -5.83813643077421E-02  -5.60663262610567E-02   0.00000000000000E+00  -1.06782126431709E-10
     -9.75608356635507E-23  -7.24089988762279E-09  -7.34768201405459E-09  -2.43578485717510E-18
      4.02545049532830E-09
      0.00000000000000E+00   5.02647877789352E-12   0.00000000000000E+00   3.22905059183403E-12  -4.59373324086679E-23
     -5.02975123611544E-09  -5.02652218552365E-09  -1.12948988824921E-18  -1.03614030332697E-01  -1.03614030345012E-01
      0.00000000000000E+00   0.00000000000000E+00   1.23144862074990E-08   0.00000000000000E+00   1.23144862074990E-08
      3.57186463898851E-18  -5.96446142124348E-02  -5.73483913474464E-02   0.00000000000000E+00  -1.07920630748628E-10
     -9.79650297644700E-23  -7.18004339122699E-09  -7.28796402197572E-09  -2.44237475073929E-18
      4.02666468555204E-09
      0.00000000000000E+00   4.93481773016041E-12   0.00000000000000E+00   3.15377292760339E-12  -4.60322312344899E-23
     -4.93792808258557E-09  -4.93477430965801E-09  -1.13542993787150E-18  -1.00260265388370E-01  -1.00260265400515E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21441934269064E-08   0.00000000000000E+00   1.21441934269064E-08
      3.58660999992262E-18  -6.13726915432914E-02  -5.91012156458225E-02   0.00000000000000E+00  -1.09375536014023E-10
     -9.85093337949003E-23  -7.10004358123330E-09  -7.20941911724743E-09  -2.45118006205111E-18
      4.02830384235408E-09
      0.00000000000000E+00   4.81312345336044E-12   0.00000000000000E+00   3.09075300243755E-12  -4.61572101594181E-23
     -4.81617032431524E-09  -4.81307957131285E-09  -1.14324256681204E-18  -9.58267733395489E-02  -9.58267733514677E-02
      0.00000000000000E+00   0.00000000000000E+00   1.19188107594661E-08   0.00000000000000E+00   1.19188107594661E-08
      3.60614679965127E-18  -6.37452049685720E-02  -6.15063978323437E-02   0.00000000000000E+00  -1.11269570750618E-10
     -9.92417935911804E-23  -6.99446161740240E-09  -7.10573118815312E-09  -2.46290423283922E-18
      4.03051670403684E-09
      0.00000000000000E+00   4.65046642376591E-12   0.00000000000000E+00   3.05620515128171E-12  -4.63201431602548E-23
     -4.65358047983615E-09  -4.65052427468491E-09  -1.15341916462855E-18  -9.00133011705239E-02  -9.00133011821427E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16188056827531E-08   0.00000000000000E+00   1.16188056827531E-08
      3.63185760954605E-18  -6.70172813456734E-02  -6.48217803167105E-02   0.00000000000000E+00  -1.13716282709275E-10
     -1.00226431801292E-22  -6.85456512535891E-09  -6.96828140806829E-09  -2.47843844491751E-18
      4.03350406730856E-09
      0.00000000000000E+00   4.42967167551902E-12   0.00000000000000E+00   3.08845880846357E-12  -4.65291957122195E-23
     -4.43269552175289E-09  -4.42960706294448E-09  -1.16648198825324E-18  -8.24865908207863E-02  -8.24865908320001E-02
      0.00000000000000E+00   0.00000000000000E+00   1.12137992306575E-08   0.00000000000000E+00   1.12137992306575E-08
      3.66535730150421E-18  -7.15565728260276E-02  -6.94190726741434E-02   0.00000000000000E+00  -1.16779888425390E-10
     -1.01547605301696E-22  -6.66741227928746E-09  -6.78419216771295E-09  -2.49887531325098E-18
      4.03753700772539E-09
      0.00000000000000E+00   4.11951199796920E-12   0.00000000000000E+00   3.25068830400775E-12  -4.67899743654994E-23
     -4.12272484624819E-09  -4.11947415794423E-09  -1.18284512285574E-18  -7.29539030747809E-02  -7.29539030854324E-02
      0.00000000000000E+00   0.00000000000000E+00   1.06515868335041E-08   0.00000000000000E+00   1.06515868335041E-08
      3.70831451654841E-18  -7.79054913889703E-02  -7.58474140232727E-02   0.00000000000000E+00  -1.20352686452196E-10
     -1.03313183090968E-22  -6.41175998910759E-09  -6.53211267555989E-09  -2.52546939369267E-18
      4.04298147728811E-09
      0.00000000000000E+00   3.66635006458726E-12   0.00000000000000E+00   3.59518358571315E-12  -4.70985067226885E-23
     -3.66996711122798E-09  -3.66637192764231E-09  -1.20244363282291E-18  -6.13763569218289E-02  -6.13763569316710E-02
      0.00000000000000E+00   0.00000000000000E+00   9.84209201366334E-09   0.00000000000000E+00   9.84209201366334E-09
      3.76189948695027E-18  -8.68920605197211E-02  -8.49462712988758E-02   0.00000000000000E+00  -1.23889013556881E-10
     -1.05651049429515E-22  -6.05183107246401E-09  -6.17572008602100E-09  -2.55945585412736E-18
      4.05033151119778E-09
      0.00000000000000E+00   3.00093494351873E-12   0.00000000000000E+00   4.02603013768736E-12  -4.74278345385025E-23
     -3.00492746800603E-09  -3.00090143786839E-09  -1.22398633506306E-18  -4.84249458108042E-02  -4.84249458194707E-02
      0.00000000000000E+00   0.00000000000000E+00   8.66649154798398E-09   0.00000000000000E+00   8.66649154798398E-09
      3.82559849370581E-18  -9.98051270430979E-02  -9.80200646315773E-02   0.00000000000000E+00  -1.26138994451872E-10
     -1.08686453949534E-22  -5.53945111566374E-09  -5.66559011011572E-09  -2.60161215864275E-18
      4.06025405697583E-09
      0.00000000000000E+00   2.12932838741930E-12   0.00000000000000E+00   4.00971416231784E-12  -4.77233336894643E-23
     -2.13333787478800E-09  -2.12932816062573E-09  -1.24440529502730E-18  -3.58622422992060E-02  -3.58622423063251E-02
      0.00000000000000E+00   0.00000000000000E+00   7.11903154742181E-09   0.00000000000000E+00   7.11903154742181E-09
      3.89623741013051E-18  -1.18484691756847E-01  -1.16912581189527E-01   0.00000000000000E+00  -1.25965928826381E-10
     -1.12513552468219E-22  -4.86373745796966E-09  -4.98970338679615E-09  -2.65183211510322E-18
      4.07364949377621E-09
      0.00000000000000E+00   1.25790552079429E-12   0.00000000000000E+00   3.02196441567155E-12  -4.79351349692401E-23
     -1.26092090224978E-09  -1.25789893783415E-09  -1.26029960527523E-18  -2.57381370307469E-02  -2.57381370362542E-02
      0.00000000000000E+00   0.00000000000000E+00   5.50727350616858E-09   0.00000000000000E+00   5.50727350616858E-09
      3.97000974432476E-18  -1.44901435468179E-01  -1.43562580260715E-01   0.00000000000000E+00  -1.24579716004677E-10
     -1.17232948673653E-22  -4.12479485232956E-09  -4.24937456833435E-09  -2.70971013904953E-18
      4.09173333345671E-09
      0.00000000000000E+00   6.43464228875932E-13   0.00000000000000E+00   1.59178204916778E-12  -4.80589788512636E-23
     -6.45085749959533E-10  -6.43493967910413E-10  -1.27067243190605E-18  -1.87259580016606E-02  -1.87259580058744E-02
      0.00000000000000E+00   0.00000000000000E+00   4.21382276756166E-09   0.00000000000000E+00   4.21382276756166E-09
      4.04621183969540E-18  -1.80183703146312E-01  -1.79058794397137E-01   0.00000000000000E+00  -1.24378605794030E-10
     -1.23028437880079E-22  -3.44595019385714E-09  -3.57032879965129E-09  -2.77553940778935E-18
      4.11173333345671E-09
      0.00000000000000E+00   3.45336211900301E-13   0.00000000000000E+00   7.01626221109381E-13  -4.81145973885927E-23
     -3.45996854303504E-10  -3.45295228082443E-10  -1.27621692452768E-18  -1.46554507470620E-02  -1.46554507504010E-02
      0.00000000000000E+00   0.00000000000000E+00   3.33901641275180E-09   0.00000000000000E+00   3.33901641275180E-09
      4.11299216795043E-18  -2.16138099829275E-01  -2.15194861154910E-01   0.00000000000000E+00  -1.23796356328899E-10
     -1.28822697569253E-22  -2.86992482834030E-09  -2.99372118466933E-09  -2.83677524342276E-18
      4.13173333345671E-09
      0.00000000000000E+00   2.22172419305007E-13   0.00000000000000E+00   2.90379142311048E-13  -4.81385624053785E-23
     -2.22420321396631E-10  -2.22129942254368E-10  -1.27933022294614E-18  -1.22172674891457E-02  -1.22172674918212E-02
      0.00000000000000E+00   0.00000000000000E+00   2.67545900706351E-09   0.00000000000000E+00   2.67545900706351E-09
      4.16650134809170E-18  -2.46937997100532E-01  -2.46165018793487E-01   0.00000000000000E+00  -1.16582087158967E-10
     -1.33838164937862E-22  -2.33674697765003E-09  -2.45332906480913E-09  -2.88717112514557E-18
      4.15173333345671E-09
      0.00000000000000E+00   1.69545384885094E-13   0.00000000000000E+00   1.24589567097694E-13  -4.81493203004270E-23
     -1.69684103815873E-10  -1.69559514248823E-10  -1.28141803116612E-18  -1.05807413823623E-02  -1.05807413844611E-02
      0.00000000000000E+00   0.00000000000000E+00   2.09881690865929E-09   0.00000000000000E+00   2.09881690865929E-09
      4.20847768626489E-18  -2.71470718525509E-01  -2.70862860542572E-01   0.00000000000000E+00  -1.00671567979415E-10
     -1.37893710422682E-22  -1.82858582643095E-09  -1.92925739441050E-09  -2.92705965509877E-18
      4.17173333345671E-09
      0.00000000000000E+00   1.43737013729779E-13   0.00000000000000E+00   6.25594121310092E-14  -4.81533994217597E-23
     -1.43759320061190E-10  -1.43696760649107E-10  -1.28300876725805E-18  -9.41501635091778E-03  -9.41501635251839E-03
      0.00000000000000E+00   0.00000000000000E+00   1.60060782038299E-09   0.00000000000000E+00   1.60060782038299E-09
      4.24048984267255E-18  -2.89787617673999E-01  -2.89328584585867E-01   0.00000000000000E+00  -7.95289348860244E-11
     -1.40949170424564E-22  -1.37738212484773E-09  -1.45691105973390E-09  -2.95748107541450E-18
      4.19173333345671E-09
      0.00000000000000E+00   1.29684768937028E-13   0.00000000000000E+00   3.52244096114947E-14  -4.81539296011940E-23
     -1.29722941803582E-10  -1.29687717394018E-10  -1.28433469907276E-18  -8.55550729398372E-03  -8.55550729516835E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18462431609963E-09   0.00000000000000E+00   1.18462431609963E-09
      4.26418232899454E-18  -3.02533778815219E-01  -3.02201399430286E-01   0.00000000000000E+00  -5.69385944924853E-11
     -1.43070662737013E-22  -9.97998004212947E-10  -1.05493659870558E-09  -2.97984762992178E-18
      4.21173333345671E-09
      0.00000000000000E+00   1.21877966274388E-13   0.00000000000000E+00   2.09195223201613E-14  -4.81526582199442E-23
     -1.21858884377338E-10  -1.21837964855066E-10  -1.28551507693910E-18  -7.90523867486487E-03  -7.90523867570745E-03
      0.00000000000000E+00   0.00000000000000E+00   8.42579496207254E-10   0.00000000000000E+00   8.42579496207254E-10
      4.28103391891869E-18  -3.10499562219300E-01  -3.10272481469329E-01   0.00000000000000E+00  -3.53140621006076E-11
     -1.44368489227578E-22  -6.85427469251485E-10  -7.20741531352237E-10  -2.99551884197958E-18
      4.23173333345671E-09
      0.00000000000000E+00   1.10948442546692E-13   0.00000000000000E+00   2.98535086218102E-14  -4.81478832733619E-23
     -1.10973790681271E-10  -1.10943937172697E-10  -1.28648681223695E-18  -7.45278506636569E-03  -7.45278506698741E-03
      0.00000000000000E+00   0.00000000000000E+00   6.21724167645887E-10   0.00000000000000E+00   6.21724167645887E-10
      4.29346840227161E-18  -3.15524234555497E-01  -3.15363308890088E-01   0.00000000000000E+00  -2.10376408336518E-11
     -1.45139638549058E-22  -4.89742589639454E-10  -5.10780230473251E-10  -3.00698159003466E-18
      4.25173333345671E-09
      0.00000000000000E+00   9.57022161702429E-14   0.00000000000000E+00   4.27873940938239E-14  -4.81380044020369E-23
     -9.57606270330220E-11  -9.57178396389763E-11  -1.28716329241525E-18  -7.18113525973192E-03  -7.18113526029945E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67527839010104E-10   0.00000000000000E+00   5.67527839010104E-10
      4.30481895905181E-18  -3.20205958138833E-01  -3.20057311134914E-01   0.00000000000000E+00  -1.90403252830376E-11
     -1.45824646769986E-22  -4.52769674087883E-10  -4.71809999371067E-10  -3.01765566663655E-18
      4.26173333345671E-09
      0.00000000000000E+00   9.14773582586966E-14   0.00000000000000E+00   2.67952021091599E-14  -4.81326707573596E-23
     -9.15052164025441E-11  -9.14784212004830E-11  -1.28746144464623E-18  -7.06912792235356E-03  -7.06912792290303E-03
      0.00000000000000E+00   0.00000000000000E+00   5.49474900669557E-10   0.00000000000000E+00   5.49474900669557E-10
      4.31031370805850E-18  -3.22471775968030E-01  -3.22327481306679E-01   0.00000000000000E+00  -1.83065096199716E-11
     -1.46150629654539E-22  -4.39689969848920E-10  -4.57996479469038E-10  -3.02285226341227E-18
      4.27523333345671E-09
      0.00000000000000E+00   8.55074503402074E-14   0.00000000000000E+00   2.83527307361461E-14  -4.81243092776208E-23
     -8.55384712286773E-11  -8.55101184979893E-11  -1.28778789721503E-18  -6.94667135116886E-03  -6.94667135175621E-03
      0.00000000000000E+00   0.00000000000000E+00   5.87346824580304E-10   0.00000000000000E+00   5.87346824580304E-10
      4.31824289019034E-18  -3.26043155915516E-01  -3.25885047772951E-01   0.00000000000000E+00  -2.21799910158331E-11
     -1.46674268723160E-22  -4.79656715066454E-10  -5.01836706082433E-10  -3.03045499297531E-18
      4.29345833345671E-09
      0.00000000000000E+00   7.94456976845106E-14   0.00000000000000E+00   2.35248291612366E-14  -4.81117381271661E-23
     -7.95085359675489E-11  -7.94850111384358E-11  -1.28812789398335E-18  -6.80611410659278E-03  -6.80611410724817E-03
      0.00000000000000E+00   0.00000000000000E+00   6.55381203834893E-10   0.00000000000000E+00   6.55381203834893E-10
      4.33018721263023E-18  -3.31950265137954E-01  -3.31768821996980E-01   0.00000000000000E+00  -2.84357198168637E-11
     -1.47564772894324E-22  -5.47460472879387E-10  -5.75896192696399E-10  -3.04205931864688E-18
      4.29845833345671E-09
      0.00000000000000E+00   7.42105476636816E-14   0.00000000000000E+00   5.99126894435909E-14  -4.81076225435970E-23
     -7.42457849394573E-11  -7.41858722500618E-11  -1.28819539266087E-18  -6.77971798184207E-03  -6.77971798251916E-03
      0.00000000000000E+00   0.00000000000000E+00   6.77089779308628E-10   0.00000000000000E+00   6.77089779308628E-10
      4.33357266152677E-18  -3.33692451415904E-01  -3.33502498383735E-01   0.00000000000000E+00  -3.10130885811798E-11
     -1.47828399412944E-22  -5.71890818477021E-10  -6.02903907058349E-10  -3.04537726886590E-18
      4.30520833345671E-09
      0.00000000000000E+00   6.17196634034580E-14   0.00000000000000E+00   1.00660352185200E-13  -4.81003231357768E-23
     -6.18417548260421E-11  -6.17410944739050E-11  -1.28820402226094E-18  -6.77703285755317E-03  -6.77703285832935E-03
      0.00000000000000E+00   0.00000000000000E+00   7.76178098771423E-10   0.00000000000000E+00   7.76178098771423E-10
      4.33881186369348E-18  -3.36687435102105E-01  -3.36462339399689E-01   0.00000000000000E+00  -4.07417752203047E-11
     -1.48290331475729E-22  -6.73695229077033E-10  -7.14437004297486E-10  -3.05060784143253E-18
      4.31432083345671E-09
      0.00000000000000E+00   5.36373265291956E-14   0.00000000000000E+00   5.51877723347135E-14  -4.80898772296979E-23
     -5.37255221661765E-11  -5.36703343938898E-11  -1.28814533282070E-18  -6.78232255120703E-03  -6.78232255214015E-03
      0.00000000000000E+00   0.00000000000000E+00   9.33127038226026E-10   0.00000000000000E+00   9.33127038226026E-10
      4.34731498382931E-18  -3.41918749214580E-01  -3.41641658180921E-01   0.00000000000000E+00  -5.47440544480876E-11
     -1.49120838954913E-22  -8.24712649384043E-10  -8.79456703832280E-10  -3.05916965100862E-18
      4.32662270845671E-09
      0.00000000000000E+00   5.18004317850451E-14   0.00000000000000E+00   1.90727077891565E-14  -4.80762124409233E-23
     -5.17807186405895E-11  -5.17616459328484E-11  -1.28804920168776E-18  -6.75401689680731E-03  -6.75401689790591E-03
      0.00000000000000E+00   0.00000000000000E+00   1.09859888200426E-09   0.00000000000000E+00   1.09859888200426E-09
      4.36082980995087E-18  -3.50553158509334E-01  -3.50223328390893E-01   0.00000000000000E+00  -6.96246334093831E-11
     -1.50529539930516E-22  -9.77212602661805E-10  -1.04683723607134E-09  -3.07278060826311E-18
      4.34323023970671E-09
      0.00000000000000E+00   5.70355818058741E-14   0.00000000000000E+00  -5.63082231294690E-15  -4.80603377456057E-23
     -5.70143772331306E-11  -5.70200080554916E-11  -1.28801929465114E-18  -6.61796248248543E-03  -6.61796248368673E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20130107540566E-09   0.00000000000000E+00   1.20130107540566E-09
      4.38078045510133E-18  -3.63393507321687E-01  -3.63032974181242E-01   0.00000000000000E+00  -8.00600462134427E-11
     -1.52677062865446E-22  -1.06422102113670E-09  -1.14428106735030E-09  -3.09276116045019E-18
      4.36323023970671E-09
      0.00000000000000E+00   6.84243292196074E-14   0.00000000000000E+00  -2.07534263221622E-14  -4.80462828890644E-23
     -6.84397617145107E-11  -6.84605151408809E-11  -1.28822973353436E-18  -6.29685403676578E-03  -6.29685403798896E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22318121253939E-09   0.00000000000000E+00   1.22318121253939E-09
      4.40524407935212E-18  -3.78929102049430E-01  -3.78565279458586E-01   0.00000000000000E+00  -8.45020499561089E-11
     -1.55342907388497E-22  -1.07021864744219E-09  -1.15472069739845E-09  -3.11701434581775E-18
      4.38323023970671E-09
      0.00000000000000E+00   8.60585187634526E-14   0.00000000000000E+00  -3.93671853188414E-14  -4.80394119485860E-23
     -8.59954973835135E-11  -8.60348645688804E-11  -1.28880794075092E-18  -5.76433983378788E-03  -5.76433983499901E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21112672684077E-09   0.00000000000000E+00   1.21112672684077E-09
      4.42946661388893E-18  -3.93879107676703E-01  -3.93524620373271E-01   0.00000000000000E+00  -8.58907382298914E-11
     -1.57986005536452E-22  -1.03920112404181E-09  -1.12509186227186E-09  -3.14065867313801E-18
      4.40323023970671E-09
      0.00000000000000E+00   1.02131347774770E-13   0.00000000000000E+00  -3.89326210460470E-14  -4.80386109077857E-23
     -1.02088077552726E-10  -1.02127010173820E-10  -1.28972281927950E-18  -5.04423981383021E-03  -5.04423981501866E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18845100261728E-09   0.00000000000000E+00   1.18845100261728E-09
      4.45323563394127E-18  -4.08118108942405E-01  -4.07775836551960E-01   0.00000000000000E+00  -8.61802342289906E-11
     -1.60577106317124E-22  -1.00014375821429E-09  -1.08632399244344E-09  -3.16351281466177E-18
      4.42323023970671E-09
      0.00000000000000E+00   1.06448050423524E-13   0.00000000000000E+00  -1.11035169948602E-14  -4.80390287310058E-23
     -1.06464138662646E-10  -1.06475242179689E-10  -1.29073857396041E-18  -4.27873938414991E-03  -4.27873938530002E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15011363443534E-09   0.00000000000000E+00   1.15011363443534E-09
      4.47623790662998E-18  -4.21707866040672E-01  -4.21379043071362E-01   0.00000000000000E+00  -8.56775821972910E-11
     -1.63098255002726E-22  -9.57960810058172E-10  -1.04363839225563E-09  -3.18549933266958E-18
      4.44323023970671E-09
      0.00000000000000E+00   9.63451293306956E-14   0.00000000000000E+00   2.60297329935189E-14  -4.80354055998769E-23
     -9.63940595027128E-11  -9.63680297697673E-11  -1.29156592090746E-18  -3.64029814940363E-03  -3.64029815049761E-03
      0.00000000000000E+00   0.00000000000000E+00   1.09398411980164E-09   0.00000000000000E+00   1.09398411980164E-09
      4.49811758902602E-18  -4.34746508833815E-01  -4.34432186740956E-01   0.00000000000000E+00  -8.43497909004329E-11
     -1.65531323025248E-22  -9.13266299131332E-10  -9.97616090031930E-10  -3.20655166811856E-18
      4.46323023970671E-09
      0.00000000000000E+00   5.54742212733462E-14   0.00000000000000E+00   1.08827826456079E-13  -4.80159405611141E-23
     -5.55440781854988E-11  -5.54352503590907E-11  -1.29158978644009E-18  -3.49754694794925E-03  -3.49754694894244E-03
      0.00000000000000E+00   0.00000000000000E+00   9.93187880578952E-10   0.00000000000000E+00   9.93187880578952E-10
      4.51798134663760E-18  -4.47344451759408E-01  -4.47048991922727E-01   0.00000000000000E+00  -8.08615169493466E-11
     -1.67820965356728E-22  -8.56891113270330E-10  -9.37752630219845E-10  -3.22639156019751E-18
      4.48323023970671E-09
      0.00000000000000E+00  -2.87290337985144E-13   0.00000000000000E+00   9.09699429528785E-13  -4.78579812197214E-23
      2.86358245279136E-10   2.87267944708617E-10  -1.28479353306127E-18  -7.46706842724165E-03  -7.46706842765401E-03
      0.00000000000000E+00   0.00000000000000E+00   4.12365839351099E-10   0.00000000000000E+00   4.12365839351099E-10
      4.52622866342461E-18  -4.59971704549811E-01  -4.59751274809114E-01   0.00000000000000E+00  -5.46086935906951E-11
     -1.69337289416332E-22  -6.45025090468929E-10  -6.99633784059794E-10  -3.24143513036335E-18
      4.50323023970671E-09
      0.00000000000000E+00  -1.17451049940985E-12   0.00000000000000E+00   2.39182418150266E-12  -4.73589498436270E-23
      1.17215736781452E-09   1.17454919199597E-09  -1.26036798767725E-18  -2.18648771793185E-02  -2.18648771782867E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.03175296319742E-09   0.00000000000000E+00  -1.03175296319742E-09
      4.50559360416067E-18  -4.73320289286340E-01  -4.73275317841725E-01   0.00000000000000E+00   1.30289824540291E-11
     -1.68942472217161E-22  -1.55825211252432E-10  -1.42796228798572E-10  -3.24522561648341E-18
      4.52323023970671E-09
      0.00000000000000E+00  -1.93535230243700E-12   0.00000000000000E+00   2.17426439098098E-12  -4.66168704015711E-23
      1.93320104447643E-09   1.93537530886736E-09  -1.22105998944304E-18  -4.45189829609735E-02  -4.45189829587306E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.24285840914958E-09   0.00000000000000E+00  -2.24285840914958E-09
      4.46073643597768E-18  -4.87021430617307E-01  -4.87118342003012E-01   0.00000000000000E+00   6.70614765674861E-11
     -1.67010397004758E-22   2.40421623714946E-10   3.07483100282265E-10  -3.23967644653464E-18
      4.53323023970671E-09
      0.00000000000000E+00  -2.34681672512672E-12   0.00000000000000E+00   2.32811312104098E-12  -4.61803197055293E-23
      2.34447296772729E-09   2.34680108084828E-09  -1.19746401164436E-18  -5.78165613416879E-02  -5.78165613388181E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.86984343160395E-09   0.00000000000000E+00  -2.86984343160395E-09
      4.43203800166164E-18  -4.93890573036178E-01  -4.94055400179201E-01   0.00000000000000E+00   9.15693341997430E-11
     -1.65687903020428E-22   4.31473016556069E-10   5.23042350755646E-10  -3.23457399001728E-18
      4.54673023970671E-09
      0.00000000000000E+00  -2.76066911098384E-12   0.00000000000000E+00   1.85256253258772E-12  -4.55254284193138E-23
      2.75881186199982E-09   2.76066442453236E-09  -1.16062272591388E-18  -7.81038236868987E-02  -7.81038236834442E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.45441994805979E-09   0.00000000000000E+00  -3.45441994805979E-09
      4.38540333236283E-18  -5.03139342746661E-01  -5.03357971888674E-01   0.00000000000000E+00   1.11600234276191E-10
     -1.63496115063637E-22   5.82155289251424E-10   6.93755523527451E-10  -3.22478060644894E-18
      4.55584273970671E-09
      0.00000000000000E+00  -3.15835682309243E-12   0.00000000000000E+00   2.49025601441611E-12  -4.50322991437034E-23
      3.15588806552412E-09   3.15837832153849E-09  -1.13264169568980E-18  -9.31612312409097E-02  -9.31612312369276E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.98205121749205E-09   0.00000000000000E+00  -3.98205121749205E-09
      4.34911689064343E-18  -5.09362919282063E-01  -5.09622488265423E-01   0.00000000000000E+00   1.27222333561566E-10
     -1.61797667636878E-22   6.96450562392196E-10   8.23672895953600E-10  -3.21647519495364E-18
      4.56814461470671E-09
      0.00000000000000E+00  -3.71778311742348E-12   0.00000000000000E+00   2.58866188774635E-12  -4.42766340626513E-23
      3.71516176654247E-09   3.71775042843018E-09  -1.08979952095786E-18  -1.15635723716916E-01  -1.15635723712289E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.62655302914832E-09   0.00000000000000E+00  -4.62655302914832E-09
      4.29220161359798E-18  -5.17660514619116E-01  -5.17946920894517E-01   0.00000000000000E+00   1.44681666194183E-10
     -1.59164010058440E-22   7.64120934524139E-10   9.08802600718162E-10  -3.20240209264012E-18
      4.58475214595671E-09
      0.00000000000000E+00  -4.58589957350902E-12   0.00000000000000E+00   2.90239908555270E-12  -4.27660870514328E-23
      4.58292249660022E-09   4.58582489568573E-09  -1.02561632860788E-18  -1.48070917253204E-01  -1.48070917247951E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.25318275781781E-09   0.00000000000000E+00  -5.25318275781781E-09
      4.20495921678556E-18  -5.28078441090566E-01  -5.28288813781868E-01   0.00000000000000E+00   1.55853726979115E-10
     -1.55260907581173E-22   5.11504135153097E-10   6.67357862132057E-10  -3.17934288817768E-18
      4.60475214595671E-09
      0.00000000000000E+00  -6.34059327785882E-12   0.00000000000000E+00   4.59443235908620E-12  -3.71654706687227E-23
      6.33597078974852E-09   6.34056522210757E-09  -9.45591068984990E-19  -1.86620903773071E-01  -1.86620903767432E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63863521415201E-09   0.00000000000000E+00  -5.63863521415201E-09
      4.09218651250252E-18  -5.37473360754873E-01  -5.37252422665611E-01   0.00000000000000E+00   1.55923092504227E-10
     -1.50381000441696E-22  -8.57853100459658E-10  -7.01930007955581E-10  -3.14659544351753E-18
      4.62475214595671E-09
      0.00000000000000E+00  -1.01166978034091E-11   0.00000000000000E+00   9.50651136067277E-12  -1.80015327577475E-23
      1.01071554034718E-08   1.01166619148325E-08  -8.68988953113465E-19  -2.21803162642767E-01  -2.21803162636890E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.87686265286189E-09   0.00000000000000E+00  -5.87686265286189E-09
      3.97464925944528E-18  -5.39758168543153E-01  -5.38422789702995E-01   0.00000000000000E+00   1.55589863720277E-10
     -1.45166552060759E-22  -4.39538912569071E-09  -4.23979926197058E-09  -3.10566030633182E-18
      4.64475214595671E-09
      0.00000000000000E+00  -1.68134649721587E-11   0.00000000000000E+00   1.65718792516296E-11   2.41405458877990E-23
      1.67968735722635E-08   1.68134454515151E-08  -8.01837170037996E-19  -2.51578834568930E-01  -2.51578834562808E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.12148207051839E-09   0.00000000000000E+00  -6.12148207051839E-09
      3.85221961803492E-18  -5.29548640770072E-01  -5.26180699846246E-01   0.00000000000000E+00   1.63260272110775E-10
     -1.39060753308055E-22  -1.08552236531074E-08  -1.06919633809967E-08  -3.05038244799692E-18
      4.66475214595672E-09
      0.00000000000000E+00  -2.54528401775847E-11   0.00000000000000E+00   2.14216101619471E-11   7.89399191936046E-23
      2.54314492711714E-08   2.54528708813334E-08  -7.48250186365120E-19  -2.75022953309793E-01  -2.75022953303388E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.40566126290843E-09   0.00000000000000E+00  -6.40566126290843E-09
      3.72410639277674E-18  -5.02658670786966E-01  -4.96658567295911E-01   0.00000000000000E+00   1.73302289051707E-10
     -1.31519736872698E-22  -1.92205119074765E-08  -1.90472096184249E-08  -2.97585620641163E-18
      4.68475214595672E-09
      0.00000000000000E+00  -3.33717852643548E-11   0.00000000000000E+00   1.96450499525170E-11   1.29577706631913E-22
      3.33521185630090E-08   3.33717636129616E-08  -7.09281144867312E-19  -2.92339304795750E-01  -2.92339304789057E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.69324392281234E-09   0.00000000000000E+00  -6.69324392281234E-09
      3.59024151432050E-18  -4.58034324774399E-01  -4.49629910460401E-01   0.00000000000000E+00   1.75844684831303E-10
     -1.22493854102482E-22  -2.68543643749804E-08  -2.66785196901492E-08  -2.88096036945319E-18
      4.70475214595672E-09
      0.00000000000000E+00  -3.79464797799245E-11   0.00000000000000E+00   1.13772871762607E-11   1.60376370693029E-22
      3.79350240417036E-08   3.79464013288800E-08  -6.84094884705458E-19  -3.04205048033970E-01  -3.04205048027005E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.96518802561917E-09   0.00000000000000E+00  -6.96518802561917E-09
      3.45093775380812E-18  -3.96972258392530E-01  -3.87212048882407E-01   0.00000000000000E+00   1.67297614991416E-10
     -1.12633811859057E-22  -3.11485109182522E-08  -3.09812133032609E-08  -2.76684286910266E-18
      4.72475214595672E-09
      0.00000000000000E+00  -3.79849627248145E-11   0.00000000000000E+00   1.40314748557228E-13   1.64342266380214E-22
      3.79848050997084E-08   3.79849454144571E-08  -6.70878819146098E-19  -3.11484907084794E-01  -3.11484907077582E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.21225226658079E-09   0.00000000000000E+00  -7.21225226658079E-09
      3.30669270847650E-18  -3.23156136868381E-01  -3.13461352449652E-01   0.00000000000000E+00   1.47724353508879E-10
     -1.02806422767067E-22  -3.09204175013852E-08  -3.07726931478764E-08  -2.63581388933040E-18
      4.74475214595672E-09
      0.00000000000000E+00  -3.53004329009757E-11   0.00000000000000E+00  -6.62014371991036E-12   1.49788200201104E-22
      3.53070025397582E-08   3.53003823960385E-08  -6.64271853647680E-19  -3.16304597223012E-01  -3.16304597215669E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34289458841104E-09   0.00000000000000E+00  -7.34289458841104E-09
      3.15983481670828E-18  -2.47078366180547E-01  -2.38270306677674E-01   0.00000000000000E+00   1.12587627678517E-10
     -9.26354290759501E-23  -2.80700754353058E-08  -2.79574878076274E-08  -2.49556296306060E-18
      4.76475214595672E-09
      0.00000000000000E+00  -3.26523654378083E-11   0.00000000000000E+00  -6.54409109046178E-12   1.31221035816925E-22
      3.26589120363595E-08   3.26523679452692E-08  -6.58015799348964E-19  -3.21055074423468E-01  -3.21055074416153E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.31497507356399E-09   0.00000000000000E+00  -7.31497507356399E-09
      3.01353531523700E-18  -1.78613974522140E-01  -1.70631249423055E-01   0.00000000000000E+00   7.45662716494420E-11
     -8.38601810889340E-23  -2.54119591433545E-08  -2.53373928717052E-08  -2.35551951588804E-18
      4.78475214595672E-09
      0.00000000000000E+00  -3.05963291506806E-11   0.00000000000000E+00  -5.07894853238963E-12   1.14241133764723E-22
      3.06014205245061E-08   3.05963415759738E-08  -6.50475448772892E-19  -3.26332854410966E-01  -3.26332854403732E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23357086867166E-09   0.00000000000000E+00  -7.23357086867166E-09
      2.86886389786357E-18  -1.18761338905407E-01  -1.11400649901615E-01   0.00000000000000E+00   4.93082242576706E-11
     -7.81558023946890E-23  -2.34120789315597E-08  -2.33627707073021E-08  -2.21838844909067E-18
      4.78975214595672E-09
      0.00000000000000E+00  -2.98222617054956E-11   0.00000000000000E+00  -7.62322192811153E-12   1.09408679836234E-22
      2.98298254936314E-08   2.98222022717034E-08  -6.48852630639207E-19  -3.27548914531432E-01  -3.27548914524187E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.24531224685045E-09   0.00000000000000E+00  -7.24531224685045E-09
      2.83263733662931E-18  -1.04390765472310E-01  -9.72776585867632E-02   0.00000000000000E+00   4.30421957013376E-11
     -7.61161904390073E-23  -2.26199322205543E-08  -2.25768900248531E-08  -2.18378470599011E-18
      4.79650214595672E-09
      0.00000000000000E+00  -2.90002513074882E-11   0.00000000000000E+00  -6.02228608311414E-12   1.03775903072788E-22
      2.90062544174450E-08   2.90002321313620E-08  -6.46009216107793E-19  -3.29442699616221E-01  -3.29442699609033E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.18775516447960E-09   0.00000000000000E+00  -7.18775516447960E-09
      2.78411998926908E-18  -8.65615097576708E-02  -7.96892207618842E-02   0.00000000000000E+00   3.61832683917046E-11
     -7.12874513483275E-23  -2.18486602352741E-08  -2.18124769668825E-08  -2.13811077316128E-18
      4.80561464595672E-09
      0.00000000000000E+00  -2.78194035212110E-11   0.00000000000000E+00  -6.38882733316595E-12   9.84918732466090E-23
      2.78257810917110E-08   2.78193922643780E-08  -6.40480721257971E-19  -3.32598535768596E-01  -3.32598535761520E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.07567381316339E-09   0.00000000000000E+00  -7.07567381316339E-09
      2.71964291164663E-18  -6.56841176361431E-02  -5.91485339437489E-02   0.00000000000000E+00   3.06859184686756E-11
     -5.76504195405976E-23  -2.07744043696831E-08  -2.07437184512145E-08  -2.07916219038866E-18
      4.81176558345672E-09
      0.00000000000000E+00  -2.67326047458344E-11   0.00000000000000E+00  -8.69441020087958E-12   9.62544036416267E-23
      2.67413100008895E-08   2.67326155906888E-08  -6.35537070995021E-19  -3.35137405252953E-01  -3.35137405245983E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97025692052013E-09   0.00000000000000E+00  -6.97025692052013E-09
      2.67676929696956E-18  -5.35772435129692E-02  -4.73508391104130E-02   0.00000000000000E+00   2.81725388830568E-11
     -4.16328353552695E-23  -1.97905312090519E-08  -1.97623586701689E-08  -2.04123222597454E-18
      4.82006934908172E-09
      0.00000000000000E+00  -2.52385664056795E-11   0.00000000000000E+00  -8.86245594195519E-12   9.66983270624332E-23
      2.52473675497893E-08   2.52385050938475E-08  -6.26073291866907E-19  -3.39526141265817E-01  -3.39526141259034E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.78248578841087E-09   0.00000000000000E+00  -6.78248578841087E-09
      2.62044912462771E-18  -4.10332751188576E-02  -3.52184393074007E-02   0.00000000000000E+00   2.36671953639815E-11
     -1.18430046606417E-23  -1.84796865008005E-08  -1.84560193054365E-08  -1.99437583276080E-18
      4.83127943267547E-09
      0.00000000000000E+00  -2.34724839539160E-11   0.00000000000000E+00  -7.75104785295191E-12   1.02871177599333E-22
      2.34801758786050E-08   2.34724248307522E-08  -6.08907937498517E-19  -3.46945415876575E-01  -3.46945415870038E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.53618076055125E-09   0.00000000000000E+00  -6.53618076055125E-09
      2.54717799191807E-18  -2.99914545090603E-02  -2.46554346270438E-02   0.00000000000000E+00   1.82162628546846E-11
      3.40448657899443E-23  -1.69544603330557E-08  -1.69362440702009E-08  -1.93827005441955E-18
      4.84641304552703E-09
      0.00000000000000E+00  -2.18652010527843E-11   0.00000000000000E+00  -5.21121256735597E-12   1.16383135816941E-22
      2.18704543693271E-08   2.18652431567599E-08  -5.81397452774101E-19  -3.58399164745362E-01  -3.58399164739068E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.29454322944979E-09   0.00000000000000E+00  -6.29454322944979E-09
      2.45191881160615E-18  -2.17839869344280E-02  -1.68781922196438E-02   0.00000000000000E+00   1.25107365425238E-11
      8.95255214332123E-23  -1.55832106638527E-08  -1.55706999273101E-08  -1.87052135883205E-18
      4.86641304552703E-09
      0.00000000000000E+00  -2.06585448953518E-11   0.00000000000000E+00  -2.94357971100760E-12   1.33110469486685E-22
      2.06614219411025E-08   2.06584783613916E-08  -5.43347903692923E-19  -3.74012818928024E-01  -3.74012818921922E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.10211841651166E-09   0.00000000000000E+00  -6.10211841651166E-09
      2.32987644327591E-18  -1.63085526653391E-02  -1.17223331835698E-02   0.00000000000000E+00   8.26714566536685E-12
      1.45442685952245E-22  -1.45646270905455E-08  -1.45563599448800E-08  -1.78652853958299E-18
      4.88641304552703E-09
      0.00000000000000E+00  -1.98180737051657E-11   0.00000000000000E+00  -2.03941389445232E-12   1.41833979657516E-22
      1.98201541151688E-08   1.98181147012745E-08  -5.06347104828399E-19  -3.89175089047719E-01  -3.89175089041747E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.97226502494638E-09   0.00000000000000E+00  -5.97226502494638E-09
      2.21043114277699E-18  -1.32455407146922E-02  -8.88317332082706E-03   0.00000000000000E+00   6.19663599069410E-12
      1.79760483384932E-22  -1.38520463123190E-08  -1.38458496763281E-08  -1.70408403794859E-18
      4.90641304552703E-09
      0.00000000000000E+00  -1.91170228260607E-11   0.00000000000000E+00  -1.69847420067894E-12   1.40207671028236E-22
      1.91186876205415E-08   1.91169891463409E-08  -4.71241827648628E-19  -4.03637909070163E-01  -4.03637909064299E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86452959865406E-09   0.00000000000000E+00  -5.86452959865406E-09
      2.09314055080391E-18  -1.12869126847572E-02  -7.11149858223283E-03   0.00000000000000E+00   5.11597596323169E-12
      1.91653413047638E-22  -1.32575755236504E-08  -1.32524595476870E-08  -1.62189872315528E-18
      4.92641304552703E-09
      0.00000000000000E+00  -1.84969790051726E-11   0.00000000000000E+00  -1.50151196476745E-12   1.29134493466179E-22
      1.84984636647946E-08   1.84969621528300E-08  -4.38022047197655E-19  -4.17423907368366E-01  -4.17423907362598E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.76810884722771E-09   0.00000000000000E+00  -5.76810884722771E-09
      1.97777837385935E-18  -9.92340402144921E-03  -5.91295770725414E-03   0.00000000000000E+00   4.41386101383409E-12
      1.83911539844506E-22  -1.27332671666162E-08  -1.27288533056022E-08  -1.53975632666170E-18
      4.94641304552703E-09
      0.00000000000000E+00  -1.79655653556899E-11   0.00000000000000E+00  -1.28568011737961E-12   1.11285314421379E-22
      1.79668541217087E-08   1.79655684415915E-08  -4.06415027107884E-19  -4.30628421314111E-01  -4.30628421308430E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.68108888387643E-09   0.00000000000000E+00  -5.68108888387643E-09
      1.86415659618182E-18  -8.93376930152120E-03  -5.06332790856614E-03   0.00000000000000E+00   3.83734935257608E-12
      1.61790938094150E-22  -1.22883169070678E-08  -1.22844795577151E-08  -1.45774156907394E-18
      4.96641304552703E-09
      0.00000000000000E+00  -1.75191080881241E-11   0.00000000000000E+00  -1.07844886244571E-12   8.99588137431287E-23
      1.75201549664893E-08   1.75190765176269E-08  -3.76126760317139E-19  -4.43348588126694E-01  -4.43348588121089E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.60481876065483E-09   0.00000000000000E+00  -5.60481876065483E-09
      1.75206022096873E-18  -8.19177088320878E-03  -4.43797204371107E-03   0.00000000000000E+00   3.36655181410649E-12
      1.31552162065600E-22  -1.19176243087863E-08  -1.19142577569721E-08  -1.37593346065159E-18
      4.98641304552703E-09
      0.00000000000000E+00  -1.72523909712734E-11   0.00000000000000E+00  -6.36933693688542E-13   6.84238161399604E-23
      1.72529987958369E-08   1.72523618621433E-08  -3.46456212191613E-19  -4.55865003022336E-01  -4.55865003016713E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62301677166381E-09   0.00000000000000E+00  -5.62301677166381E-09
      1.63959988553545E-18  -7.64025215458842E-03  -3.97621807890505E-03   0.00000000000000E+00   2.96062177809520E-12
      9.92220905630321E-23  -1.16323057122576E-08  -1.16293450904795E-08  -1.29314367334384E-18
      5.00641304552703E-09
      0.00000000000000E+00  -1.74902688406409E-11   0.00000000000000E+00   6.06269656597381E-13   4.92736994411797E-23
      1.74895930606115E-08   1.74901993302681E-08  -3.15519794092876E-19  -4.68990501511906E-01  -4.68990501505920E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.98599944153609E-09   0.00000000000000E+00  -5.98599944153609E-09
      1.51987989670473E-18  -7.29593194884670E-03  -3.67132526188203E-03   0.00000000000000E+00   2.52071101304861E-12
      6.94802120158254E-23  -1.15067205997452E-08  -1.15041998887321E-08  -1.20436010261185E-18
      5.02641304552703E-09
      0.00000000000000E+00  -1.78617808026454E-11   0.00000000000000E+00   9.38221606434868E-13   3.35128834509647E-23
      1.78608888978912E-08   1.78618271194977E-08  -2.83610149190595E-19  -4.82635882846750E-01  -4.82635882840391E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35908438882893E-09   0.00000000000000E+00  -6.35908438882893E-09
      1.39269820892815E-18  -7.06799173406020E-03  -3.44384226757072E-03   0.00000000000000E+00   2.16081167262488E-12
      4.46727654100657E-23  -1.15049035423414E-08  -1.15027427306687E-08  -1.10908805973755E-18
      5.03141304552703E-09
      0.00000000000000E+00  -1.79659327346387E-11   0.00000000000000E+00   1.04827002171180E-12   2.95445142838703E-23
      1.79649283511182E-08   1.79659766211399E-08  -2.75668453155999E-19  -4.86060571279423E-01  -4.86060571272929E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.49337836106167E-09   0.00000000000000E+00  -6.49337836106167E-09
      1.36023131712284E-18  -7.00733164693712E-03  -3.39267939314303E-03   0.00000000000000E+00   2.37585754978277E-12
      3.83252749020201E-23  -1.14749741176280E-08  -1.14725982600782E-08  -1.08456286396685E-18
      5.03816304552703E-09
      0.00000000000000E+00  -1.80732073876971E-11   0.00000000000000E+00   8.06801898347274E-13   2.48736442864569E-23
      1.80723897889461E-08   1.80731965908445E-08  -2.64906630267275E-19  -4.90712415714921E-01  -4.90712415708341E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.57999182214970E-09   0.00000000000000E+00  -6.57999182214970E-09
      1.31581637232333E-18  -6.95019650314871E-03  -3.32905106915449E-03   0.00000000000000E+00   1.90797710243207E-12
      3.09566881753585E-23  -1.14951127457971E-08  -1.14932047686947E-08  -1.05090974205606E-18
      5.04727554552703E-09
      0.00000000000000E+00  -1.81802983512811E-11   0.00000000000000E+00   6.02066044193394E-13   1.97558654500416E-23
      1.81797488806422E-08   1.81803509466864E-08  -2.50435095274162E-19  -4.96994350742806E-01  -4.96994350736159E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64709906815315E-09   0.00000000000000E+00  -6.64709906815315E-09
      1.25524468206479E-18  -6.88038057917713E-03  -3.24661678339917E-03   0.00000000000000E+00   1.79280389301879E-12
      2.29306647630157E-23  -1.15350446824266E-08  -1.15332518785335E-08  -1.00480958679062E-18
      5.05957742052703E-09
      0.00000000000000E+00  -1.83071359333647E-11   0.00000000000000E+00   5.28816143913255E-13   1.46219074098640E-23
      1.83066019463559E-08   1.83071307624999E-08  -2.31136731554287E-19  -5.05431116190673E-01  -5.05431116183973E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70006869187902E-09   0.00000000000000E+00  -6.70006869187902E-09
      1.17282127452588E-18  -6.80414900680873E-03  -3.14712892182300E-03   0.00000000000000E+00   1.64066745911455E-12
      1.49390420111363E-23  -1.16087027380800E-08  -1.16070620706209E-08  -9.41684542971591E-19
      5.06372930333953E-09
      0.00000000000000E+00  -1.83856631836771E-11   0.00000000000000E+00   9.47896662766490E-13   1.30284016866651E-23
      1.83847052704495E-08   1.83856531671122E-08  -2.24686474563613E-19  -5.08271839577199E-01  -5.08271839570452E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74755712602124E-09   0.00000000000000E+00  -6.74755712602124E-09
      1.14480620806799E-18  -6.78773574886067E-03  -3.12093745683687E-03   0.00000000000000E+00   1.51454695817218E-12
      1.24315384652670E-23  -1.16396105880490E-08  -1.16380960410908E-08  -9.20119733504374E-19
      5.06933434513641E-09
      0.00000000000000E+00  -1.85071737710027E-11   0.00000000000000E+00   1.08820438450305E-12   1.12397662380774E-23
      1.85061021912082E-08   1.85071903955927E-08  -2.16010588276598E-19  -5.12107262326012E-01  -5.12107262319228E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.78370542164442E-09   0.00000000000000E+00  -6.78370542164442E-09
      1.10678325564198E-18  -6.78669865412851E-03  -3.09299640872390E-03   0.00000000000000E+00   1.10462815069853E-12
      9.64358165606791E-24  -1.17245896020988E-08  -1.17234849739481E-08  -8.90772667365386E-19
      5.07690115156219E-09
      0.00000000000000E+00  -1.86400731057420E-11   0.00000000000000E+00   8.86825854271989E-13   9.36697595469417E-24
      1.86391885569514E-08   1.86400753828057E-08  -2.04449849586464E-19  -5.17242771946508E-01  -5.17242771939723E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.78455978842446E-09   0.00000000000000E+00  -6.78455978842446E-09
      1.05544580503884E-18  -6.79194646146213E-03  -3.05664487340054E-03   0.00000000000000E+00   9.44896981997143E-13
      6.75840084642322E-24  -1.18564604913630E-08  -1.18555155943810E-08  -8.50995955452371E-19
      5.08711634023699E-09
      0.00000000000000E+00  -1.86522884557906E-11   0.00000000000000E+00   8.05941678019540E-14   7.53483695600326E-24
      1.86522242531847E-08   1.86523048473525E-08  -1.89441498020220E-19  -5.23949585684940E-01  -5.23949585678293E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64731312011334E-09   0.00000000000000E+00  -6.64731312011334E-09
      9.87542247336373E-19  -6.77665704797773E-03  -2.99425946711419E-03   0.00000000000000E+00   9.87478542926247E-13
      4.02761466267113E-24  -1.20059792057822E-08  -1.20049917272392E-08  -7.98100749316154E-19
      5.10090684494798E-09
      0.00000000000000E+00  -1.81974733171389E-11   0.00000000000000E+00  -1.60668379182894E-12   5.84362371832271E-24
      1.81990721728921E-08   1.81974654891003E-08  -1.71362247889274E-19  -5.32080566484926E-01  -5.32080566478846E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.07984474614941E-09   0.00000000000000E+00  -6.07984474614941E-09
      9.03698119722534E-19  -6.68839811022582E-03  -2.87051376926739E-03   0.00000000000000E+00   1.09750398394192E-12
      1.70785275958127E-24  -1.21187182469348E-08  -1.21176207429508E-08  -7.32335871833260E-19
      5.11952402630781E-09
      0.00000000000000E+00  -1.63517614782164E-11   0.00000000000000E+00  -4.87437173470325E-12   4.24571199622394E-24
      1.63566550324914E-08   1.63517806607567E-08  -1.55039654327570E-19  -5.39418908326772E-01  -5.39418908322580E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.19140796518315E-09   0.00000000000000E+00  -4.19140796518315E-09
      8.25665917481677E-19  -6.44447157918265E-03  -2.61311643125953E-03   0.00000000000000E+00   8.81739594214255E-13
     -1.05568681428123E-25  -1.21612544351678E-08  -1.21603726955736E-08  -6.70626263154108E-19
      5.13952402630781E-09
      0.00000000000000E+00  -1.20088830793585E-11   0.00000000000000E+00  -1.06994374290033E-11   2.64153604401421E-24
      1.20195814663076E-08   1.20088820288786E-08  -1.56016287671674E-19  -5.38735289743689E-01  -5.38735289743838E-01
      0.00000000000000E+00   0.00000000000000E+00   1.49141577061164E-10   0.00000000000000E+00   1.49141577061164E-10
      8.28648749022900E-19  -5.99610496368955E-03  -2.16548886385265E-03   0.00000000000000E+00  -1.48464415074394E-14
     -1.48209536622581E-24  -1.21580087594981E-08  -1.21580236059396E-08  -6.72632461351224E-19
      5.15952402630781E-09
      0.00000000000000E+00  -4.95529910655769E-12   0.00000000000000E+00  -1.73898404778056E-11   5.59205976725373E-25
      4.97271500580425E-09   4.95532516532645E-09  -1.87412256883994E-19  -5.24128883798546E-01  -5.24128883805736E-01
      0.00000000000000E+00   0.00000000000000E+00   7.19008968198343E-09   0.00000000000000E+00   7.19008968198343E-09
      9.72450542662569E-19  -5.33717472043811E-03  -1.51053049287643E-03   0.00000000000000E+00  -1.67379025399967E-12
     -3.18687026764634E-24  -1.21437410570559E-08  -1.21454148473099E-08  -7.85038285778575E-19
      5.17952402630781E-09
      0.00000000000000E+00   3.20032986799627E-12   0.00000000000000E+00  -2.01273021092853E-11  -2.95491325868045E-24
     -3.18019721370161E-09  -3.20032451581089E-09  -2.59116426456162E-19  -4.92228084064528E-01  -4.92228084079850E-01
      0.00000000000000E+00   0.00000000000000E+00   1.53219344329518E-08   0.00000000000000E+00   1.53219344329518E-08
      1.27888923132160E-18  -4.56794359893153E-03  -7.48800509248221E-04   0.00000000000000E+00  -4.12722789721971E-12
     -7.21237843533961E-24  -1.21174826892438E-08  -1.21216099171410E-08  -1.01977280486544E-18
      5.19952402630781E-09
      0.00000000000000E+00   9.67602675428736E-12   0.00000000000000E+00  -1.60367746176174E-11  -1.08269683266056E-23
     -9.66004011516439E-09  -9.67607688978202E-09  -3.77025023144365E-19  -4.42793810393337E-01  -4.42793810415092E-01
      0.00000000000000E+00   0.00000000000000E+00   2.17553712422748E-08   0.00000000000000E+00   2.17553712422748E-08
      1.71399665616710E-18  -3.86056859990228E-03  -5.47640935300804E-05   0.00000000000000E+00  -7.81408429194900E-12
     -1.97655543333496E-23  -1.20714802682008E-08  -1.20792943524928E-08  -1.33697163302274E-18
      5.21952402630781E-09
      0.00000000000000E+00   1.21528037825627E-11   0.00000000000000E+00  -6.28293117075138E-12  -2.67450642966718E-23
     -1.21465424384957E-08  -1.21528253696665E-08  -5.40590444141481E-19  -3.77589021313529E-01  -3.77589021337694E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41652972915444E-08   0.00000000000000E+00   2.41652972915444E-08
      2.19730260199799E-18  -3.41538805012649E-03   3.69364250908614E-04   0.00000000000000E+00  -1.41531887952135E-11
     -4.91477005305352E-23  -1.19983187330826E-08  -1.20124719218779E-08  -1.65671215785651E-18
      5.23952402630781E-09
      0.00000000000000E+00   1.04117949440569E-11   0.00000000000000E+00   4.00229081613404E-12  -3.90434090384738E-23
     -1.04158748767004E-08  -1.04118725858843E-08  -7.26643822796568E-19  -3.01730337083384E-01  -3.01730337105511E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21262716268143E-08   0.00000000000000E+00   2.21262716268143E-08
      2.63982803453428E-18  -4.85325972248367E-03  -1.16242585237640E-03   0.00000000000000E+00  -2.50103479687474E-11
     -7.27330457957394E-23  -1.16893886929611E-08  -1.17143990409299E-08  -1.91318421173771E-18
      5.25952402630781E-09
      0.00000000000000E+00   8.03421023196561E-12   0.00000000000000E+00   5.47822365759659E-12  -4.24068232276501E-23
     -8.03966346412702E-09  -8.03418524046946E-09  -8.91545578195057E-19  -2.27226999338582E-01  -2.27226999357019E-01
      0.00000000000000E+00   0.00000000000000E+00   1.84375273709330E-08   0.00000000000000E+00   1.84375273709330E-08
      3.00857858195294E-18  -1.50589892916076E-02  -1.17812311340620E-02   0.00000000000000E+00  -4.00986619920906E-11
     -8.10956084903610E-23  -1.03632434684714E-08  -1.04033421304635E-08  -2.11703300375788E-18
      5.27952402630781E-09
      0.00000000000000E+00   6.52878314439704E-12   0.00000000000000E+00   3.25416474464204E-12  -4.42932808000121E-23
     -6.53200484958929E-09  -6.52875068484470E-09  -1.02343900523379E-18  -1.61180973757581E-01  -1.61180973772938E-01
      0.00000000000000E+00   0.00000000000000E+00   1.53569625691454E-08   0.00000000000000E+00   1.53569625691454E-08
      3.31571783333584E-18  -3.49325433242113E-02  -3.21510572780197E-02   0.00000000000000E+00  -6.22503926369187E-11
     -8.94058824649539E-23  -8.76596149166375E-09  -8.82821188430076E-09  -2.29227882810206E-18
      5.28952402630781E-09
      0.00000000000000E+00   5.75903240186076E-12   0.00000000000000E+00   3.26427540969777E-12  -4.51717953192395E-23
     -5.76232382167350E-09  -5.75905954626385E-09  -1.08102720814267E-18  -1.30447184496215E-01  -1.30447184509990E-01
      0.00000000000000E+00   0.00000000000000E+00   1.37747238224861E-08   0.00000000000000E+00   1.37747238224861E-08
      3.45346507156071E-18  -4.71316081921000E-02  -4.46061208060200E-02   0.00000000000000E+00  -8.42008955644960E-11
     -9.38150149303856E-23  -7.93146338065769E-09  -8.01566427622228E-09  -2.37243786341804E-18
      5.30302402630781E-09
      0.00000000000000E+00   4.93931812228358E-12   0.00000000000000E+00   2.45328688043192E-12  -4.62271089301429E-23
     -4.94180967716004E-09  -4.93935639027965E-09  -1.14703841020878E-18  -9.36207650291792E-02  -9.36207650413449E-02
      0.00000000000000E+00   0.00000000000000E+00   1.21657447361934E-08   0.00000000000000E+00   1.21657447361934E-08
      3.61770262549932E-18  -6.60855648711789E-02  -6.38087522598675E-02   0.00000000000000E+00  -1.02107623558613E-10
     -9.97290763247918E-23  -7.12428072235504E-09  -7.22638834591375E-09  -2.47066421529053E-18
      5.32124902630781E-09
      0.00000000000000E+00   3.68389240939390E-12   0.00000000000000E+00   2.90713784946201E-12  -4.72772089049468E-23
     -3.68679498607674E-09  -3.68388784822733E-09  -1.21292714665031E-18  -5.50202222488443E-02  -5.50202222586921E-02
      0.00000000000000E+00   0.00000000000000E+00   9.84773923147789E-09   0.00000000000000E+00   9.84773923147789E-09
      3.79717767299300E-18  -9.56599402002440E-02  -9.37178994963756E-02   0.00000000000000E+00  -1.19005194737002E-10
     -1.07410070542354E-22  -6.04484618851337E-09  -6.16385138325048E-09  -2.58425052634269E-18
      5.32624902630781E-09
      0.00000000000000E+00   3.02591671203918E-12   0.00000000000000E+00   6.01015226129134E-12  -4.74915109238027E-23
     -3.03190474937278E-09  -3.02589459711153E-09  -1.22770535289341E-18  -4.61175743614813E-02  -4.61175743701447E-02
      0.00000000000000E+00   0.00000000000000E+00   8.66339742721097E-09   0.00000000000000E+00   8.66339742721097E-09
      3.84049466012905E-18  -1.04357626676478E-01  -1.02581412494147E-01   0.00000000000000E+00  -1.29907207424802E-10
     -1.09506897826504E-22  -5.50759562267451E-09  -5.63750283009942E-09  -2.61278930723565E-18
      5.33299902630781E-09
      0.00000000000000E+00   2.27187141956538E-12   0.00000000000000E+00   5.16792646255290E-12  -4.77007125397787E-23
     -2.27707033658949E-09  -2.27190241012698E-09  -1.24255884363668E-18  -3.70065192234911E-02  -3.70065192308401E-02
      0.00000000000000E+00   0.00000000000000E+00   7.34898558238382E-09   0.00000000000000E+00   7.34898558238382E-09
      3.89010031281015E-18  -1.16899910032312E-01  -1.15300267037355E-01   0.00000000000000E+00  -1.28772710619028E-10
     -1.12167622187524E-22  -4.94831046163759E-09  -5.07708317225673E-09  -2.64754146917346E-18
      5.34211152630781E-09
      0.00000000000000E+00   1.51130515074985E-12   0.00000000000000E+00   3.89172948466578E-12  -4.78754338378718E-23
     -1.51517409445394E-09  -1.51128236496933E-09  -1.25567806333291E-18  -2.87523780064700E-02  -2.87523780124550E-02
      0.00000000000000E+00   0.00000000000000E+00   5.98499155369189E-09   0.00000000000000E+00   5.98499155369189E-09
      3.94463854834316E-18  -1.34713977379541E-01  -1.33304439589023E-01   0.00000000000000E+00  -1.26356513233474E-10
     -1.15491525967867E-22  -4.34735267548901E-09  -4.47370918872260E-09  -2.68896048501025E-18
      5.35441340130781E-09
      0.00000000000000E+00   8.92914535131575E-13   0.00000000000000E+00   2.35487157569369E-12  -4.80011365873854E-23
     -8.95243436194260E-10  -8.92888564618615E-10  -1.26579053126775E-18  -2.21279342898841E-02  -2.21279342946727E-02
      0.00000000000000E+00   0.00000000000000E+00   4.78862611500536E-09   0.00000000000000E+00   4.78862611500536E-09
      4.00354762823169E-18  -1.59184516344735E-01  -1.57957079993272E-01   0.00000000000000E+00  -1.25015487882674E-10
     -1.19635607181045E-22  -3.77072206250388E-09  -3.89573755038668E-09  -2.73775709696394E-18
      5.37102093255781E-09
      0.00000000000000E+00   4.95134978285777E-13   0.00000000000000E+00   1.12285156521611E-12  -4.80812142824297E-23
     -4.96240813920930E-10  -4.95117962355762E-10  -1.27286128902943E-18  -1.71863800028219E-02  -1.71863800066788E-02
      0.00000000000000E+00   0.00000000000000E+00   3.85691354653546E-09   0.00000000000000E+00   3.85691354653546E-09
      4.06760144048433E-18  -1.91110394664107E-01  -1.90051187060458E-01   0.00000000000000E+00  -1.24993155308182E-10
     -1.24796219333734E-22  -3.23680242887135E-09  -3.36179558417966E-09  -2.79474015145489E-18
      5.39102093255781E-09
      0.00000000000000E+00   2.90964127473445E-13   0.00000000000000E+00   4.78623039144081E-13  -4.81237354486358E-23
     -2.91474522739127E-10  -2.90995899700031E-10  -1.27732978716980E-18  -1.38079189304788E-02  -1.38079189335999E-02
      0.00000000000000E+00   0.00000000000000E+00   3.12105437591756E-09   0.00000000000000E+00   3.12105437591756E-09
      4.13002252800268E-18  -2.25759771234103E-01  -2.24868097272168E-01   0.00000000000000E+00  -1.22508701888922E-10
     -1.30378711817660E-22  -2.70754977432855E-09  -2.83005847621760E-09  -2.85269274083289E-18
      5.41102093255782E-09
      0.00000000000000E+00   2.01231819221691E-13   0.00000000000000E+00   2.11298991877109E-13  -4.81427127007203E-23
     -2.01422883951323E-10  -2.01211584959494E-10  -1.28003294984519E-18  -1.16696945505754E-02  -1.16696945530729E-02
      0.00000000000000E+00   0.00000000000000E+00   2.49743327965458E-09   0.00000000000000E+00   2.49743327965458E-09
      4.17997119359577E-18  -2.54785482859166E-01  -2.54062004471128E-01   0.00000000000000E+00  -1.12693418641627E-10
     -1.35125813726954E-22  -2.18352827605332E-09  -2.29622169469508E-09  -2.89993824375059E-18
      5.43102093255782E-09
      0.00000000000000E+00   1.59993532215512E-13   0.00000000000000E+00   9.80358026070773E-14  -4.81510596696986E-23
     -1.60078387426468E-10  -1.59980351623909E-10  -1.28193564099617E-18  -1.01965962672145E-02  -1.01965962691583E-02
      0.00000000000000E+00   0.00000000000000E+00   1.94383525284546E-09   0.00000000000000E+00   1.94383525284546E-09
      4.21884789865268E-18  -2.77450985987368E-01  -2.76888940633766E-01   0.00000000000000E+00  -9.48035241266097E-11
     -1.38886123870967E-22  -1.68905137709475E-09  -1.78385490122150E-09  -2.93691225765651E-18
      5.45102093255782E-09
      0.00000000000000E+00   1.38501863708950E-13   0.00000000000000E+00   5.23474090477575E-14  -4.81538024602467E-23
     -1.38597818734574E-10  -1.38545471325575E-10  -1.28342832057659E-18  -9.13501259779399E-03  -9.13501259926462E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47062246602042E-09   0.00000000000000E+00   1.47062246602042E-09
      4.24826034797309E-18  -2.94063676114386E-01  -2.93643975493663E-01   0.00000000000000E+00  -7.29464366075142E-11
     -1.41659417217319E-22  -1.25913055808723E-09  -1.33207699469488E-09  -2.96483202739650E-18
      5.47102093255782E-09
      0.00000000000000E+00   1.26929426820802E-13   0.00000000000000E+00   2.96728219902502E-14  -4.81536836839668E-23
     -1.26947582377955E-10  -1.26917909556013E-10  -1.28470257971204E-18  -8.34459161985360E-03  -8.34459162093025E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07664868370378E-09   0.00000000000000E+00   1.07664868370378E-09
      4.26979332164716E-18  -3.05316365788244E-01  -3.05017134728968E-01   0.00000000000000E+00  -5.03747912241802E-11
     -1.43525697640455E-22  -8.99355982923425E-10  -9.49730774147749E-10  -2.98509074193512E-18
      5.49102093255782E-09
      0.00000000000000E+00   1.19490003106992E-13   0.00000000000000E+00   2.01646247211273E-14  -4.81517699005891E-23
     -1.19499335469978E-10  -1.19479170845305E-10  -1.28583860651143E-18  -7.74902172427707E-03  -7.74902172503793E-03
      0.00000000000000E+00   0.00000000000000E+00   7.60861905111489E-10   0.00000000000000E+00   7.60861905111489E-10
      4.28501055974940E-18  -3.12145009623856E-01  -3.11942933426179E-01   0.00000000000000E+00  -2.99083236091106E-11
     -1.44624069948920E-22  -6.11474410656955E-10  -6.41382734266210E-10  -2.99917195323797E-18
      5.51102093255782E-09
      0.00000000000000E+00   1.06172516211901E-13   0.00000000000000E+00   3.65459868310741E-14  -4.81453101761611E-23
     -1.06187496729680E-10  -1.06150950742897E-10  -1.28671715340433E-18  -7.35905989654273E-03  -7.35905989713372E-03
      0.00000000000000E+00   0.00000000000000E+00   5.90981245808454E-10   0.00000000000000E+00   5.90981245808454E-10
      4.29683018466556E-18  -3.16857501944208E-01  -3.16704752610173E-01   0.00000000000000E+00  -1.93915125690286E-11
     -1.45332611929737E-22  -4.65438782496347E-10  -4.84830295065521E-10  -3.01011303126124E-18
      5.53102093255782E-09
      0.00000000000000E+00   9.27631845796020E-14   0.00000000000000E+00   3.87321323488614E-14  -4.81346722649365E-23
     -9.27759914115715E-11  -9.27372592792707E-11  -1.28733683701232E-18  -7.11588775298587E-03  -7.11588775355507E-03
      0.00000000000000E+00   0.00000000000000E+00   5.69206241881898E-10   0.00000000000000E+00   5.69206241881898E-10
      4.30821430950320E-18  -3.21654467194266E-01  -3.21504352173963E-01   0.00000000000000E+00  -1.95998342454746E-11
     -1.46033089154510E-22  -4.56869148357058E-10  -4.76468982602679E-10  -3.02087747249088E-18
      5.54102093255782E-09
      0.00000000000000E+00   8.97323082517536E-14   0.00000000000000E+00   2.10255455971074E-14  -4.81291954465940E-23
     -8.97252242918777E-11  -8.97041987463287E-11  -1.28761869585497E-18  -7.00984050564670E-03  -7.00984050620466E-03
      0.00000000000000E+00   0.00000000000000E+00   5.57955741911859E-10   0.00000000000000E+00   5.57955741911859E-10
      4.31379386692232E-18  -3.24009628555013E-01  -3.23862102660153E-01   0.00000000000000E+00  -1.92477750357424E-11
     -1.46373578853461E-22  -4.49003768129519E-10  -4.68251543165408E-10  -3.02617517106735E-18
      5.55452093255782E-09
      0.00000000000000E+00   8.38542450704719E-14   0.00000000000000E+00   2.81412563082305E-14  -4.81205674507146E-23
     -8.38582603978059E-11  -8.38301191415458E-11  -1.28792451536692E-18  -6.89396479474230E-03  -6.89396479534129E-03
      0.00000000000000E+00   0.00000000000000E+00   5.98994933166426E-10   0.00000000000000E+00   5.98994933166426E-10
      4.32188029852007E-18  -3.27731032137570E-01  -3.27568724501682E-01   0.00000000000000E+00  -2.33679727490812E-11
     -1.46922124679158E-22  -4.91796841275693E-10  -5.15164814024921E-10  -3.03395578315314E-18
      5.57274593255782E-09
      0.00000000000000E+00   7.54045292473795E-14   0.00000000000000E+00   3.05355359414086E-14  -4.81067141724389E-23
     -7.54490490446703E-11  -7.54185135087770E-11  -1.28819371266312E-18  -6.77639473169509E-03  -6.77639473239130E-03
      0.00000000000000E+00   0.00000000000000E+00   6.96206488054120E-10   0.00000000000000E+00   6.96206488054120E-10
      4.33456866176485E-18  -3.34309385368821E-01  -3.34113797480442E-01   0.00000000000000E+00  -3.22590077268478E-11
     -1.47925140499756E-22  -5.88528966818384E-10  -6.20787974545379E-10  -3.04637494910173E-18
      5.57774593255782E-09
      0.00000000000000E+00   6.64955897382494E-14   0.00000000000000E+00   9.64767900528377E-14  -4.81017364936812E-23
     -6.66000124158417E-11  -6.65035356258369E-11  -1.28822377981718E-18  -6.76430010734065E-03  -6.76430010808310E-03
      0.00000000000000E+00   0.00000000000000E+00   7.42448663367110E-10   0.00000000000000E+00   7.42448663367110E-10
      4.33828090508169E-18  -3.36359840133316E-01  -3.36146872755242E-01   0.00000000000000E+00  -3.73962357311083E-11
     -1.48240010491232E-22  -6.38548892009727E-10  -6.75945127740983E-10  -3.05005712526450E-18
      5.58449593255782E-09
      0.00000000000000E+00   5.47394633756859E-14   0.00000000000000E+00   9.73685264717385E-14  -4.80937145414671E-23
     -5.47969879120047E-11  -5.46996193855810E-11  -1.28818636006055E-18  -6.77476650803565E-03  -6.77476650890114E-03
      0.00000000000000E+00   0.00000000000000E+00   8.65487031731557E-10   0.00000000000000E+00   8.65487031731557E-10
      4.34412294254588E-18  -3.39883854010624E-01  -3.39628399595496E-01   0.00000000000000E+00  -4.90826305222577E-11
     -1.48792515432227E-22  -7.61704781823895E-10  -8.10787412346302E-10  -3.05593658248533E-18
      5.59360843255782E-09
      0.00000000000000E+00   5.05146054641397E-14   0.00000000000000E+00   3.47967749096367E-14  -4.80831029663504E-23
     -5.05240628921446E-11  -5.04892661172831E-11  -1.28810092645099E-18  -6.77730369652821E-03  -6.77730369755099E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02277398896295E-09   0.00000000000000E+00   1.02277398896295E-09
      4.35344297052030E-18  -3.45777337456059E-01  -3.45470997606689E-01   0.00000000000000E+00  -6.29623594027607E-11
     -1.49741470240080E-22  -9.09322363442755E-10  -9.72284722845666E-10  -3.06534204406931E-18
      5.60591030755782E-09
      0.00000000000000E+00   5.29025686315354E-14   0.00000000000000E+00   1.53317041143362E-15  -4.80700941057824E-23
     -5.28654523040681E-11  -5.28639191337047E-11  -1.28802159812235E-18  -6.72320363815037E-03  -6.72320363930621E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15583955718968E-09   0.00000000000000E+00   1.15583955718968E-09
      4.36766196427290E-18  -3.54929520121190E-01  -3.54582001564598E-01   0.00000000000000E+00  -7.51307043782803E-11
     -1.51251137417985E-22  -1.02784493367768E-09  -1.10297563805611E-09  -3.07964036615056E-18
      5.62251783880782E-09
      0.00000000000000E+00   6.03419923453451E-14   0.00000000000000E+00  -1.30973765942059E-14  -4.80555336970796E-23
     -6.03619029213369E-11  -6.03750002979792E-11  -1.28805177512358E-18  -6.54442696560176E-03  -6.54442696682149E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21973353265940E-09   0.00000000000000E+00   1.21973353265940E-09
      4.38791872703322E-18  -3.67936860589799E-01  -3.67571576684108E-01   0.00000000000000E+00  -8.24217027603517E-11
     -1.53445808019958E-22  -1.07693682960089E-09  -1.15935853236140E-09  -3.09986695190964E-18
      5.64251783880782E-09
      0.00000000000000E+00   7.32921002916063E-14   0.00000000000000E+00  -2.54597962948723E-14  -4.80434841344818E-23
     -7.32944378244651E-11  -7.33198976208080E-11  -1.28836431845270E-18  -6.16308655742323E-03  -6.16308655864584E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22260843663960E-09   0.00000000000000E+00   1.22260843663960E-09
      4.41237089576601E-18  -3.83351945227167E-01  -3.82989834134961E-01   0.00000000000000E+00  -8.51929468680062E-11
     -1.56113891885695E-22  -1.06409559215065E-09  -1.14928853901881E-09  -3.12400657731331E-18
      5.66251783880782E-09
      0.00000000000000E+00   9.14773582586966E-14   0.00000000000000E+00  -4.17831573038102E-14  -4.80387149214762E-23
     -9.13986819567899E-11  -9.14404651141417E-11  -1.28905510644636E-18  -5.56676887102049E-03  -5.56676887222635E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20586609275861E-09   0.00000000000000E+00   1.20586609275861E-09
      4.43648821762118E-18  -3.98096516204393E-01  -3.97745389589152E-01   0.00000000000000E+00  -8.60623397323968E-11
     -1.58744111944961E-22  -1.02836328791189E-09  -1.11442562764445E-09  -3.14743311117482E-18
      5.68251783880782E-09
      0.00000000000000E+00   1.04886689890996E-13   0.00000000000000E+00  -3.31086195803907E-14  -4.80388705823689E-23
     -1.04890743704332E-10  -1.04923852323960E-10  -1.29003004798027E-18  -4.81493475121831E-03  -4.81493475239749E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17918668950650E-09   0.00000000000000E+00   1.17918668950650E-09
      4.46007195141132E-18  -4.12135881275016E-01  -4.11797409113837E-01   0.00000000000000E+00  -8.61121439618803E-11
     -1.61316697015875E-22  -9.88150693220517E-10  -1.07426283718256E-09  -3.17004190343104E-18
      5.70251783880782E-09
      0.00000000000000E+00   1.04978534628203E-13   0.00000000000000E+00  -2.93847741350467E-16  -4.80386106620397E-23
     -1.04956787416221E-10  -1.04957081264011E-10  -1.29101943733598E-18  -4.06938472250293E-03  -4.06938472363840E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13546258577820E-09   0.00000000000000E+00   1.13546258577820E-09
      4.48278120312688E-18  -4.25554494734787E-01  -4.25229809712132E-01   0.00000000000000E+00  -8.53669038359278E-11
     -1.63813896411456E-22  -9.45138600678101E-10  -1.03050550451419E-09  -3.19176176579089E-18
      5.72251783880782E-09
      0.00000000000000E+00   9.04670661494139E-14   0.00000000000000E+00   3.77445863221814E-14  -4.80327821611958E-23
     -9.05226766833407E-11  -9.04849320970665E-11  -1.29173322682665E-18  -3.50276347083000E-03  -3.50276347190385E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07384082825279E-09   0.00000000000000E+00   1.07384082825279E-09
      4.50425801969193E-18  -4.38449437061576E-01  -4.38139608149858E-01   0.00000000000000E+00  -8.37664259967707E-11
     -1.66216915766511E-22  -8.99589470158812E-10  -9.83355896155749E-10  -3.21252479286528E-18
      5.74251783880782E-09
      0.00000000000000E+00   1.47870026904118E-14   0.00000000000000E+00   2.01388803104316E-13  -4.79970230584926E-23
     -1.49688733897049E-11  -1.47674845866486E-11  -1.29094975674826E-18  -3.84967324762671E-03  -3.84967324854515E-03
      0.00000000000000E+00   0.00000000000000E+00   9.18441817512919E-10   0.00000000000000E+00   9.18441817512919E-10
      4.52262685604219E-18  -4.50969618804055E-01  -4.50684896784319E-01   0.00000000000000E+00  -7.77001177076681E-11
     -1.68405701143880E-22  -8.25974215218451E-10  -9.03674332926287E-10  -3.23167709929394E-18
      5.76251783880782E-09
      0.00000000000000E+00  -5.17820628376036E-13   0.00000000000000E+00   1.41529252023418E-12  -4.77467960748650E-23
      5.16381141256575E-10   5.17796433776762E-10  -1.27956446363791E-18  -1.05662339201517E-02  -1.05662339201865E-02
      0.00000000000000E+00   0.00000000000000E+00   3.48113224125682E-11   0.00000000000000E+00   3.48113224125682E-11
      4.52332308249044E-18  -4.63784283833104E-01  -4.63610181560931E-01   0.00000000000000E+00  -3.69605728622232E-11
     -1.69420907469437E-22  -5.15647183326992E-10  -5.52607756189385E-10  -3.24375861885253E-18
      5.78251783880782E-09
      0.00000000000000E+00  -1.42157284249810E-12   0.00000000000000E+00   2.46749752531082E-12  -4.71632920081855E-23
      1.41911261222364E-09   1.42158010974890E-09  -1.25026310819468E-18  -2.77533068370209E-02  -2.77533068355911E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.42976854420859E-09   0.00000000000000E+00  -1.42976854420859E-09
      4.49472771160627E-18  -4.77290087433709E-01  -4.77292691063504E-01   0.00000000000000E+00   3.13645560109176E-11
     -1.68507812096851E-22  -2.31761215509922E-11   8.18843445975688E-12  -3.24446460341159E-18
      5.79251783880782E-09
      0.00000000000000E+00  -1.90017576808652E-12   0.00000000000000E+00   2.65227873589218E-12  -4.67904689211080E-23
      1.89747540678047E-09   1.90012768551631E-09  -1.23090889000924E-18  -3.89198649150975E-02  -3.89198649129066E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.19088230377296E-09   0.00000000000000E+00  -2.19088230377296E-09
      4.47281888856854E-18  -4.84142835319437E-01  -4.84234475111600E-01   0.00000000000000E+00   6.50001483407450E-11
     -1.67573029623583E-22   2.25754469916047E-10   2.90754618256624E-10  -3.24190999855931E-18
      5.80601783880782E-09
      0.00000000000000E+00  -2.32247786976673E-12   0.00000000000000E+00   1.87092107918802E-12  -4.62137418772911E-23
      2.32064365547086E-09   2.32251457655000E-09  -1.19936028826884E-18  -5.67646852847103E-02  -5.67646852818734E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.83688401297342E-09   0.00000000000000E+00  -2.83688401297342E-09
      4.43452095439340E-18  -4.93442861540882E-01  -4.93604962866122E-01   0.00000000000000E+00   9.06666582845244E-11
     -1.65805289338179E-22   4.23702778139182E-10   5.14369436423541E-10  -3.23516066612456E-18
      5.82424283880782E-09
      0.00000000000000E+00  -2.85159540081929E-12   0.00000000000000E+00   1.77156601771126E-12  -4.53137325580719E-23
      2.84983388302628E-09   2.85160544904395E-09  -1.14835851088033E-18  -8.47327471650312E-02  -8.47327471614649E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.56624421878620E-09   0.00000000000000E+00  -3.56624421878620E-09
      4.36952615350602E-18  -5.05891337015139E-01  -5.06116547938735E-01   0.00000000000000E+00   1.15314439930457E-10
     -1.62743914908231E-22   5.99324329811927E-10   7.14638769742221E-10  -3.22116764262569E-18
      5.82924283880782E-09
      0.00000000000000E+00  -3.15945895993892E-12   0.00000000000000E+00   3.35576698263172E-12  -4.50378577182755E-23
      3.15608796914369E-09   3.15944373612628E-09  -1.13299632658165E-18  -9.29708437129127E-02  -9.29708437089339E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.97881727431986E-09   0.00000000000000E+00  -3.97881727431986E-09
      4.34963206713442E-18  -5.09296908351758E-01  -5.09555122160451E-01   0.00000000000000E+00   1.26179880866551E-10
     -1.61818890555284E-22   6.93193657327364E-10   8.19373538193752E-10  -3.21663574055277E-18
      5.83599283880782E-09
      0.00000000000000E+00  -3.50066215866488E-12   0.00000000000000E+00   2.84050798845780E-12  -4.46411508435477E-23
      3.49785293732010E-09   3.50069344530851E-09  -1.11039887514246E-18  -1.04918137463898E-01  -1.04918137459490E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.40870457510736E-09   0.00000000000000E+00  -4.40870457510736E-09
      4.31987331125245E-18  -5.13894233016472E-01  -5.14180381604630E-01   0.00000000000000E+00   1.38668378220566E-10
     -1.60438572043762E-22   7.69342751578097E-10   9.08011129798502E-10  -3.20947443610999E-18
      5.84510533880782E-09
      0.00000000000000E+00  -3.95804894995837E-12   0.00000000000000E+00   2.81936926986368E-12  -4.40324117122698E-23
      3.95526235518964E-09   3.95808172445946E-09  -1.07706875080228E-18  -1.22192230937799E-01  -1.22192230932903E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.89598892474250E-09   0.00000000000000E+00  -4.89598892474250E-09
      4.27525861217573E-18  -5.20007752696918E-01  -5.20303334467846E-01   0.00000000000000E+00   1.50647886932332E-10
     -1.58396113622191E-22   7.87259313351104E-10   9.37907200283277E-10  -3.19818986137344E-18
      5.85740721380782E-09
      0.00000000000000E+00  -4.61143241045271E-12   0.00000000000000E+00   2.94457114213496E-12  -4.28660351362258E-23
      4.60853116514375E-09   4.61147573628585E-09  -1.02878621237880E-18  -1.46513516969590E-01  -1.46513516964251E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.33888343697775E-09   0.00000000000000E+00  -5.33888343697775E-09
      4.20958033549446E-18  -5.27784220762857E-01  -5.28013510457540E-01   0.00000000000000E+00   1.57304355422198E-10
     -1.55472599161476E-22   5.70103345269680E-10   7.27407700691723E-10  -3.18079412311566E-18
      5.87401474505782E-09
      0.00000000000000E+00  -5.90763718666254E-12   0.00000000000000E+00   4.12751903549426E-12  -3.89878630287836E-23
      5.90355549659168E-09   5.90768301562714E-09  -9.61751423647700E-19  -1.79003952609887E-01  -1.79003952604249E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63784302214851E-09   0.00000000000000E+00  -5.63784302214851E-09
      4.11594968132154E-18  -5.36320760785470E-01  -5.36235929959780E-01   0.00000000000000E+00   1.56513994358193E-10
     -1.51431641540828E-22  -4.26353987836549E-10  -2.69839993478507E-10  -3.15419825767383E-18
      5.89401474505782E-09
      0.00000000000000E+00  -9.14066378110468E-12   0.00000000000000E+00   8.18214647891584E-12  -2.35505526691123E-23
      9.13247284489715E-09   9.14065499137605E-09  -8.83844208209382E-19  -2.15102428618712E-01  -2.15102428612871E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.84113818190208E-09   0.00000000000000E+00  -5.84113818190208E-09
      3.99912691768349E-18  -5.40440056587740E-01  -5.39400874303702E-01   0.00000000000000E+00   1.55471711315674E-10
     -1.46311471068942E-22  -3.45498852078954E-09  -3.29951680947401E-09  -3.11528270947411E-18
      5.91401474505782E-09
      0.00000000000000E+00  -1.52524718185796E-11   0.00000000000000E+00   1.52178326755404E-11   1.42216568231512E-23
      1.52372157975453E-08   1.52524336302208E-08  -8.14356485616554E-19  -2.46084814854913E-01  -2.46084814848843E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.06996889739114E-09   0.00000000000000E+00  -6.06996889739114E-09
      3.87772753973567E-18  -5.33150539325168E-01  -5.30258149720667E-01   0.00000000000000E+00   1.61331168614997E-10
     -1.40432943964807E-22  -9.34379590144459E-09  -9.18246473282973E-09  -3.06337105411912E-18
      5.93401474505782E-09
      0.00000000000000E+00  -2.36865740363467E-11   0.00000000000000E+00   2.09167696836792E-11   6.77776521933133E-23
      2.36656787181360E-08   2.36865954878197E-08  -7.57861987304568E-19  -2.70813653407857E-01  -2.70813653401509E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.34734209201201E-09   0.00000000000000E+00  -6.34734209201201E-09
      3.75078069789543E-18  -5.09792497281329E-01  -5.04330474199959E-01   0.00000000000000E+00   1.71783920237832E-10
     -1.33204875375474E-22  -1.75110373160453E-08  -1.73392533958076E-08  -2.99291871059086E-18
      5.95401474505782E-09
      0.00000000000000E+00  -3.19891545904327E-11   0.00000000000000E+00   2.05915914156637E-11   1.20704596857690E-22
      3.19685219098719E-08   3.19891135012876E-08  -7.15982942529231E-19  -2.89312568382899E-01  -2.89312568376262E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.63663785036979E-09   0.00000000000000E+00  -6.63663785036979E-09
      3.61804794088803E-18  -4.68677592617629E-01  -4.60690979809295E-01   0.00000000000000E+00   1.76409721074782E-10
     -1.24442756166477E-22  -2.55288853719926E-08  -2.53524756509179E-08  -2.90206499835880E-18
      5.97401474505782E-09
      0.00000000000000E+00  -3.74025752461816E-11   0.00000000000000E+00   1.34530536211303E-11   1.56448598369621E-22
      3.73891523701433E-08   3.74026054237646E-08  -6.88117210433744E-19  -3.02219730759217E-01  -3.02219730752305E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.91154422793082E-09   0.00000000000000E+00  -6.91154422793082E-09
      3.47981705632942E-18  -4.10744617204510E-01  -4.01138885381145E-01   0.00000000000000E+00   1.69992684410326E-10
     -1.14671531524741E-22  -3.06610538802441E-08  -3.04910611958339E-08  -2.79169984589568E-18
      5.99401474505782E-09
      0.00000000000000E+00  -3.83273599051242E-11   0.00000000000000E+00   2.33701420446719E-12   1.65724607042624E-22
      3.83249977360496E-08   3.83273347502542E-08  -6.72747686793092E-19  -3.10315021411034E-01  -3.10315021403867E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.16715182582013E-09   0.00000000000000E+00  -7.16715182582013E-09
      3.33647401981301E-18  -3.38922481689046E-01  -3.29105670515957E-01   0.00000000000000E+00   1.52924403558061E-10
     -1.04799614009425E-22  -3.13131073279919E-08  -3.11601829244340E-08  -2.66372633301992E-18
      6.01401474505782E-09
      0.00000000000000E+00  -3.59089042849756E-11   0.00000000000000E+00  -5.95717170982657E-12   1.53515627005812E-22
      3.59148518986940E-08   3.59088947269843E-08  -6.65446352821720E-19  -3.15383623321030E-01  -3.15383623313698E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.33195221824496E-09   0.00000000000000E+00  -7.33195221824496E-09
      3.18983497544812E-18  -2.62160360283077E-01  -2.53157176753299E-01   0.00000000000000E+00   1.20886381466541E-10
     -9.47496431167209E-23  -2.86978288902057E-08  -2.85769425087393E-08  -2.52438862262640E-18
      6.03401474505782E-09
      0.00000000000000E+00  -3.31418060423872E-11   0.00000000000000E+00  -6.83727526975227E-12   1.35004319228680E-22
      3.31486290092170E-08   3.31417917339474E-08  -6.59376226982702E-19  -3.20051722491450E-01  -3.20051722484122E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32823141186488E-09   0.00000000000000E+00  -7.32823141186488E-09
      3.04327034721082E-18  -1.91879198458274E-01  -1.83746476922639E-01   0.00000000000000E+00   8.14308817530544E-11
     -8.52947263940809E-23  -2.58949912038355E-08  -2.58135603220825E-08  -2.38389412022812E-18
      6.05401474505782E-09
      0.00000000000000E+00  -3.09901593838265E-11   0.00000000000000E+00  -5.31643066705788E-12   1.17505542240227E-22
      3.09954598852174E-08   3.09901434545505E-08  -6.52148559599773E-19  -3.25205015046659E-01  -3.25205015039407E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25213448140089E-09   0.00000000000000E+00  -7.25213448140089E-09
      2.89822765758280E-18  -1.30269805802600E-01  -1.22790908608901E-01   0.00000000000000E+00   5.34776126864708E-11
     -7.94237298565995E-23  -2.37914865858361E-08  -2.37380089731497E-08  -2.24607909798303E-18
      6.05403427630782E-09
      0.00000000000000E+00  -3.09852916127545E-11   0.00000000000000E+00  -7.31063743497958E-12   1.17488318605370E-22
      3.09925656394681E-08   3.09852550020333E-08  -6.52141552644007E-19  -3.25209979636987E-01  -3.25209979629734E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25225533508073E-09   0.00000000000000E+00  -7.25225533508073E-09
      2.89808601197079E-18  -1.30209193896175E-01  -1.22731874906867E-01   0.00000000000000E+00   5.53170442101247E-11
     -7.94178562371526E-23  -2.37883167111729E-08  -2.37329996669629E-08  -2.24594445932678E-18
      6.05406064349532E-09
      0.00000000000000E+00  -3.09757397600849E-11   0.00000000000000E+00  -1.09399390386491E-11   1.17464756709474E-22
      3.09867176230009E-08   3.09757776839624E-08  -6.52132258839546E-19  -3.25216498188298E-01  -3.25216498181046E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25289003320067E-09   0.00000000000000E+00  -7.25289003320067E-09
      2.89789477365937E-18  -1.30126808545647E-01  -1.22652675650351E-01   0.00000000000000E+00   5.86663694366339E-11
     -7.94097691634432E-23  -2.37815540201583E-08  -2.37228876507218E-08  -2.24576251481982E-18
      6.05409623919845E-09
      0.00000000000000E+00  -3.09604935337084E-11   0.00000000000000E+00  -1.52107353526350E-11   1.17432450135670E-22
      3.09757452772030E-08   3.09605345418504E-08  -6.52120091327928E-19  -3.25224961377961E-01  -3.25224961370707E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25449023926455E-09   0.00000000000000E+00  -7.25449023926455E-09
      2.89763654497849E-18  -1.30014960205719E-01  -1.22546134443762E-01   0.00000000000000E+00   6.24772674401460E-11
     -7.93987557580343E-23  -2.37685215700286E-08  -2.37060443025885E-08  -2.24551645365056E-18
      6.05414429339767E-09
      0.00000000000000E+00  -3.09386344862530E-11   0.00000000000000E+00  -1.88133100793934E-11   1.17388216718590E-22
      3.09574359073194E-08   3.09386225972401E-08  -6.52104397347503E-19  -3.25235890894804E-01  -3.25235890887547E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25751038376445E-09   0.00000000000000E+00  -7.25751038376445E-09
      2.89728779112867E-18  -1.29863370048172E-01  -1.22402399902471E-01   0.00000000000000E+00   6.54155559078254E-11
     -7.93840597202923E-23  -2.37465277694105E-08  -2.36811122135027E-08  -2.24518339378117E-18
      6.05420916656661E-09
      0.00000000000000E+00  -3.09096115492955E-11   0.00000000000000E+00  -2.06900417763660E-11   1.17327885836560E-22
      3.09302692883403E-08   3.09095792465640E-08  -6.52084463285980E-19  -3.25250028102460E-01  -3.25250028095198E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26225256183938E-09   0.00000000000000E+00  -7.26225256183938E-09
      2.89681666579130E-18  -1.29658324440592E-01  -1.22207998935334E-01   0.00000000000000E+00   6.64758195146954E-11
     -7.93648365799933E-23  -2.37138025042557E-08  -2.36473266847410E-08  -2.24473220250532E-18
      6.05429674534469E-09
      0.00000000000000E+00  -3.08734247228357E-11   0.00000000000000E+00  -2.04966104395251E-11   1.17245853296594E-22
      3.08939546196744E-08   3.08734580092350E-08  -6.52059483923633E-19  -3.25268440281844E-01  -3.25268440274575E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26873550239348E-09   0.00000000000000E+00  -7.26873550239348E-09
      2.89618007881785E-18  -1.29381510435903E-01  -1.21944607342586E-01   0.00000000000000E+00   6.54146120465855E-11
     -7.93399133811120E-23  -2.36701371188633E-08  -2.36047225068168E-08  -2.24412059489421E-18
      6.05441497669509E-09
      0.00000000000000E+00  -3.08307169200342E-11   0.00000000000000E+00  -1.86397690460032E-11   1.17134110952284E-22
      3.08493841131099E-08   3.08307443440640E-08  -6.52028449126605E-19  -3.25292637523929E-01  -3.25292637516652E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27663704474511E-09   0.00000000000000E+00  -7.27663704474511E-09
      2.89531975219366E-18  -1.29008411700685E-01  -1.21587454303631E-01   0.00000000000000E+00   6.27039415714740E-11
     -7.93073821679665E-23  -2.36168112408819E-08  -2.35541072993105E-08  -2.24329130306705E-18
      6.05457458901813E-09
      0.00000000000000E+00  -3.07820392093142E-11   0.00000000000000E+00  -1.59250305077824E-11   1.16980425933392E-22
      3.07979828037369E-08   3.07820577732292E-08  -6.51989881790224E-19  -3.25324724476221E-01  -3.25324724468936E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28530822656586E-09   0.00000000000000E+00  -7.28530822656586E-09
      2.89415692722352E-18  -1.28506148965131E-01  -1.21103261104395E-01   0.00000000000000E+00   5.91505126259122E-11
     -7.92642117702166E-23  -2.35559000592786E-08  -2.34967495466528E-08  -2.24216704543330E-18
      6.05479006565424E-09
      0.00000000000000E+00  -3.07276671248874E-11   0.00000000000000E+00  -1.31345412399838E-11   1.16765718560943E-22
      3.07407486624490E-08   3.07276141212091E-08  -6.51941350209450E-19  -3.25367642132415E-01  -3.25367642125121E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29383500828360E-09   0.00000000000000E+00  -7.29383500828360E-09
      2.89258527619160E-18  -1.27830653088441E-01  -1.20447602816265E-01   0.00000000000000E+00   5.55094221290759E-11
     -7.92059189894237E-23  -2.34892885350472E-08  -2.34337791129182E-08  -2.24064392598215E-18
      6.05508095911299E-09
      0.00000000000000E+00  -3.06664985299071E-11   0.00000000000000E+00  -1.07863070706929E-11   1.16461646958817E-22
      3.06772891521944E-08   3.06665028451238E-08  -6.51878693156761E-19  -3.25425557450986E-01  -3.25425557443685E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30114726349493E-09   0.00000000000000E+00  -7.30114726349493E-09
      2.89046142021130E-18  -1.26923034925745E-01  -1.19561540155970E-01   0.00000000000000E+00   5.22912478096764E-11
     -7.91262089959256E-23  -2.34176468294366E-08  -2.33653555816271E-08  -2.23858272705454E-18
      6.05547366528230E-09
      0.00000000000000E+00  -3.05959617717318E-11   0.00000000000000E+00  -9.09059070528306E-12   1.16030157949776E-22
      3.06050760418299E-08   3.05959854511247E-08  -6.51794933679426E-19  -3.25504443897930E-01  -3.25504443890624E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30617618681733E-09   0.00000000000000E+00  -7.30617618681733E-09
      2.88759223974868E-18  -1.25704977718383E-01  -1.18367282426023E-01   0.00000000000000E+00   4.97181084746165E-11
     -7.90163172607959E-23  -2.33395273727796E-08  -2.32898092643051E-08  -2.23579730606925E-18
      6.05600381861087E-09
      0.00000000000000E+00  -3.05110972345520E-11   0.00000000000000E+00  -8.01215632551097E-12   1.15425792458255E-22
      3.05191395813972E-08   3.05111274250718E-08  -6.51678852284077E-19  -3.25612901349553E-01  -3.25612901342244E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30800550622130E-09   0.00000000000000E+00  -7.30800550622130E-09
      2.88371787630437E-18  -1.24072960684381E-01  -1.16762574746205E-01   0.00000000000000E+00   4.77572941405890E-11
     -7.88637295581950E-23  -2.32508792129930E-08  -2.32031219188525E-08  -2.23203902402029E-18
      6.05671952560443E-09
      0.00000000000000E+00  -3.04049247183401E-11   0.00000000000000E+00  -7.37687457154997E-12   1.14598899120693E-22
      3.04123074726445E-08   3.04049305980731E-08  -6.51513041099722E-19  -3.25763316067149E-01  -3.25763316059843E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30592481024345E-09   0.00000000000000E+00  -7.30592481024345E-09
      2.87848897482321E-18  -1.21891161725107E-01  -1.14613575837937E-01   0.00000000000000E+00   4.62071936162809E-11
     -7.86497546049952E-23  -2.31452129814428E-08  -2.30990057878266E-08  -2.22697593372349E-18
      6.05768573004575E-09
      0.00000000000000E+00  -3.02688108177986E-11   0.00000000000000E+00  -6.98293753243682E-12   1.13496589516910E-22
      3.02757645377006E-08   3.02687816001682E-08  -6.51270933046746E-19  -3.25973567912118E-01  -3.25973567904818E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29935805028631E-09   0.00000000000000E+00  -7.29935805028631E-09
      2.87143630265629E-18  -1.18983048229025E-01  -1.11746285062238E-01   0.00000000000000E+00   4.48075607508870E-11
     -7.83448042324624E-23  -2.30142311106334E-08  -2.29694235498826E-08  -2.22016536960954E-18
      6.05899010604152E-09
      0.00000000000000E+00  -3.00928363013089E-11   0.00000000000000E+00  -6.67762074426515E-12   1.12060867611049E-22
      3.00994598888149E-08   3.00927822680708E-08  -6.50911849926455E-19  -3.26269652995971E-01  -3.26269652988684E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28774358569330E-09   0.00000000000000E+00  -7.28774358569330E-09
      2.86193034485976E-18  -1.15122074471399E-01  -1.07937098013346E-01   0.00000000000000E+00   4.33309337199734E-11
     -7.78987110448581E-23  -2.28483696160985E-08  -2.28050386823786E-08  -2.21101849493330E-18
      6.06075101363581E-09
      0.00000000000000E+00  -2.98655205767203E-11   0.00000000000000E+00  -6.38401175599405E-12   1.10227674812257E-22
      2.98718635196974E-08   2.98654795079415E-08  -6.50372506710066E-19  -3.26689829893012E-01  -3.26689829885741E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27042948193402E-09   0.00000000000000E+00  -7.27042948193402E-09
      2.84912779037125E-18  -1.10022845942769E-01  -1.02904022931186E-01   0.00000000000000E+00   4.16164557949728E-11
     -7.72190265297089E-23  -2.26366664818025E-08  -2.25950500260076E-08  -2.19875528366118E-18
      6.06312823888811E-09
      0.00000000000000E+00  -2.95722603308167E-11   0.00000000000000E+00  -6.09624841185493E-12   1.07932491998373E-22
      2.95783757028172E-08   2.95722794544054E-08  -6.49552008420518E-19  -3.27291417116558E-01  -3.27291417109311E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.24647712731127E-09   0.00000000000000E+00  -7.24647712731127E-09
      2.83190128195401E-18  -1.03336499357431E-01  -9.63024985015357E-02   0.00000000000000E+00   3.95666864295950E-11
     -7.61181796625188E-23  -2.23653690135235E-08  -2.23258023270939E-08  -2.18234927353349E-18
      6.06633749297871E-09
      0.00000000000000E+00  -2.91905536029822E-11   0.00000000000000E+00  -5.87506183142662E-12   1.05129691085159E-22
      2.91964088763207E-08   2.91905338144894E-08  -6.48282389059552E-19  -3.28163091006417E-01  -3.28163090999203E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.21400585026544E-09   0.00000000000000E+00  -7.21400585026544E-09
      2.80874970416943E-18  -9.46611974366732E-02  -8.77372303005143E-02   0.00000000000000E+00   3.71315177195515E-11
     -7.41747563453750E-23  -2.20136594819442E-08  -2.19765279642247E-08  -2.16046731510988E-18
      6.07066998600102E-09
      0.00000000000000E+00  -2.86756720061968E-11   0.00000000000000E+00  -5.86368055647133E-12   1.01849231764334E-22
      2.86815423491167E-08   2.86756786685603E-08  -6.46257266241712E-19  -3.29452144420527E-01  -3.29452144413358E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.16817635323215E-09   0.00000000000000E+00  -7.16817635323215E-09
      2.77769363013636E-18  -8.36018667343238E-02  -7.68256605056739E-02   0.00000000000000E+00   3.42986329077745E-11
     -7.03553318686227E-23  -2.15418009482354E-08  -2.15075023153277E-08  -2.13143636389465E-18
      6.07651885158114E-09
      0.00000000000000E+00  -2.79279640005903E-11   0.00000000000000E+00  -6.30082287252878E-12   9.83898584106483E-23
      2.79343087734715E-08   2.79280079505991E-08  -6.42822732058019E-19  -3.31439359981273E-01  -3.31439359974178E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.09573924540869E-09   0.00000000000000E+00  -7.09573924540869E-09
      2.73619160509838E-18  -6.99824468995459E-02  -6.34189682932934E-02   0.00000000000000E+00   3.10664946134916E-11
     -6.20439645925315E-23  -2.08633351998039E-08  -2.08322687051905E-08  -2.09336887304037E-18
      6.08441482011430E-09
      0.00000000000000E+00  -2.67543719485525E-11   0.00000000000000E+00  -7.32005491292488E-12   9.59287214840007E-23
      2.67616593999242E-08   2.67543393450114E-08  -6.36399840751729E-19  -3.34739716289483E-01  -3.34739716282517E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.96605950044254E-09   0.00000000000000E+00  -6.96605950044254E-09
      2.68118781848276E-18  -5.44222157660961E-02  -4.81876451667161E-02   0.00000000000000E+00   2.73130431770689E-11
     -4.32992134570849E-23  -1.98155928877460E-08  -1.97882798445690E-08  -2.04478797773103E-18
      6.08974459887418E-09
      0.00000000000000E+00  -2.57373751734536E-11   0.00000000000000E+00  -9.38480654339540E-12   9.55037316039091E-23
      2.57467658007403E-08   2.57373809941970E-08  -6.30923505566854E-19  -3.37348931466694E-01  -3.37348931459841E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.85310572560927E-09   0.00000000000000E+00  -6.85310572560927E-09
      2.64466228114717E-18  -4.55574582511879E-02  -3.96076987767529E-02   0.00000000000000E+00   2.55619723197655E-11
     -2.51941179513436E-23  -1.89098372409074E-08  -1.88842752685877E-08  -2.01373877558031E-18
      6.09693980020003E-09
      0.00000000000000E+00  -2.44444768077832E-11   0.00000000000000E+00  -8.84943493055717E-12   9.76270490344626E-23
      2.44533411586981E-08   2.44444917237676E-08  -6.21379410731706E-19  -3.41610501778874E-01  -3.41610501772193E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.68085535093989E-09   0.00000000000000E+00  -6.68085535093989E-09
      2.59659218186832E-18  -3.64236586596066E-02  -3.08269635461147E-02   0.00000000000000E+00   2.14988981958143E-11
      3.88269728099543E-24  -1.77851352710237E-08  -1.77636363728279E-08  -1.97521277113661E-18
      6.10665332198992E-09
      0.00000000000000E+00  -2.30223528968619E-11   0.00000000000000E+00  -7.20135793241965E-12   1.04370284051556E-22
      2.30295700307370E-08   2.30223686728047E-08  -6.05510684224039E-19  -3.48377149198955E-01  -3.48377149192479E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.47628353123925E-09   0.00000000000000E+00  -6.47628353123925E-09
      2.53368466067013E-18  -2.81522624002036E-02  -2.29391657998948E-02   0.00000000000000E+00   1.66940493723359E-11
      4.35783104888461E-23  -1.65627791909377E-08  -1.65460851415654E-08  -1.92817397644609E-18
      6.11976657640626E-09
      0.00000000000000E+00  -2.17352407496356E-11   0.00000000000000E+00  -4.81389599910539E-12   1.16754955882580E-22
      2.17400159149301E-08   2.17352020189311E-08  -5.81277501746174E-19  -3.58436423132713E-01  -3.58436423126433E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.27993585093419E-09   0.00000000000000E+00  -6.27993585093419E-09
      2.45133426413848E-18  -2.15525711817298E-02  -1.66831452748702E-02   0.00000000000000E+00   1.18989334402618E-11
      9.11862301775560E-23  -1.54671651014373E-08  -1.54552661679969E-08  -1.87005676239231E-18
      6.13746946986834E-09
      0.00000000000000E+00  -2.07022629902626E-11   0.00000000000000E+00  -2.84474111878630E-12   1.32289808066075E-22
      2.07051226401125E-08   2.07022778989939E-08  -5.47424450564865E-19  -3.72323968581634E-01  -3.72323968575520E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.11375236032760E-09   0.00000000000000E+00  -6.11375236032760E-09
      2.34310315745011E-18  -1.66662650996234E-02  -1.20699119001064E-02   0.00000000000000E+00   8.24216206796908E-12
      1.41777246458756E-22  -1.45967677007344E-08  -1.45885255386663E-08  -1.79567870688524E-18
      6.15746946986834E-09
      0.00000000000000E+00  -1.98867735685969E-11   0.00000000000000E+00  -1.97738142477008E-12   1.42130830611993E-22
      1.98887742283947E-08   1.98867968469700E-08  -5.10225593583488E-19  -3.87566261661904E-01  -3.87566261655920E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.98377322369841E-09   0.00000000000000E+00  -5.98377322369841E-09
      2.22342769297614E-18  -1.34936752034557E-02  -9.11329468239000E-03   0.00000000000000E+00   6.22785243754379E-12
      1.78327560231040E-22  -1.39092514757094E-08  -1.39030236232717E-08  -1.71320209939265E-18
      6.17746946986834E-09
      0.00000000000000E+00  -1.91848042421198E-11   0.00000000000000E+00  -1.70011533994881E-12   1.41543331438343E-22
      1.91864731848839E-08   1.91847730695441E-08  -4.74924906285649E-19  -4.02102839222189E-01  -4.02102839216313E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.87570951527793E-09   0.00000000000000E+00  -5.87570951527793E-09
      2.10591350267058E-18  -1.14595749677855E-02  -7.26632720366967E-03   0.00000000000000E+00   5.18131567056399E-12
      1.92422357545408E-22  -1.33142448699369E-08  -1.33090635542662E-08  -1.63098859638494E-18
      6.19746946986834E-09
      0.00000000000000E+00  -1.85573209975180E-11   0.00000000000000E+00  -1.51943413813029E-12   1.31264069708191E-22
      1.85588517542491E-08   1.85573323201111E-08  -4.41531076349684E-19  -4.15953669468584E-01  -4.15953669462806E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.77836087900761E-09   0.00000000000000E+00  -5.77836087900761E-09
      1.99034628509043E-18  -1.00475993110780E-02  -6.02136273629646E-03   0.00000000000000E+00   4.47533181488471E-12
      1.86410887990849E-22  -1.27834467729187E-08  -1.27789714411036E-08  -1.54881520874075E-18
      6.21746946986834E-09
      0.00000000000000E+00  -1.80169984085261E-11   0.00000000000000E+00  -1.30746694153551E-12   1.13872249143550E-22
      1.80183042918614E-08   1.80169968249200E-08  -4.09777918340432E-19  -4.29213445240255E-01  -4.29213445234564E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.69041334938429E-09   0.00000000000000E+00  -5.69041334938429E-09
      1.87653801810275E-18  -9.02574888995964E-03  -5.14204219574289E-03   0.00000000000000E+00   3.89119139006551E-12
      1.65368698444769E-22  -1.23304746669258E-08  -1.23265834755356E-08  -1.46676009976231E-18
      6.23746946986834E-09
      0.00000000000000E+00  -1.75614485119768E-11   0.00000000000000E+00  -1.10054410020634E-12   9.26509769628583E-23
      1.75625628429377E-08   1.75614622988376E-08  -3.79373524971778E-19  -4.41978130791696E-01  -4.41978130786084E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.61210299050450E-09   0.00000000000000E+00  -5.61210299050450E-09
      1.76429595829265E-18  -8.26187313548524E-03  -4.49701516787101E-03   0.00000000000000E+00   3.41018814079336E-12
      1.35535997092070E-22  -1.19527694964741E-08  -1.19493593083332E-08  -1.38492243332088E-18
      6.25746946986834E-09
      0.00000000000000E+00  -1.72601059291989E-11   0.00000000000000E+00  -7.22127877960080E-13   7.08982156772210E-23
      1.72608448075100E-08   1.72601226796321E-08  -3.49724162845895E-19  -4.54480948385358E-01  -4.54480948379751E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.60754399309845E-09   0.00000000000000E+00  -5.60754399309845E-09
      1.65214507843069E-18  -7.68972710742083E-03  -4.01837308376574E-03   0.00000000000000E+00   3.00340297272354E-12
      1.03022541227672E-22  -1.16555820895064E-08  -1.16525786865336E-08  -1.30242091558479E-18
      6.27746946986834E-09
      0.00000000000000E+00  -1.74468262799418E-11   0.00000000000000E+00   4.79932986280625E-13   5.13451585263394E-23
      1.74463083687474E-08   1.74467883017337E-08  -3.18964396084819E-19  -4.67522993894532E-01  -4.67522993888595E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.93774152992416E-09   0.00000000000000E+00  -5.93774152992416E-09
      1.53339024783220E-18  -7.32501716587333E-03  -3.69888354090604E-03   0.00000000000000E+00   2.56804748613371E-12
      7.27356972405277E-23  -1.15116148192958E-08  -1.15090467718096E-08  -1.21442585174738E-18
      6.29746946986834E-09
      0.00000000000000E+00  -1.78293596104111E-11   0.00000000000000E+00   9.64974070616777E-13   3.51319515385242E-23
      1.78284101916078E-08   1.78293751656784E-08  -2.87091802282164E-19  -4.81140009932687E-01  -4.81140009926358E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.32905600590481E-09   0.00000000000000E+00  -6.32905600590481E-09
      1.40680912771411E-18  -7.09059772798963E-03  -3.46721204625912E-03   0.00000000000000E+00   2.18865421994893E-12
      4.72263140884525E-23  -1.15025078139936E-08  -1.15003191597736E-08  -1.11971732543194E-18
      6.30746946986834E-09
      0.00000000000000E+00  -1.80053341269008E-11   0.00000000000000E+00   8.90166191306946E-13   2.77454412853033E-23
      1.80044483469530E-08   1.80053385131444E-08  -2.71147492890971E-19  -4.88010202741484E-01  -4.88010202734971E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.51312404362206E-09   0.00000000000000E+00  -6.51312404362206E-09
      1.34167788727789E-18  -6.98661900869923E-03  -3.36578598935864E-03   0.00000000000000E+00   2.12555311695227E-12
      3.55126741388517E-23  -1.14943400226393E-08  -1.14922144695223E-08  -1.07053039438692E-18
      6.32096946986834E-09
      0.00000000000000E+00  -1.81548573590746E-11   0.00000000000000E+00   5.68304714030552E-13   2.01052501012703E-23
      1.81542504420085E-08   1.81548187467226E-08  -2.49727941833193E-19  -4.97296140624146E-01  -4.97296140617528E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.61796546598920E-09   0.00000000000000E+00  -6.61796546598920E-09
      1.25233535348703E-18  -6.87407516399295E-03  -3.23917666873899E-03   0.00000000000000E+00   1.85392672493113E-12
      2.35288407114941E-23  -1.15387072074582E-08  -1.15368532807332E-08  -1.00260741165384E-18
      6.33919446986834E-09
      0.00000000000000E+00  -1.83293623597689E-11   0.00000000000000E+00   4.92557541516140E-13   1.32240513980403E-23
      1.83289149309726E-08   1.83294074885141E-08  -2.21423521639423E-19  -5.09700564023820E-01  -5.09700564017143E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.67750905616846E-09   0.00000000000000E+00  -6.67750905616846E-09
      1.13063775093836E-18  -6.76820141165374E-03  -3.09705430027746E-03   0.00000000000000E+00   1.59203194221006E-12
      1.28416073408858E-23  -1.16534904642879E-08  -1.16518984323456E-08  -9.09214229298940E-19
      6.34419446986834E-09
      0.00000000000000E+00  -1.84501381891968E-11   0.00000000000000E+00   1.20402982470433E-12   1.15052973674598E-23
      1.84489676662952E-08   1.84501716961199E-08  -2.13766482599298E-19  -5.13092744090839E-01  -5.13092744084098E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74136519417816E-09   0.00000000000000E+00  -6.74136519417816E-09
      1.09693092496747E-18  -6.76190030254922E-03  -3.07282272045696E-03   0.00000000000000E+00   1.26930167459861E-12
      1.01235829281026E-23  -1.17100758036163E-08  -1.17088065019417E-08  -8.83164442368173E-19
      6.35094446986834E-09
      0.00000000000000E+00  -1.85979163713637E-11   0.00000000000000E+00   1.09980939513604E-12   9.67005542013979E-24
      1.85968311934116E-08   1.85979310028068E-08  -2.03517277612618E-19  -5.17652739469107E-01  -5.17652739462347E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.75969779559530E-09   0.00000000000000E+00  -6.75969779559530E-09
      1.05130296484720E-18  -6.77535084535542E-03  -3.04549430980795E-03   0.00000000000000E+00   8.45683517271554E-13
      7.26991142880930E-24  -1.18390788907288E-08  -1.18382332072116E-08  -8.47785687234585E-19
      6.36005696986834E-09
      0.00000000000000E+00  -1.86425529136466E-11   0.00000000000000E+00   2.63742116592261E-13   7.85188767851616E-24
      1.86422650210998E-08   1.86425287632164E-08  -1.90122863085874E-19  -5.23641831236906E-01  -5.23641831230253E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65254080209052E-09   0.00000000000000E+00  -6.65254080209052E-09
      9.90681686788153E-19  -6.77290760711739E-03  -2.99523723910214E-03   0.00000000000000E+00   8.87157792246292E-13
      4.52574155568458E-24  -1.19908751189180E-08  -1.19899879611257E-08  -8.00558823702279E-19
      6.37235884486834E-09
      0.00000000000000E+00  -1.83007986464974E-11   0.00000000000000E+00  -1.34899512786586E-12   6.15570347720055E-24
      1.83021612121084E-08   1.83008122169805E-08  -1.73659318539193E-19  -5.31044448986161E-01  -5.31044448979968E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19288846243538E-09   0.00000000000000E+00  -6.19288846243538E-09
      9.14497547034330E-19  -6.70573862979864E-03  -2.89090960490402E-03   0.00000000000000E+00   1.06008173112992E-12
      2.14166204950565E-24  -1.21089838362763E-08  -1.21079237545452E-08  -7.40838228495138E-19
      6.38896637611834E-09
      0.00000000000000E+00  -1.68847364882317E-11   0.00000000000000E+00  -4.18873450378295E-12   4.58411867604523E-24
      1.68889264745622E-08   1.68847377400584E-08  -1.57161374292294E-19  -5.38476639008012E-01  -5.38476639003286E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.72523225739655E-09   0.00000000000000E+00  -4.72523225739655E-09
      8.36023104656109E-19  -6.50777158044480E-03  -2.67668986512099E-03   0.00000000000000E+00   9.72871383041945E-13
      2.57011189416770E-25  -1.21604783540448E-08  -1.21595054826618E-08  -6.78861730363813E-19
      6.40896637611834E-09
      0.00000000000000E+00  -1.30679447440985E-11   0.00000000000000E+00  -9.40170926339937E-12   2.98089691410460E-24
      1.30772726846620E-08   1.30678709753986E-08  -1.53679017689409E-19  -5.39863172432710E-01  -5.39863172431803E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.07315283820061E-10   0.00000000000000E+00  -9.07315283820061E-10
      8.17876798979708E-19  -6.09919625792043E-03  -2.26778257337727E-03   0.00000000000000E+00   2.19306119428404E-13
     -1.20422032235352E-24  -1.21607749976980E-08  -1.21605556915786E-08  -6.64197781290299E-19
      6.42896637611834E-09
      0.00000000000000E+00  -6.47073727048188E-12   0.00000000000000E+00  -1.62627759641940E-11   1.03251837229891E-24
      6.48696306392983E-09   6.47070028796563E-09  -1.78348768590157E-19  -5.28287974106345E-01  -5.28287974112022E-01
      0.00000000000000E+00   0.00000000000000E+00   5.67783264925063E-09   0.00000000000000E+00   5.67783264925063E-09
      9.31433451964721E-19  -5.47660600686639E-03  -1.64897941652076E-03   0.00000000000000E+00  -1.29446317334558E-12
     -2.76237023269535E-24  -1.21472384740429E-08  -1.21485329372162E-08  -7.53084683374564E-19
      6.44896637611834E-09
      0.00000000000000E+00   1.67910548562800E-12   0.00000000000000E+00  -2.01075802473374E-11  -2.07539678140807E-24
     -1.65903881279499E-09  -1.67914639304233E-09  -2.41732537975068E-19  -4.99812100314075E-01  -4.99812100327881E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38066813674342E-08   0.00000000000000E+00   1.38066813674342E-08
      1.20756707931341E-18  -4.71554292764829E-03  -8.94532365122009E-04   0.00000000000000E+00  -3.58286460627490E-12
     -6.05701467257509E-24  -1.21239521097857E-08  -1.21275349743919E-08  -9.65834541338338E-19
      6.46896637611834E-09
      0.00000000000000E+00   8.69181855037150E-12   0.00000000000000E+00  -1.73591825598746E-11  -8.71670980247823E-24
     -8.67446910368286E-09  -8.69182828624274E-09  -3.50494365351777E-19  -4.53652944771925E-01  -4.53652944792706E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07806501911858E-08   0.00000000000000E+00   2.07806501911858E-08
      1.62318008313712E-18  -3.98316199672945E-03  -1.74350773800000E-04   0.00000000000000E+00  -6.94765500852663E-12
     -1.61429547285092E-23  -1.20818742499344E-08  -1.20888219049429E-08  -1.27268571778534E-18
      6.48896637611834E-09
      0.00000000000000E+00   1.20534277769042E-11   0.00000000000000E+00  -8.44642859722265E-12  -2.33084036774985E-23
     -1.20450010097424E-08  -1.20534474383396E-08  -5.06046516332409E-19  -3.91254007185641E-01  -3.91254007209724E-01
      0.00000000000000E+00   0.00000000000000E+00   2.40828177496125E-08   0.00000000000000E+00   2.40828177496125E-08
      2.10483643812937E-18  -3.45729392959753E-03   3.32783611061545E-04   0.00000000000000E+00  -1.26132159797896E-11
     -4.26251761438056E-23  -1.20167570952931E-08  -1.20293703112729E-08  -1.59878992179696E-18
      6.50896637611834E-09
      0.00000000000000E+00   1.09446781093349E-11   0.00000000000000E+00   2.46606822841214E-12  -3.76511925699246E-23
     -1.09471528764314E-08  -1.09446868082031E-08  -6.91228662056940E-19  -3.16678473999083E-01  -3.16678474021854E-01
      0.00000000000000E+00   0.00000000000000E+00   2.27715249124975E-08   0.00000000000000E+00   2.27715249124975E-08
      2.56026693637932E-18  -4.14976696194958E-03  -4.23505972083651E-04   0.00000000000000E+00  -2.25716253879508E-11
     -7.00249315842634E-23  -1.18042664789064E-08  -1.18268381042944E-08  -1.86903827432238E-18
      6.52896637611834E-09
      0.00000000000000E+00   8.40278316237941E-12   0.00000000000000E+00   5.89774401695960E-12  -4.19913988469461E-23
     -8.40870369483473E-09  -8.40280595081782E-09  -8.62515324486692E-19  -2.40975864133612E-01  -2.40975864152741E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91287676713489E-08   0.00000000000000E+00   1.91287676713489E-08
      2.94284228980630E-18  -1.22231405525623E-02  -8.84373506987274E-03   0.00000000000000E+00  -3.67966429368029E-11
     -7.96349225789323E-23  -1.06891650775943E-08  -1.07259617205311E-08  -2.08032696531961E-18
      6.54896637611834E-09
      0.00000000000000E+00   6.78365229014793E-12   0.00000000000000E+00   3.54925362682235E-12  -4.39702519809770E-23
     -6.78719951940537E-09  -6.78365026577859E-09  -1.00023166976911E-18  -1.73238023650159E-01  -1.73238023666046E-01
      0.00000000000000E+00   0.00000000000000E+00   1.58869620848579E-08   0.00000000000000E+00   1.58869620848579E-08
      3.26058153150346E-18  -3.05251195291860E-02  -2.76569587288325E-02   0.00000000000000E+00  -5.73072551157294E-11
     -8.77441921335158E-23  -9.04600456396342E-09  -9.10331181907924E-09  -2.26034986173435E-18
      6.55896637611834E-09
      0.00000000000000E+00   5.98368462907037E-12   0.00000000000000E+00   3.42642760749511E-12  -4.48478934412786E-23
     -5.98707877998172E-09  -5.98365235237427E-09  -1.06031133586671E-18  -1.41658436871197E-01  -1.41658436885437E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42397940850971E-08   0.00000000000000E+00   1.42397940850971E-08
      3.40297947235443E-18  -4.21183280735747E-02  -3.95170748959731E-02   0.00000000000000E+00  -7.82893222867576E-11
     -9.21327371425737E-23  -8.17785241043609E-09  -8.25614173272294E-09  -2.34266813648772E-18
      6.57246637611834E-09
      0.00000000000000E+00   5.17049132583493E-12   0.00000000000000E+00   2.43508358916107E-12  -4.59456402720271E-23
     -5.17293084470713E-09  -5.17049576111801E-09  -1.12956581149381E-18  -1.03539173808923E-01  -1.03539173821542E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26190403210287E-08   0.00000000000000E+00   1.26190403210287E-08
      3.57333651668832E-18  -6.04115894163631E-02  -5.80647833789298E-02   0.00000000000000E+00  -9.63990093890156E-11
     -9.80505803417414E-23  -7.35214555052160E-09  -7.44854455991071E-09  -2.44377070519451E-18
      6.59069137611834E-09
      0.00000000000000E+00   4.00534898962024E-12   0.00000000000000E+00   2.64153344840971E-12  -4.70978704597066E-23
     -4.00802702003902E-09  -4.00538548659066E-09  -1.20134805312783E-18  -6.19490432685762E-02  -6.19490432790041E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04278299497681E-08   0.00000000000000E+00   1.04278299497681E-08
      3.76338371752284E-18  -8.90048632574070E-02  -8.69813487403281E-02   0.00000000000000E+00  -1.15738450390536E-10
     -1.05825797460910E-22  -6.30670601278681E-09  -6.42244446317745E-09  -2.56203566439501E-18
      6.59569137611834E-09
      0.00000000000000E+00   3.38310089503925E-12   0.00000000000000E+00   5.61923439149792E-12  -4.73451939794373E-23
     -3.38875434394088E-09  -3.38313510954943E-09  -1.21791817585945E-18  -5.20558970377588E-02  -5.20558970470554E-02
      0.00000000000000E+00   0.00000000000000E+00   9.29651999568969E-09   0.00000000000000E+00   9.29651999568969E-09
      3.80986631750129E-18  -9.74256715141629E-02  -9.55625357079204E-02   0.00000000000000E+00  -1.28551309482177E-10
     -1.07966728978112E-22  -5.78483357665787E-09  -5.91338488614015E-09  -2.59194814164184E-18
      6.60244137611834E-09
      0.00000000000000E+00   2.62933113677708E-12   0.00000000000000E+00   5.11619306904326E-12  -4.75967113238338E-23
     -2.63441095046289E-09  -2.62929475739390E-09  -1.23518704142929E-18  -4.15627143600236E-02  -4.15627143680076E-02
      0.00000000000000E+00   0.00000000000000E+00   7.98399641878951E-09   0.00000000000000E+00   7.98399641878951E-09
      3.86375829332812E-18  -1.09621383789155E-01  -1.07934271993569E-01   0.00000000000000E+00  -1.28715041479072E-10
     -1.10703076817686E-22  -5.22598661991667E-09  -5.35470166139585E-09  -2.62857125189883E-18
      6.61155387611834E-09
      0.00000000000000E+00   1.79822810978617E-12   0.00000000000000E+00   4.22723038237213E-12  -4.78134231529442E-23
     -1.80240096151838E-09  -1.79817373113605E-09  -1.25092022976869E-18  -3.17753662318179E-02  -3.17753662383287E-02
      0.00000000000000E+00   0.00000000000000E+00   6.51073038888246E-09   0.00000000000000E+00   6.51073038888246E-09
      3.92308732399681E-18  -1.27139538036893E-01  -1.25654747067066E-01   0.00000000000000E+00  -1.26684608095309E-10
     -1.14124462155005E-22  -4.58587204965095E-09  -4.71255665774638E-09  -2.67216709422812E-18
      6.62385575111834E-09
      0.00000000000000E+00   1.06631739897939E-12   0.00000000000000E+00   2.78067348476513E-12  -4.79700826419763E-23
     -1.06905405265475E-09  -1.06627337917004E-09  -1.26316212700277E-18  -2.38769964738715E-02  -2.38769964790075E-02
      0.00000000000000E+00   0.00000000000000E+00   5.13605414296796E-09   0.00000000000000E+00   5.13605414296796E-09
      3.98627042005683E-18  -1.51556998218386E-01  -1.50274726604657E-01   0.00000000000000E+00  -1.24963549483957E-10
     -1.18366313068917E-22  -3.94481721431388E-09  -4.06978076379796E-09  -2.72310829305407E-18
      6.64046328236834E-09
      0.00000000000000E+00   5.74672520707495E-13   0.00000000000000E+00   1.38810806219851E-12  -4.80676993550469E-23
     -5.76057961590866E-10  -5.74669853528716E-10  -1.27154804947283E-18  -1.81284189384703E-02  -1.81284189425303E-02
      0.00000000000000E+00   0.00000000000000E+00   4.06002254573706E-09   0.00000000000000E+00   4.06002254573706E-09
      4.05369737136087E-18  -1.83856180957094E-01  -1.82758044717801E-01   0.00000000000000E+00  -1.24811076244713E-10
     -1.23627419488675E-22  -3.36054161596340E-09  -3.48535269220823E-09  -2.78214932188803E-18
      6.66046328236834E-09
      0.00000000000000E+00   3.22375027598419E-13   0.00000000000000E+00   5.92308079482781E-13  -4.81180744664747E-23
     -3.22949834726932E-10  -3.22357526647498E-10  -1.27663717386541E-18  -1.43455172802928E-02  -1.43455172835518E-02
      0.00000000000000E+00   0.00000000000000E+00   3.25898790764322E-09   0.00000000000000E+00   3.25898790764322E-09
      4.11887712951373E-18  -2.19406222040699E-01  -2.18480970774343E-01   0.00000000000000E+00  -1.23391558859387E-10
     -1.29349499640637E-22  -2.81323882213621E-09  -2.93663038099573E-09  -2.84223995564832E-18
      6.68046328236834E-09
      0.00000000000000E+00   2.13906392956330E-13   0.00000000000000E+00   2.55249481681593E-13  -4.81401573344556E-23
     -2.14190242877818E-10  -2.13934993396184E-10  -1.27958939287069E-18  -1.20214899477944E-02  -1.20214899504086E-02
      0.00000000000000E+00   0.00000000000000E+00   2.61418724493137E-09   0.00000000000000E+00   2.61418724493137E-09
      4.17116087441236E-18  -2.49624058577894E-01  -2.48867803195397E-01   0.00000000000000E+00  -1.15348865387015E-10
     -1.34276421497226E-22  -2.28490338614797E-09  -2.40025225153512E-09  -2.89157148154167E-18
      6.70046328236834E-09
      0.00000000000000E+00   1.65963440134001E-13   0.00000000000000E+00   1.13805812534106E-13  -4.81500144945504E-23
     -1.66060843256000E-10  -1.65947037443514E-10  -1.28160717809424E-18  -1.04443451850397E-02  -1.04443451870856E-02
      0.00000000000000E+00   0.00000000000000E+00   2.04591012810357E-09   0.00000000000000E+00   2.04591012810357E-09
      4.21207907697443E-18  -2.73530583347331E-01  -2.72938256728780E-01   0.00000000000000E+00  -9.87448695675803E-11
     -1.38233353298899E-22  -1.78121822109234E-09  -1.87996309066006E-09  -2.93047189888019E-18
      6.72046328236834E-09
      0.00000000000000E+00   1.41716429511214E-13   0.00000000000000E+00   5.86820309125019E-14  -4.81535828092416E-23
     -1.41820639759761E-10  -1.41761957728896E-10  -1.28316093756454E-18  -9.31592289409205E-03  -9.31592289564826E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55621048551017E-09   0.00000000000000E+00   1.55621048551017E-09
      4.24320328668463E-18  -2.91271388472803E-01  -2.90825734381508E-01   0.00000000000000E+00  -7.73328958606084E-11
     -1.41193780984960E-22  -1.33711563192059E-09  -1.41444852778134E-09  -2.96004234912010E-18
      6.74046328236834E-09
      0.00000000000000E+00   1.28582632090537E-13   0.00000000000000E+00   3.31985933060699E-14  -4.81538522414288E-23
     -1.28656644147565E-10  -1.28623445554307E-10  -1.28446688177141E-18  -8.48108742737616E-03  -8.48108742852398E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14781211508144E-09   0.00000000000000E+00   1.14781211508144E-09
      4.26615952898626E-18  -3.03512292346354E-01  -3.03191176436079E-01   0.00000000000000E+00  -5.47357634763284E-11
     -1.43229127161052E-22  -9.64452906050697E-10  -1.01918866952717E-09  -2.98169264721485E-18
      6.76046328236834E-09
      0.00000000000000E+00   1.21051363639520E-13   0.00000000000000E+00   2.03517172534027E-14  -4.81523717574045E-23
     -1.21056624668829E-10  -1.21036272951624E-10  -1.28563220677332E-18  -7.84950289096482E-03  -7.84950289177881E-03
      0.00000000000000E+00   0.00000000000000E+00   8.13984838047796E-10   0.00000000000000E+00   8.13984838047796E-10
      4.28243922574722E-18  -3.11079331463516E-01  -3.10861007782868E-01   0.00000000000000E+00  -3.34276650474756E-11
     -1.44457260806865E-22  -6.59520900048430E-10  -6.92948565096050E-10  -2.99680701897389E-18
      6.78046328236834E-09
      0.00000000000000E+00   1.09387082014164E-13   0.00000000000000E+00   3.20254599017900E-14  -4.81470417360648E-23
     -1.09382681372475E-10  -1.09350655912622E-10  -1.28657298288324E-18  -7.41835766151074E-03  -7.41835766212034E-03
      0.00000000000000E+00   0.00000000000000E+00   6.09598820887697E-10   0.00000000000000E+00   6.09598820887697E-10
      4.29463120216497E-18  -3.15971551436596E-01  -3.15813944229463E-01   0.00000000000000E+00  -2.03507747124314E-11
     -1.45202708315287E-22  -4.79897390262572E-10  -5.00248164975149E-10  -3.00805821928173E-18
      6.80046328236834E-09
      0.00000000000000E+00   9.46000793237526E-14   0.00000000000000E+00   4.17772048610835E-14  -4.81368607981455E-23
     -9.46376157806956E-11  -9.45958385758827E-11  -1.28722797506486E-18  -7.15774846596102E-03  -7.15774846652842E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67399637137145E-10   0.00000000000000E+00   5.67399637137145E-10
      4.30597919490771E-18  -3.20685085046171E-01  -3.20536124894890E-01   0.00000000000000E+00  -1.91876606785527E-11
     -1.45891539232117E-22  -4.53616137882514E-10  -4.72803798561213E-10  -3.01875121984285E-18
      6.81046328236834E-09
      0.00000000000000E+00   9.08344450982440E-14   0.00000000000000E+00   2.45592365108376E-14  -4.81314752146302E-23
     -9.08479694753353E-11  -9.08234102388726E-11  -1.28752006679836E-18  -7.04804390286846E-03  -7.04804390342048E-03
      0.00000000000000E+00   0.00000000000000E+00   5.52024261277124E-10   0.00000000000000E+00   5.52024261277124E-10
      4.31149943752049E-18  -3.22979470743338E-01  -3.22834166425411E-01   0.00000000000000E+00  -1.86047703026458E-11
     -1.46222118352258E-22  -4.42596080735641E-10  -4.61200851038433E-10  -3.02397937072213E-18
      6.82396328236834E-09
      0.00000000000000E+00   8.49563819169622E-14   0.00000000000000E+00   2.80264612709818E-14  -4.81230343430730E-23
     -8.49823515884170E-11  -8.49543251271942E-11  -1.28783970438845E-18  -6.92775859350319E-03  -6.92775859409391E-03
      0.00000000000000E+00   0.00000000000000E+00   5.90715111790433E-10   0.00000000000000E+00   5.90715111790433E-10
      4.31947409152965E-18  -3.26595343791376E-01  -3.26435999227230E-01   0.00000000000000E+00  -2.25331539589062E-11
     -1.46753136944762E-22  -4.83227632704020E-10  -5.05760786663073E-10  -3.03163438714120E-18
      6.84218828236834E-09
      0.00000000000000E+00   7.82517161008128E-14   0.00000000000000E+00   2.55278748845816E-14  -4.81100864340547E-23
     -7.82727357353073E-11  -7.82472078604708E-11  -1.28815822912202E-18  -6.79424657265096E-03  -6.79424657331790E-03
      0.00000000000000E+00   0.00000000000000E+00   6.66935038635591E-10   0.00000000000000E+00   6.66935038635591E-10
      4.33162898260879E-18  -3.32694335621753E-01  -3.32508862021337E-01   0.00000000000000E+00  -2.95275003996517E-11
     -1.47675737735564E-22  -5.59160330375274E-10  -5.88687830775073E-10  -3.04347075348677E-18
      6.84718828236834E-09
      0.00000000000000E+00   7.17307397590784E-14   0.00000000000000E+00   7.23926663353377E-14  -4.81056903893763E-23
     -7.17828174512030E-11  -7.17104247849158E-11  -1.28821367051958E-18  -6.77258018109678E-03  -6.77258018179328E-03
      0.00000000000000E+00   0.00000000000000E+00   6.96499589247494E-10   0.00000000000000E+00   6.96499589247494E-10
      4.33511148055503E-18  -3.34529518919055E-01  -3.34332670123058E-01   0.00000000000000E+00  -3.29261232852812E-11
     -1.47954735188552E-22  -5.91863041177128E-10  -6.24789164462558E-10  -3.04689781003545E-18
      6.85393828236834E-09
      0.00000000000000E+00   5.92398554988548E-14   0.00000000000000E+00   1.01400780667432E-13  -4.80981164169810E-23
     -5.93307163911378E-11  -5.92293156105184E-11  -1.28820582917508E-18  -6.77506950545636E-03  -6.77506950626094E-03
      0.00000000000000E+00   0.00000000000000E+00   8.04587573247471E-10   0.00000000000000E+00   8.04587573247471E-10
      4.34054244667445E-18  -3.37695556976200E-01  -3.37460718402168E-01   0.00000000000000E+00  -4.34101579118942E-11
     -1.48445729199874E-22  -7.01948099724919E-10  -7.45358257636962E-10  -3.05233661749937E-18
      6.86305078236834E-09
      0.00000000000000E+00   5.22596554710827E-14   0.00000000000000E+00   4.93053542688583E-14  -4.80875559326700E-23
     -5.23361319250217E-11  -5.22868265708009E-11  -1.28813527236929E-18  -6.78092036110694E-03  -6.78092036207077E-03
      0.00000000000000E+00   0.00000000000000E+00   9.63834347389694E-10   0.00000000000000E+00   9.63834347389694E-10
      4.34932538716504E-18  -3.43157556707938E-01  -3.42870354304175E-01   0.00000000000000E+00  -5.75580059811482E-11
     -1.49317064948882E-22  -8.53989514837633E-10  -9.11547520818931E-10  -3.06119011479575E-18
      6.87535265736834E-09
      0.00000000000000E+00   5.18922765222526E-14   0.00000000000000E+00   1.28461337243186E-14  -4.80740728802544E-23
     -5.19231581951294E-11  -5.19103120614531E-11  -1.28804205328081E-18  -6.74498003525210E-03  -6.74498003637169E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11959803938377E-09   0.00000000000000E+00   1.11959803938377E-09
      4.36309854229578E-18  -3.51985925610483E-01  -3.51649525792123E-01   0.00000000000000E+00  -7.16156482428618E-11
     -1.50762844796851E-22  -9.96072079079239E-10  -1.06768772732225E-09  -3.07505648901498E-18
      6.89196018861834E-09
      0.00000000000000E+00   5.80458739151569E-14   0.00000000000000E+00  -8.46343334273405E-15  -4.80586208423245E-23
     -5.80308065863833E-11  -5.80392700197741E-11  -1.28803054568481E-18  -6.59508365074819E-03  -6.59508365195685E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20865599764086E-09   0.00000000000000E+00   1.20865599764086E-09
      4.38317133454710E-18  -3.64898897938222E-01  -3.64536368500013E-01   0.00000000000000E+00  -8.09446333094885E-11
     -1.52928920950329E-22  -1.06967209431132E-09  -1.15061672762096E-09  -3.09514078886230E-18
      6.91196018861834E-09
      0.00000000000000E+00   6.99856897521354E-14   0.00000000000000E+00  -2.23639967589908E-14  -4.80452152362879E-23
     -6.99789190345392E-11  -7.00012830313462E-11  -1.28827346799478E-18  -6.25451185666051E-03  -6.25451185788384E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22333026676083E-09   0.00000000000000E+00   1.22333026676083E-09
      4.40763793988232E-18  -3.80401229637904E-01  -3.80037845524227E-01   0.00000000000000E+00  -8.47635267738419E-11
     -1.55596621032496E-22  -1.06856545695552E-09  -1.15332898372952E-09  -3.11936447188754E-18
      6.93196018861834E-09
      0.00000000000000E+00   8.78954135076031E-14   0.00000000000000E+00  -4.03624294412985E-14  -4.80390553630610E-23
     -8.77927725922352E-11  -8.78331350217245E-11  -1.28888916098824E-18  -5.70058911150435E-03  -5.70058911271382E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20947289088736E-09   0.00000000000000E+00   1.20947289088736E-09
      4.43182739770006E-18  -3.95284216211413E-01  -3.94930816586876E-01   0.00000000000000E+00  -8.59552139087765E-11
     -1.58235719812632E-22  -1.03568454195668E-09  -1.12163975586562E-09  -3.14293823671182E-18
      6.95196018861835E-09
      0.00000000000000E+00   1.03141639884053E-13   0.00000000000000E+00  -3.72911735299990E-14  -4.80386246368970E-23
     -1.03130626329594E-10  -1.03167917503172E-10  -1.28982625884330E-18  -4.96847676107618E-03  -4.96847676226172E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18553906706772E-09   0.00000000000000E+00   1.18553906706772E-09
      4.45553817904142E-18  -4.09456432956641E-01  -4.09115406026683E-01   0.00000000000000E+00  -8.61634525962890E-11
     -1.60820874462635E-22  -9.96207696968108E-10  -1.08237114956456E-09  -3.16571192019812E-18
      6.97196018861835E-09
      0.00000000000000E+00   1.06080671474693E-13   0.00000000000000E+00  -7.59131035190542E-15  -4.80388703499704E-23
     -1.06095803436749E-10  -1.06103394747149E-10  -1.29083592810049E-18  -4.20791603968178E-03  -4.20791604082721E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14542855960368E-09   0.00000000000000E+00   1.14542855960368E-09
      4.47844675023349E-18  -4.22988619321680E-01  -4.22661155374509E-01   0.00000000000000E+00  -8.55808891378294E-11
     -1.63334275747365E-22  -9.53744275718580E-10  -1.03932516485657E-09  -3.18761082213300E-18
      6.99196018861835E-09
      0.00000000000000E+00   9.46000793237526E-14   0.00000000000000E+00   2.96398243927541E-14  -4.80346053966900E-23
     -9.46725665197534E-11  -9.46429266954087E-11  -1.29163014771249E-18  -3.59049751451292E-03  -3.59049751560055E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08763440378773E-09   0.00000000000000E+00   1.08763440378773E-09
      4.50019943830925E-18  -4.35978771868634E-01  -4.35665906922353E-01   0.00000000000000E+00  -8.41708628006247E-11
     -1.65757794860466E-22  -9.08820614291528E-10  -9.92991477092318E-10  -3.20856929059675E-18
      7.01196018861835E-09
      0.00000000000000E+00   4.50957659688956E-14   0.00000000000000E+00   1.31740158387704E-13  -4.80110343739186E-23
     -4.52471209807851E-11  -4.51153808224454E-11  -1.29144945813930E-18  -3.57198572368192E-03  -3.57198572465537E-03
      0.00000000000000E+00   0.00000000000000E+00   9.73455615959042E-10   0.00000000000000E+00   9.73455615959042E-10
      4.51966855062843E-18  -4.48546061348490E-01  -4.48253567278423E-01   0.00000000000000E+00  -8.00494124163766E-11
     -1.68020605984018E-22  -8.48290822720018E-10  -9.28340235136563E-10  -3.22821909248913E-18
      7.03196018861835E-09
      0.00000000000000E+00  -3.56816804051241E-13   0.00000000000000E+00   1.06706182689835E-12  -4.78251058771609E-23
      3.55733771669540E-10   3.56800833496390E-10  -1.28326880339758E-18  -8.37179242286444E-03  -8.37179242316260E-03
      0.00000000000000E+00   0.00000000000000E+00   2.98152040982775E-10   0.00000000000000E+00   2.98152040982775E-10
      4.52563159144808E-18  -4.61226730541661E-01  -4.61020379611359E-01   0.00000000000000E+00  -4.92850217816751E-11
     -1.69385310612502E-22  -6.05667852697329E-10  -6.54952874479173E-10  -3.24236278805050E-18
      7.05196018861835E-09
      0.00000000000000E+00  -1.25799736553149E-12   0.00000000000000E+00   2.43821148953653E-12  -4.72968735216733E-23
      1.25554983914528E-09   1.25798805063476E-09  -1.25719363245766E-18  -2.37201461790273E-02  -2.37201461778609E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.16649596285274E-09   0.00000000000000E+00  -1.16649596285274E-09
      4.50230167219103E-18  -4.74631767108295E-01  -4.74602961521754E-01   0.00000000000000E+00   1.92763559014167E-11
     -1.68814131284015E-22  -1.10768443683340E-10  -9.14920877820926E-11  -3.24510803973337E-18
      7.07196018861835E-09
      0.00000000000000E+00  -1.99670458689163E-12   0.00000000000000E+00   2.12495812165164E-12  -4.65369976451764E-23
      1.99457320362837E-09   1.99669816174997E-09  -1.21671258954757E-18  -4.69847064954012E-02  -4.69847064930636E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.33755518768495E-09   0.00000000000000E+00  -2.33755518768495E-09
      4.45555056843733E-18  -4.88341674518129E-01  -4.88449102096432E-01   0.00000000000000E+00   7.09781835555274E-11
     -1.66768880037006E-22   2.69878842379598E-10   3.40857025934959E-10  -3.23883797888976E-18
      7.07321018861835E-09
      0.00000000000000E+00  -2.13456353744013E-12   0.00000000000000E+00   5.60097656180655E-12  -4.64800613497249E-23
      2.12892174367199E-09   2.13452272023375E-09  -1.21401257027291E-18  -4.85194215222097E-02  -4.85194215196674E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.54226858301573E-09   0.00000000000000E+00  -2.54226858301573E-09
      4.45237273270856E-18  -4.89193949480799E-01  -4.89322453539455E-01   0.00000000000000E+00   7.91845948220811E-11
     -1.66626836588100E-22   3.28561267962140E-10   4.07745862784055E-10  -3.23836016243564E-18
      7.07489768861835E-09
      0.00000000000000E+00  -2.22980652992433E-12   0.00000000000000E+00   3.16661063881423E-12  -4.64083280447821E-23
      2.22664236729575E-09   2.22980897793451E-09  -1.21021121500029E-18  -5.06687976864518E-02  -5.06687976837577E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.69410865397895E-09   0.00000000000000E+00  -2.69410865397895E-09
      4.44782642435497E-18  -4.90349015859786E-01  -4.90495339576923E-01   0.00000000000000E+00   8.47564461966423E-11
     -1.66420788925535E-22   3.79543229849247E-10   4.64299676045723E-10  -3.23761520935468E-18
      7.07717581361835E-09
      0.00000000000000E+00  -2.32266155924114E-12   0.00000000000000E+00   2.34560752910150E-12  -4.63100408631247E-23
      2.32029510994405E-09   2.32264071747311E-09  -1.20487700694813E-18  -5.36724562226350E-02  -5.36724562197971E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.83791190316936E-09   0.00000000000000E+00  -2.83791190316936E-09
      4.44136130630056E-18  -4.91913681894801E-01  -4.92076066544685E-01   0.00000000000000E+00   9.00415273116037E-11
     -1.66124405256148E-22   4.25229658384429E-10   5.15271185695866E-10  -3.23648429935243E-18
      7.08025128236835E-09
      0.00000000000000E+00  -2.43241602020414E-12   0.00000000000000E+00   2.08961560765198E-12  -4.61727681151653E-23
      2.43032537510528E-09   2.43241499071289E-09  -1.19735750135850E-18  -5.78853806795617E-02  -5.78853806765590E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.00272864259272E-09   0.00000000000000E+00  -3.00272864259272E-09
      4.43212650819554E-18  -4.94030940563724E-01  -4.94210669182134E-01   0.00000000000000E+00   9.61013914992467E-11
     -1.65696612748914E-22   4.74212260380441E-10   5.70313651879522E-10  -3.23476900683704E-18
      7.08440316518085E-09
      0.00000000000000E+00  -2.56972390232939E-12   0.00000000000000E+00   1.96393960863126E-12  -4.59798656905639E-23
      2.56772703059859E-09   2.56969097020717E-09  -1.18667918555949E-18  -6.38265809060511E-02  -6.38265809028476E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.20342827922540E-09   0.00000000000000E+00  -3.20342827922540E-09
      4.41882624938195E-18  -4.96892124100278E-01  -4.97091837908836E-01   0.00000000000000E+00   1.03224046298827E-10
     -1.65075068553678E-22   5.30513262719478E-10   6.33737309018139E-10  -3.23214706382246E-18
      7.09000820697772E-09
      0.00000000000000E+00  -2.75019881094218E-12   0.00000000000000E+00   1.92652047689018E-12  -4.57063228435306E-23
      2.74828735390647E-09   2.75021387438332E-09  -1.17135450518830E-18  -7.22695810959095E-02  -7.22695810924512E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.45825331014364E-09   0.00000000000000E+00  -3.45825331014364E-09
      4.39944259503441E-18  -5.00752698347019E-01  -5.00975825759129E-01   0.00000000000000E+00   1.11759599415832E-10
     -1.64163973389212E-22   5.96279836344896E-10   7.08039435760564E-10  -3.22808808984611E-18
      7.09757501340350E-09
      0.00000000000000E+00  -3.01112970934876E-12   0.00000000000000E+00   2.04308726824210E-12  -4.53118873273866E-23
      3.00905429890231E-09   3.01109738617050E-09  -1.14896624626864E-18  -8.44329794763033E-02  -8.44329794724942E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.80904487041022E-09   0.00000000000000E+00  -3.80904487041022E-09
      4.37062028983290E-18  -5.05953572309034E-01  -5.06205032232242E-01   0.00000000000000E+00   1.22744813875732E-10
     -1.62807229500022E-22   6.75202670364090E-10   7.97947484239659E-10  -3.22165404356426E-18
      7.10268260774091E-09
      0.00000000000000E+00  -3.24698699449769E-12   0.00000000000000E+00   2.61685704673803E-12  -4.50274500840857E-23
      3.24437659951478E-09   3.24699345656147E-09  -1.13282931946134E-18  -9.30823310667126E-02  -9.30823310625958E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.11674418338482E-09   0.00000000000000E+00  -4.11674418338482E-09
      4.34959363055331E-18  -5.09458236673566E-01  -5.09732323952082E-01   0.00000000000000E+00   1.31324824723226E-10
     -1.61823121899675E-22   7.38425902099861E-10   8.69750726822925E-10  -3.21676431109197E-18
      7.10957786009640E-09
      0.00000000000000E+00  -3.56495347471015E-12   0.00000000000000E+00   2.62300426754736E-12  -4.46159748311593E-23
      3.56232991957999E-09   3.56495292384749E-09  -1.10932930587893E-18  -1.05498290504656E-01  -1.05498290500152E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.50404629420092E-09   0.00000000000000E+00  -4.50404629420092E-09
      4.31853709473397E-18  -5.14171728186736E-01  -5.14467670893019E-01   0.00000000000000E+00   1.42050260353822E-10
     -1.60378086309266E-22   7.97043109999628E-10   9.39093370353289E-10  -3.20920778885504E-18
      7.11888645077631E-09
      0.00000000000000E+00  -4.01003307121783E-12   0.00000000000000E+00   2.70353294271611E-12  -4.39842718241237E-23
      4.00737679811530E-09   4.01008033105797E-09  -1.07491364338471E-18  -1.23310549922657E-01  -1.23310549917699E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.95861580077968E-09   0.00000000000000E+00  -4.95861580077968E-09
      4.27237936990555E-18  -5.20417091145899E-01  -5.20716022906264E-01   0.00000000000000E+00   1.52488957090004E-10
     -1.58264729832259E-22   7.96046512632006E-10   9.48535469721852E-10  -3.19746572652084E-18
      7.13145304819420E-09
      0.00000000000000E+00  -4.67048857647715E-12   0.00000000000000E+00   2.91545975004481E-12  -4.27470024975622E-23
      4.66761370503236E-09   4.67052916478236E-09  -1.02534024274220E-18  -1.48229330951421E-01  -1.48229330946048E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.37349607140058E-09   0.00000000000000E+00  -5.37349607140058E-09
      4.20485280804967E-18  -5.28314411765070E-01  -5.28536003845547E-01   0.00000000000000E+00   1.57843187323291E-10
     -1.55264456139403E-22   5.45123719294938E-10   7.02966906618073E-10  -3.17951256530747E-18
      7.14841795470835E-09
      0.00000000000000E+00  -6.04200603719715E-12   0.00000000000000E+00   4.26130767494881E-12  -3.84778870189470E-23
      6.03775024629493E-09   6.04201155396984E-09  -9.56849843188569E-19  -1.81331186299999E-01  -1.81331186294345E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.65454268557903E-09   0.00000000000000E+00  -5.65454268557903E-09
      4.10892402000857E-18  -5.36818994298603E-01  -5.36697111058181E-01   0.00000000000000E+00   1.56407673824291E-10
     -1.51129034169148E-22  -5.43876542214885E-10  -3.87468868390745E-10  -3.15207417682000E-18
      7.16841795470835E-09
      0.00000000000000E+00  -9.42804596382704E-12   0.00000000000000E+00   8.55496546296066E-12  -2.19445937139031E-23
      9.41946173626344E-09   9.42801670172638E-09  -8.79286412448111E-19  -2.17168801510535E-01  -2.17168801504681E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.85432385222648E-09   0.00000000000000E+00  -5.85432385222648E-09
      3.99183754296404E-18  -5.40398433058953E-01  -5.39272883560894E-01   0.00000000000000E+00   1.55563298015574E-10
     -1.45980892294697E-22  -3.72925614751541E-09  -3.57369284949998E-09  -3.11255113051593E-18
      7.18841795470835E-09
      0.00000000000000E+00  -1.57209718230751E-11   0.00000000000000E+00   1.56617709770289E-11   1.72160735950996E-23
      1.57053423795954E-08   1.57210041505725E-08  -8.10489433954006E-19  -2.47786922374356E-01  -2.47786922368271E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.08579030133737E-09   0.00000000000000E+00  -6.08579030133737E-09
      3.87012173693729E-18  -5.32233921419740E-01  -5.29198906430784E-01   0.00000000000000E+00   1.61928828909630E-10
     -1.40035479086259E-22  -9.79714267814456E-09  -9.63521384923507E-09  -3.05963230298328E-18
      7.20841795470835E-09
      0.00000000000000E+00  -2.42300193464037E-11   0.00000000000000E+00   2.11008901410947E-11   7.12238611947708E-23
      2.42089321489821E-08   2.42300330391233E-08  -7.54876090446748E-19  -2.72122179440442E-01  -2.72122179434077E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.36512087957062E-09   0.00000000000000E+00  -6.36512087957062E-09
      3.74281931934588E-18  -5.07801692073506E-01  -5.02174064965869E-01   0.00000000000000E+00   1.72326911976485E-10
     -1.32712230753082E-22  -1.80372390715290E-08  -1.78649121595526E-08  -2.98794322889913E-18
      7.22841795470835E-09
      0.00000000000000E+00  -3.24287235027080E-11   0.00000000000000E+00   2.03354707205494E-11   1.23526331042814E-22
      3.24083817123266E-08   3.24287171830472E-08  -7.13885935740877E-19  -2.90257468580800E-01  -2.90257468574146E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65390993000836E-09   0.00000000000000E+00  -6.65390993000836E-09
      3.60974112074571E-18  -4.65611348086466E-01  -4.57491671457405E-01   0.00000000000000E+00   1.76335192207276E-10
     -1.23866174417616E-22  -2.59511424452461E-08  -2.57748072530390E-08  -2.89585518500483E-18
      7.24841795470835E-09
      0.00000000000000E+00  -3.75951736601058E-11   0.00000000000000E+00   1.28419195995551E-11   1.57801674255778E-22
      3.75823552493983E-08   3.75951971689980E-08  -6.86838684579486E-19  -3.02845111701669E-01  -3.02845111694741E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.92783221485696E-09   0.00000000000000E+00  -6.92783221485696E-09
      3.47118447644857E-18  -4.06714624985171E-01  -3.97053332492510E-01   0.00000000000000E+00   1.69260234762058E-10
     -1.14062659812144E-22  -3.08366251889030E-08  -3.06673649541411E-08  -2.78434579186909E-18
      7.26841795470835E-09
      0.00000000000000E+00  -3.82450670205862E-11   0.00000000000000E+00   1.65567073618579E-12   1.65431387164738E-22
      3.82433747215389E-08   3.82450303922752E-08  -6.72141854973806E-19  -3.10684710089997E-01  -3.10684710082816E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.18119278376968E-09   0.00000000000000E+00  -7.18119278376968E-09
      3.32756062077318E-18  -3.34240958292396E-01  -3.24454484928307E-01   0.00000000000000E+00   1.51464209906567E-10
     -1.04203619792107E-22  -3.12153018184119E-08  -3.10638376085054E-08  -2.65541876579937E-18
      7.28841795470835E-09
      0.00000000000000E+00  -3.57290722895232E-11   0.00000000000000E+00  -6.19988570791054E-12   1.52422534643592E-22
      3.57352603651808E-08   3.57290604794731E-08  -6.65087789106106E-19  -3.15663385318482E-01  -3.15663385311146E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.33615992460198E-09   0.00000000000000E+00  -7.33615992460198E-09
      3.18083742228114E-18  -2.57619726159896E-01  -2.48674514172164E-01   0.00000000000000E+00   1.18449128728256E-10
     -9.41136990270875E-23  -2.85113496835993E-08  -2.83929005548711E-08  -2.51574963317503E-18
      7.30841795470835E-09
      0.00000000000000E+00  -3.29933849470598E-11   0.00000000000000E+00  -6.76012750642241E-12   1.33857726357433E-22
      3.30001136847910E-08   3.29933535572847E-08  -6.58971722421087E-19  -3.20352310666958E-01  -3.20352310659634E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32453897011315E-09   0.00000000000000E+00  -7.32453897011315E-09
      3.03434664287888E-18  -1.87875825387153E-01  -1.79788699701876E-01   0.00000000000000E+00   7.93202270835710E-11
     -8.48428933466790E-23  -2.57481348142551E-08  -2.56688145871716E-08  -2.37537492045779E-18
      7.32841795470835E-09
      0.00000000000000E+00  -3.08722307412520E-11   0.00000000000000E+00  -5.24075758887906E-12   1.16503036042650E-22
      3.08774398126805E-08   3.08721990550917E-08  -6.51655590949833E-19  -3.25540933163028E-01  -3.25540933155781E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.24670464848628E-09   0.00000000000000E+00  -7.24670464848628E-09
      2.88941254990915E-18  -1.26786676172790E-01  -1.19343223354223E-01   0.00000000000000E+00   5.21872026395958E-11
     -7.90697275831373E-23  -2.36776816092451E-08  -2.36254944066056E-08  -2.23775695895932E-18
}
